/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.FixedBitSet;

class TermsIncludingScoreQuery
extends Query {
    final String field;
    final boolean multipleValuesPerDocument;
    final BytesRefHash terms;
    final float[] scores;
    final int[] ords;
    final Query originalQuery;
    final Query unwrittenOriginalQuery;

    TermsIncludingScoreQuery(String field, boolean multipleValuesPerDocument, BytesRefHash terms, float[] scores, Query originalQuery) {
        this.field = field;
        this.multipleValuesPerDocument = multipleValuesPerDocument;
        this.terms = terms;
        this.scores = scores;
        this.originalQuery = originalQuery;
        this.ords = terms.sort(BytesRef.getUTF8SortedAsUnicodeComparator());
        this.unwrittenOriginalQuery = originalQuery;
    }

    private TermsIncludingScoreQuery(String field, boolean multipleValuesPerDocument, BytesRefHash terms, float[] scores, int[] ords, Query originalQuery, Query unwrittenOriginalQuery) {
        this.field = field;
        this.multipleValuesPerDocument = multipleValuesPerDocument;
        this.terms = terms;
        this.scores = scores;
        this.originalQuery = originalQuery;
        this.ords = ords;
        this.unwrittenOriginalQuery = unwrittenOriginalQuery;
    }

    public String toString(String string) {
        return String.format(Locale.ROOT, "TermsIncludingScoreQuery{field=%s;originalQuery=%s}", this.field, this.unwrittenOriginalQuery);
    }

    public void extractTerms(Set<Term> terms) {
        this.originalQuery.extractTerms(terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query originalQueryRewrite = this.originalQuery.rewrite(reader);
        if (originalQueryRewrite != this.originalQuery) {
            TermsIncludingScoreQuery rewritten = new TermsIncludingScoreQuery(this.field, this.multipleValuesPerDocument, this.terms, this.scores, this.ords, originalQueryRewrite, this.originalQuery);
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TermsIncludingScoreQuery other = (TermsIncludingScoreQuery)((Object)obj);
        if (!this.field.equals(other.field)) {
            return false;
        }
        return this.unwrittenOriginalQuery.equals((Object)other.unwrittenOriginalQuery);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result += 31 * this.field.hashCode();
        return result += 31 * this.unwrittenOriginalQuery.hashCode();
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        final Weight originalWeight = this.originalQuery.createWeight(searcher);
        return new Weight(){
            private TermsEnum segmentTermsEnum;

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                Terms terms = context.reader().terms(TermsIncludingScoreQuery.this.field);
                if (terms != null) {
                    this.segmentTermsEnum = terms.iterator(this.segmentTermsEnum);
                    BytesRef spare = new BytesRef();
                    DocsEnum docsEnum = null;
                    for (int i = 0; i < TermsIncludingScoreQuery.this.terms.size(); ++i) {
                        if (!this.segmentTermsEnum.seekExact(TermsIncludingScoreQuery.this.terms.get(TermsIncludingScoreQuery.this.ords[i], spare)) || (docsEnum = this.segmentTermsEnum.docs(null, docsEnum, 0)).advance(doc) != doc) continue;
                        float score = TermsIncludingScoreQuery.this.scores[TermsIncludingScoreQuery.this.ords[i]];
                        return new ComplexExplanation(true, score, "Score based on join value " + this.segmentTermsEnum.term().utf8ToString());
                    }
                }
                return new ComplexExplanation(false, 0.0f, "Not a match");
            }

            public Query getQuery() {
                return TermsIncludingScoreQuery.this;
            }

            public float getValueForNormalization() throws IOException {
                return originalWeight.getValueForNormalization() * TermsIncludingScoreQuery.this.getBoost() * TermsIncludingScoreQuery.this.getBoost();
            }

            public void normalize(float norm, float topLevelBoost) {
                originalWeight.normalize(norm, topLevelBoost * TermsIncludingScoreQuery.this.getBoost());
            }

            public Scorer scorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
                Terms terms = context.reader().terms(TermsIncludingScoreQuery.this.field);
                if (terms == null) {
                    return null;
                }
                long cost = (long)context.reader().maxDoc() * terms.size();
                this.segmentTermsEnum = terms.iterator(this.segmentTermsEnum);
                if (TermsIncludingScoreQuery.this.multipleValuesPerDocument) {
                    return new MVInOrderScorer(this, acceptDocs, this.segmentTermsEnum, context.reader().maxDoc(), cost);
                }
                return new SVInOrderScorer(this, acceptDocs, this.segmentTermsEnum, context.reader().maxDoc(), cost);
            }
        };
    }

    class MVInOrderScorer
    extends SVInOrderScorer {
        MVInOrderScorer(Weight weight, Bits acceptDocs, TermsEnum termsEnum, int maxDoc, long cost) throws IOException {
            super(weight, acceptDocs, termsEnum, maxDoc, cost);
        }

        @Override
        protected void fillDocsAndScores(FixedBitSet matchingDocs, Bits acceptDocs, TermsEnum termsEnum) throws IOException {
            BytesRef spare = new BytesRef();
            DocsEnum docsEnum = null;
            for (int i = 0; i < TermsIncludingScoreQuery.this.terms.size(); ++i) {
                if (!termsEnum.seekExact(TermsIncludingScoreQuery.this.terms.get(TermsIncludingScoreQuery.this.ords[i], spare))) continue;
                docsEnum = termsEnum.docs(acceptDocs, docsEnum, 0);
                float score = TermsIncludingScoreQuery.this.scores[TermsIncludingScoreQuery.this.ords[i]];
                int doc = docsEnum.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if (!matchingDocs.get(doc)) {
                        this.scores[doc] = score;
                        matchingDocs.set(doc);
                    }
                    doc = docsEnum.nextDoc();
                }
            }
        }
    }

    class SVInOrderScorer
    extends Scorer {
        final DocIdSetIterator matchingDocsIterator;
        final float[] scores;
        final long cost;
        int currentDoc;

        SVInOrderScorer(Weight weight, Bits acceptDocs, TermsEnum termsEnum, int maxDoc, long cost) throws IOException {
            super(weight);
            this.currentDoc = -1;
            FixedBitSet matchingDocs = new FixedBitSet(maxDoc);
            this.scores = new float[maxDoc];
            this.fillDocsAndScores(matchingDocs, acceptDocs, termsEnum);
            this.matchingDocsIterator = new BitSetIterator((BitSet)matchingDocs, cost);
            this.cost = cost;
        }

        protected void fillDocsAndScores(FixedBitSet matchingDocs, Bits acceptDocs, TermsEnum termsEnum) throws IOException {
            BytesRef spare = new BytesRef();
            DocsEnum docsEnum = null;
            for (int i = 0; i < TermsIncludingScoreQuery.this.terms.size(); ++i) {
                if (!termsEnum.seekExact(TermsIncludingScoreQuery.this.terms.get(TermsIncludingScoreQuery.this.ords[i], spare))) continue;
                docsEnum = termsEnum.docs(acceptDocs, docsEnum, 0);
                float score = TermsIncludingScoreQuery.this.scores[TermsIncludingScoreQuery.this.ords[i]];
                int doc = docsEnum.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    matchingDocs.set(doc);
                    this.scores[doc] = score;
                    doc = docsEnum.nextDoc();
                }
            }
        }

        public float score() throws IOException {
            return this.scores[this.currentDoc];
        }

        public int freq() throws IOException {
            return 1;
        }

        public int docID() {
            return this.currentDoc;
        }

        public int nextDoc() throws IOException {
            this.currentDoc = this.matchingDocsIterator.nextDoc();
            return this.currentDoc;
        }

        public int advance(int target) throws IOException {
            this.currentDoc = this.matchingDocsIterator.advance(target);
            return this.currentDoc;
        }

        public long cost() {
            return this.cost;
        }
    }
}

