/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.spring.starter.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.MessageSelector;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.client.consumer.rebalance.AllocateMessageQueueAveragely;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.spring.starter.core.RocketMQListener;
import org.apache.rocketmq.spring.starter.core.RocketMQListenerContainer;
import org.apache.rocketmq.spring.starter.core.RocketMQPushConsumerLifecycleListener;
import org.apache.rocketmq.spring.starter.enums.ConsumeMode;
import org.apache.rocketmq.spring.starter.enums.SelectorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultRocketMQListenerContainer
implements InitializingBean,
RocketMQListenerContainer {
    private static final Logger log = LoggerFactory.getLogger(DefaultRocketMQListenerContainer.class);
    private long suspendCurrentQueueTimeMillis = 1000L;
    private int delayLevelWhenNextConsume = 0;
    private String consumerGroup;
    private String nameServer;
    private String accessKey;
    private String secretKey;
    private String topic;
    private ConsumeMode consumeMode = ConsumeMode.CONCURRENTLY;
    private SelectorType selectorType = SelectorType.TAG;
    private String selectorExpress = "*";
    private MessageModel messageModel = MessageModel.CLUSTERING;
    private int consumeThreadMax = 8;
    private String charset = "UTF-8";
    private ObjectMapper objectMapper = new ObjectMapper();
    private boolean started;
    private RocketMQListener rocketMQListener;
    private DefaultMQPushConsumer consumer;
    private Class messageType;

    public void setupMessageListener(RocketMQListener rocketMQListener) {
        this.rocketMQListener = rocketMQListener;
    }

    public void destroy() {
        this.setStarted(false);
        if (Objects.nonNull(this.consumer)) {
            this.consumer.shutdown();
        }
        log.info("container destroyed, {}", (Object)this.toString());
    }

    public synchronized void start() throws MQClientException {
        if (this.isStarted()) {
            throw new IllegalStateException("container already started. " + this.toString());
        }
        this.initRocketMQPushConsumer();
        this.messageType = this.getMessageType();
        log.debug("msgType: {}", (Object)this.messageType.getName());
        this.consumer.start();
        this.setStarted(true);
        log.info("started container: {}", (Object)this.toString());
    }

    public void afterPropertiesSet() throws Exception {
        this.start();
    }

    public String toString() {
        return "DefaultRocketMQListenerContainer{consumerGroup='" + this.consumerGroup + '\'' + ", nameServer='" + this.nameServer + '\'' + ", topic='" + this.topic + '\'' + ", consumeMode=" + (Object)((Object)this.consumeMode) + ", selectorType=" + (Object)((Object)this.selectorType) + ", selectorExpress='" + this.selectorExpress + '\'' + ", messageModel=" + this.messageModel + '}';
    }

    private Object doConvertMessage(MessageExt messageExt) {
        if (Objects.equals(this.messageType, MessageExt.class)) {
            return messageExt;
        }
        String str = new String(messageExt.getBody(), Charset.forName(this.charset));
        if (Objects.equals(this.messageType, String.class)) {
            return str;
        }
        try {
            return this.objectMapper.readValue(str, this.messageType);
        }
        catch (Exception e) {
            log.info("convert failed. str:{}, msgType:{}", (Object)str, (Object)this.messageType);
            throw new RuntimeException("cannot convert message to " + this.messageType, e);
        }
    }

    private Class getMessageType() {
        Type[] interfaces = this.rocketMQListener.getClass().getGenericInterfaces();
        if (Objects.nonNull(interfaces)) {
            for (Type type : interfaces) {
                ParameterizedType parameterizedType;
                if (!(type instanceof ParameterizedType) || !Objects.equals((parameterizedType = (ParameterizedType)type).getRawType(), RocketMQListener.class)) continue;
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (Objects.nonNull(actualTypeArguments) && actualTypeArguments.length > 0) {
                    return (Class)actualTypeArguments[0];
                }
                return Object.class;
            }
            return Object.class;
        }
        return Object.class;
    }

    private void initRocketMQPushConsumer() throws MQClientException {
        Assert.notNull((Object)this.rocketMQListener, (String)"Property 'rocketMQListener' is required");
        Assert.notNull((Object)this.consumerGroup, (String)"Property 'consumerGroup' is required");
        Assert.notNull((Object)this.nameServer, (String)"Property 'nameServer' is required");
        Assert.notNull((Object)this.topic, (String)"Property 'topic' is required");
        if (!StringUtils.isEmpty((Object)this.accessKey) && !StringUtils.isEmpty((Object)this.secretKey)) {
            AclClientRPCHook hook = new AclClientRPCHook(new SessionCredentials(this.accessKey, this.secretKey));
            this.consumer = new DefaultMQPushConsumer(this.consumerGroup, (RPCHook)hook, (AllocateMessageQueueStrategy)new AllocateMessageQueueAveragely());
        } else {
            this.consumer = new DefaultMQPushConsumer(this.consumerGroup);
        }
        this.consumer.setNamesrvAddr(this.nameServer);
        this.consumer.setConsumeThreadMax(this.consumeThreadMax);
        if (this.consumeThreadMax < this.consumer.getConsumeThreadMin()) {
            this.consumer.setConsumeThreadMin(this.consumeThreadMax);
        }
        this.consumer.setMessageModel(this.messageModel);
        switch (this.selectorType) {
            case TAG: {
                this.consumer.subscribe(this.topic, this.selectorExpress);
                break;
            }
            case SQL92: {
                this.consumer.subscribe(this.topic, MessageSelector.bySql((String)this.selectorExpress));
                break;
            }
            default: {
                throw new IllegalArgumentException("Property 'selectorType' was wrong.");
            }
        }
        switch (this.consumeMode) {
            case ORDERLY: {
                this.consumer.setMessageListener((MessageListener)new DefaultMessageListenerOrderly());
                break;
            }
            case CONCURRENTLY: {
                this.consumer.setMessageListener((MessageListener)new DefaultMessageListenerConcurrently());
                break;
            }
            default: {
                throw new IllegalArgumentException("Property 'consumeMode' was wrong.");
            }
        }
        if (this.rocketMQListener instanceof RocketMQPushConsumerLifecycleListener) {
            ((RocketMQPushConsumerLifecycleListener)((Object)this.rocketMQListener)).prepareStart(this.consumer);
        }
    }

    public void setSuspendCurrentQueueTimeMillis(long suspendCurrentQueueTimeMillis) {
        this.suspendCurrentQueueTimeMillis = suspendCurrentQueueTimeMillis;
    }

    public long getSuspendCurrentQueueTimeMillis() {
        return this.suspendCurrentQueueTimeMillis;
    }

    public void setDelayLevelWhenNextConsume(int delayLevelWhenNextConsume) {
        this.delayLevelWhenNextConsume = delayLevelWhenNextConsume;
    }

    public int getDelayLevelWhenNextConsume() {
        return this.delayLevelWhenNextConsume;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setNameServer(String nameServer) {
        this.nameServer = nameServer;
    }

    public String getNameServer() {
        return this.nameServer;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setConsumeMode(ConsumeMode consumeMode) {
        this.consumeMode = consumeMode;
    }

    public ConsumeMode getConsumeMode() {
        return this.consumeMode;
    }

    public void setSelectorType(SelectorType selectorType) {
        this.selectorType = selectorType;
    }

    public SelectorType getSelectorType() {
        return this.selectorType;
    }

    public void setSelectorExpress(String selectorExpress) {
        this.selectorExpress = selectorExpress;
    }

    public String getSelectorExpress() {
        return this.selectorExpress;
    }

    public void setMessageModel(MessageModel messageModel) {
        this.messageModel = messageModel;
    }

    public MessageModel getMessageModel() {
        return this.messageModel;
    }

    public void setConsumeThreadMax(int consumeThreadMax) {
        this.consumeThreadMax = consumeThreadMax;
    }

    public int getConsumeThreadMax() {
        return this.consumeThreadMax;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setRocketMQListener(RocketMQListener rocketMQListener) {
        this.rocketMQListener = rocketMQListener;
    }

    public class DefaultMessageListenerOrderly
    implements MessageListenerOrderly {
        public ConsumeOrderlyStatus consumeMessage(List<MessageExt> msgs, ConsumeOrderlyContext context) {
            for (MessageExt messageExt : msgs) {
                log.debug("received msg: {}", (Object)messageExt);
                try {
                    long now = System.currentTimeMillis();
                    DefaultRocketMQListenerContainer.this.rocketMQListener.onMessage(DefaultRocketMQListenerContainer.this.doConvertMessage(messageExt));
                    long costTime = System.currentTimeMillis() - now;
                    log.info("consume {} cost: {} ms", (Object)messageExt.getMsgId(), (Object)costTime);
                }
                catch (Exception e) {
                    log.warn("consume message failed. messageExt:{}", (Object)messageExt, (Object)e);
                    context.setSuspendCurrentQueueTimeMillis(DefaultRocketMQListenerContainer.this.suspendCurrentQueueTimeMillis);
                    return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
                }
            }
            return ConsumeOrderlyStatus.SUCCESS;
        }
    }

    public class DefaultMessageListenerConcurrently
    implements MessageListenerConcurrently {
        public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
            for (MessageExt messageExt : msgs) {
                log.debug("received msg: {}", (Object)messageExt);
                try {
                    long now = System.currentTimeMillis();
                    DefaultRocketMQListenerContainer.this.rocketMQListener.onMessage(DefaultRocketMQListenerContainer.this.doConvertMessage(messageExt));
                    long costTime = System.currentTimeMillis() - now;
                    log.debug("consume {} cost: {} ms", (Object)messageExt.getMsgId(), (Object)costTime);
                }
                catch (Exception e) {
                    log.warn("consume message failed. messageExt:{}", (Object)messageExt, (Object)e);
                    context.setDelayLevelWhenNextConsume(DefaultRocketMQListenerContainer.this.delayLevelWhenNextConsume);
                    return ConsumeConcurrentlyStatus.RECONSUME_LATER;
                }
            }
            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
        }
    }
}

