/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.mkldnn;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.mkldnn.mkldnn_primitive_desc;
import org.bytedeco.mkldnn.presets.mkldnn;

@Name(value={"std::vector<mkldnn_primitive_desc_t>"})
@Properties(inherit={mkldnn.class})
public class mkldnn_primitive_desc_vector
extends Pointer {
    public mkldnn_primitive_desc_vector(Pointer p) {
        super(p);
    }

    public mkldnn_primitive_desc_vector(mkldnn_primitive_desc value) {
        this(1L);
        this.put(0L, value);
    }

    public mkldnn_primitive_desc_vector(mkldnn_primitive_desc ... array) {
        this(array.length);
        this.put(array);
    }

    public mkldnn_primitive_desc_vector() {
        this.allocate();
    }

    public mkldnn_primitive_desc_vector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator="})
    @ByRef
    public native mkldnn_primitive_desc_vector put(@ByRef mkldnn_primitive_desc_vector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    @Index(function="at")
    public native mkldnn_primitive_desc get(@Cast(value={"size_t"}) long var1);

    public native mkldnn_primitive_desc_vector put(@Cast(value={"size_t"}) long var1, mkldnn_primitive_desc var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, mkldnn_primitive_desc var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public mkldnn_primitive_desc[] get() {
        mkldnn_primitive_desc[] array = new mkldnn_primitive_desc[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public mkldnn_primitive_desc pop_back() {
        long size = this.size();
        mkldnn_primitive_desc value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public mkldnn_primitive_desc_vector push_back(mkldnn_primitive_desc value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public mkldnn_primitive_desc_vector put(mkldnn_primitive_desc value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public mkldnn_primitive_desc_vector put(mkldnn_primitive_desc ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator=="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator*"})
        public native mkldnn_primitive_desc get();
    }
}

