/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.spring;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.cassandraunit.CQLDataLoader;
import org.cassandraunit.DataLoader;
import org.cassandraunit.dataset.CQLDataSet;
import org.cassandraunit.dataset.ClassPathDataSet;
import org.cassandraunit.dataset.DataSet;
import org.cassandraunit.dataset.cql.ClassPathCQLDataSet;
import org.cassandraunit.spring.CassandraDataSet;
import org.cassandraunit.spring.CassandraUnitTestExecutionListener;
import org.cassandraunit.spring.EmbeddedCassandra;
import org.cassandraunit.utils.EmbeddedCassandraServerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.ClassUtils;

public abstract class AbstractCassandraUnitTestExecutionListener
extends AbstractTestExecutionListener
implements Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraUnitTestExecutionListener.class);
    private static boolean initialized = false;

    protected void startServer(TestContext testContext) throws Exception {
        EmbeddedCassandra embeddedCassandra = (EmbeddedCassandra)Preconditions.checkNotNull((Object)AnnotationUtils.findAnnotation((Class)testContext.getTestClass(), EmbeddedCassandra.class), (Object)("CassandraUnitTestExecutionListener must be used with @EmbeddedCassandra on " + testContext.getTestClass()));
        if (!initialized) {
            String yamlFile = (String)Optional.fromNullable((Object)embeddedCassandra.configuration()).get();
            long timeout = embeddedCassandra.timeout();
            EmbeddedCassandraServerHelper.startEmbeddedCassandra((String)yamlFile, (long)timeout);
            initialized = true;
        }
        String clusterName = EmbeddedCassandraServerHelper.getClusterName();
        String host = EmbeddedCassandraServerHelper.getHost();
        int rpcPort = EmbeddedCassandraServerHelper.getRpcPort();
        int nativeTransportPort = EmbeddedCassandraServerHelper.getNativeTransportPort();
        CassandraDataSet cassandraDataSet = (CassandraDataSet)AnnotationUtils.findAnnotation((Class)testContext.getTestClass(), CassandraDataSet.class);
        if (cassandraDataSet != null) {
            List<String> dataset = null;
            ListIterator<String> datasetIterator = null;
            String keyspace = cassandraDataSet.keyspace();
            switch (cassandraDataSet.type()) {
                case cql: {
                    dataset = this.dataSetLocations(testContext, cassandraDataSet);
                    datasetIterator = dataset.listIterator();
                    Cluster cluster = new Cluster.Builder().addContactPoints(new String[]{host}).withPort(nativeTransportPort).build();
                    Session session = cluster.connect();
                    CQLDataLoader cqlDataLoader = new CQLDataLoader(session);
                    while (datasetIterator.hasNext()) {
                        String next = datasetIterator.next();
                        boolean dropAndCreateKeyspace = datasetIterator.previousIndex() == 0;
                        cqlDataLoader.load((CQLDataSet)new ClassPathCQLDataSet(next, dropAndCreateKeyspace, dropAndCreateKeyspace, keyspace));
                    }
                    break;
                }
                default: {
                    dataset = this.dataSetLocations(testContext, cassandraDataSet);
                    datasetIterator = dataset.listIterator();
                    DataLoader dataLoader = new DataLoader(clusterName, host + ":" + rpcPort);
                    while (datasetIterator.hasNext()) {
                        String next = datasetIterator.next();
                        boolean dropAndCreateKeyspace = datasetIterator.previousIndex() == 0;
                        dataLoader.load((DataSet)new ClassPathDataSet(next), dropAndCreateKeyspace);
                    }
                    break block0;
                }
            }
        }
    }

    private List<String> dataSetLocations(TestContext testContext, CassandraDataSet cassandraDataSet) {
        String[] dataset = cassandraDataSet.value();
        if (dataset.length == 0) {
            String alternativePath = this.alternativePath(testContext.getTestClass(), true, cassandraDataSet.type().name());
            if (testContext.getApplicationContext().getResource(alternativePath).exists()) {
                dataset = new String[]{alternativePath.replace("classpath:/", "")};
            } else {
                alternativePath = this.alternativePath(testContext.getTestClass(), false, cassandraDataSet.type().name());
                if (testContext.getApplicationContext().getResource(alternativePath).exists()) {
                    dataset = new String[]{alternativePath.replace("classpath:/", "")};
                } else {
                    LOGGER.info("No dataset will be loaded");
                }
            }
        }
        return Arrays.asList(dataset);
    }

    protected void cleanServer() {
        EmbeddedCassandraServerHelper.cleanEmbeddedCassandra();
    }

    protected String alternativePath(Class<?> clazz, boolean includedPackageName, String extension) {
        if (includedPackageName) {
            return "classpath:/" + ClassUtils.convertClassNameToResourcePath((String)clazz.getName()) + "-dataset" + "." + extension;
        }
        return "classpath:/" + clazz.getSimpleName() + "-dataset" + "." + extension;
    }

    public int getOrder() {
        return 0;
    }
}

