/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.maven.toolchain.ToolchainManagerPrivate;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.codehaus.mojo.animal_sniffer.SignatureBuilder;
import org.codehaus.mojo.animal_sniffer.logging.Logger;
import org.codehaus.mojo.animal_sniffer.maven.JdkToolchain;
import org.codehaus.mojo.animal_sniffer.maven.MavenLogger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

@Mojo(name="build", configurator="override", requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class BuildSignaturesMojo
extends AbstractMojo {
    @Parameter(property="includeJavaHome", defaultValue="true")
    private boolean includeJavaHome;
    @Parameter(property="skipIfNoJavaHome", defaultValue="false")
    private boolean skipIfNoJavaHome;
    @Parameter(property="includeJavaHome", defaultValue="true")
    private boolean includeModuleClasses;
    @Parameter
    private String[] includeClasses = null;
    @Parameter
    private String[] excludeClasses = null;
    @Parameter
    private String[] includeDependencies = null;
    @Parameter
    private String[] excludeDependencies = null;
    @Parameter(property="javaHome")
    private String javaHome;
    @Parameter
    private File[] javaHomeClassPath;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classesDirectory;
    @Parameter(defaultValue="${project.build.finalName}", required=true)
    private String signaturesName;
    @Parameter
    private String classifier;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Component
    private ToolchainManager toolchainManager;
    @Component
    private ToolchainManagerPrivate toolchainManagerPrivate;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter
    private JdkToolchain jdk;
    @Parameter(defaultValue="${plugin.artifacts}", required=true, readonly=true)
    private List<Artifact> pluginArtifacts;
    @Parameter(defaultValue="${plugin.groupId}")
    private String jbcpdGroupId;
    @Parameter(defaultValue="java-boot-classpath-detector")
    private String jbcpdArtifactId;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.includeJavaHome && (this.javaHomeClassPath == null || this.javaHomeClassPath.length == 0)) {
            if (this.javaHome != null) {
                this.getLog().warn((CharSequence)("Toolchains are ignored, 'javaHome' parameter is set to " + this.javaHome));
                if (!new File(this.javaHome).isDirectory()) {
                    if (this.skipIfNoJavaHome) {
                        this.getLog().warn((CharSequence)("Skipping signature generation as java home (" + this.javaHome + ") does not exist"));
                        return;
                    }
                    throw new MojoFailureException("Cannot include java home if specified java home does not exist");
                }
                if (!this.detectJavaBootClasspath(new File(new File(this.javaHome, "bin"), "java").getAbsolutePath())) {
                    return;
                }
            } else {
                String jvm;
                Toolchain tc = this.getJdkToolchain();
                if (tc == null && this.jdk == null) {
                    jvm = null;
                    tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
                    this.getLog().info((CharSequence)("Toolchain from session: " + tc));
                    if (tc != null) {
                        jvm = tc.findTool("java");
                    }
                    if (jvm == null) {
                        if (this.skipIfNoJavaHome) {
                            this.getLog().warn((CharSequence)"Skipping signature generation as could not find java home");
                            return;
                        }
                        throw new MojoFailureException("Cannot include java home if java home is not specified (either via javaClassPath, javaHome or jdk)");
                    }
                    if (!this.detectJavaBootClasspath(jvm)) {
                        return;
                    }
                } else if (tc != null && StringUtils.equalsIgnoreCase((String)"jdk", (String)tc.getType())) {
                    this.getLog().info((CharSequence)("Toolchain in animal-sniffer-maven-plugin: " + tc));
                    jvm = tc.findTool("java");
                    if (jvm == null) {
                        if (this.skipIfNoJavaHome) {
                            this.getLog().warn((CharSequence)"Skipping signature generation as could not find java home");
                            return;
                        }
                        throw new MojoFailureException("Cannot include java home if java home is not specified (either via javaClassPath, javaHome or jdk)");
                    }
                    if (!this.detectJavaBootClasspath(jvm)) {
                        return;
                    }
                } else {
                    if (tc == null && this.jdk != null && this.jdk.getParameters() != null) {
                        if (this.skipIfNoJavaHome) {
                            this.getLog().warn((CharSequence)("Skipping signature generation as could not find jdk toolchain to match " + this.jdk.getParameters()));
                            return;
                        }
                        throw new MojoFailureException("Could not find jdk toolchain to match " + this.jdk.getParameters());
                    }
                    if (this.skipIfNoJavaHome) {
                        this.getLog().warn((CharSequence)"Skipping signature generation as could not find java home");
                        return;
                    }
                    throw new MojoFailureException("Cannot include java home if java home is not specified (either via javaClassPath, javaHome, jdk or maven-toolchains-plugin)");
                }
            }
        }
        this.displayJavaBootClasspath();
        File sigFile = BuildSignaturesMojo.getTargetFile(this.outputDirectory, this.signaturesName, this.classifier, "signature");
        try {
            this.outputDirectory.mkdirs();
            SignatureBuilder builder = new SignatureBuilder(this.getBaseSignatures(), (OutputStream)new FileOutputStream(sigFile), (Logger)new MavenLogger(this.getLog()));
            if (this.includeClasses != null) {
                this.getLog().info((CharSequence)"Restricting signatures to include only the following classes:");
                for (String includeClass : this.includeClasses) {
                    this.getLog().info((CharSequence)("  " + includeClass));
                    builder.addInclude(includeClass);
                }
            }
            if (this.excludeClasses != null) {
                this.getLog().info((CharSequence)"Restricting signatures to exclude the following classes:");
                for (String excludeClass : this.excludeClasses) {
                    this.getLog().info((CharSequence)("  " + excludeClass));
                    builder.addExclude(excludeClass);
                }
            }
            this.processJavaBootClasspath(builder);
            this.processModuleDependencies(builder);
            this.processModuleClasses(builder);
            builder.close();
            this.projectHelper.attachArtifact(this.project, "signature", this.classifier, sigFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private boolean detectJavaBootClasspath(String javaExecutable) throws MojoFailureException, MojoExecutionException {
        this.getLog().info((CharSequence)("Attempting to auto-detect the boot classpath for " + javaExecutable));
        Iterator<Artifact> i = this.pluginArtifacts.iterator();
        Artifact javaBootClasspathDetector = null;
        while (i.hasNext() && javaBootClasspathDetector == null) {
            Artifact candidate = i.next();
            if (!StringUtils.equals((String)this.jbcpdGroupId, (String)candidate.getGroupId()) || !StringUtils.equals((String)this.jbcpdArtifactId, (String)candidate.getArtifactId()) || candidate.getFile() == null || !candidate.getFile().isFile()) continue;
            javaBootClasspathDetector = candidate;
        }
        if (javaBootClasspathDetector == null) {
            if (this.skipIfNoJavaHome) {
                this.getLog().warn((CharSequence)("Skipping signature generation as could not find boot classpath detector (" + ArtifactUtils.versionlessKey((String)this.jbcpdGroupId, (String)this.jbcpdArtifactId) + ")."));
                return false;
            }
            throw new MojoFailureException("Could not find boot classpath detector (" + ArtifactUtils.versionlessKey((String)this.jbcpdGroupId, (String)this.jbcpdArtifactId) + ").");
        }
        try {
            if (!this.detectJavaClasspath(javaBootClasspathDetector, javaExecutable)) {
                return false;
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
        return true;
    }

    private boolean detectJavaClasspath(Artifact javaBootClasspathDetector, String javaExecutable) throws CommandLineException, MojoFailureException {
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(this.project.getBasedir().getAbsolutePath());
        cli.setExecutable(javaExecutable);
        cli.addEnvironment("CLASSPATH", "");
        cli.addEnvironment("JAVA_HOME", "");
        cli.addArguments(new String[]{"-jar", javaBootClasspathDetector.getFile().getAbsolutePath()});
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)stdout, (StreamConsumer)stderr);
        if (exitCode != 0) {
            this.getLog().debug((CharSequence)("Stdout: " + stdout.getOutput()));
            this.getLog().debug((CharSequence)("Stderr: " + stderr.getOutput()));
            this.getLog().debug((CharSequence)("Exit code = " + exitCode));
            if (this.skipIfNoJavaHome) {
                this.getLog().warn((CharSequence)("Skipping signature generation as could not auto-detect java boot classpath for " + javaExecutable));
                return false;
            }
            if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9)) {
                this.getLog().warn((CharSequence)("Skipping signature generation as this java version has no more java boot classpath " + javaExecutable));
                return false;
            }
            throw new MojoFailureException("Could not auto-detect java boot classpath for " + javaExecutable);
        }
        String[] classpath = StringUtils.split((String)stdout.getOutput(), (String)File.pathSeparator);
        this.javaHomeClassPath = new File[classpath.length];
        for (int j = 0; j < classpath.length; ++j) {
            this.javaHomeClassPath[j] = new File(classpath[j]);
        }
        return true;
    }

    private void displayJavaBootClasspath() {
        if (this.includeJavaHome) {
            this.getLog().info((CharSequence)"Java Classpath:");
            if (this.javaHomeClassPath == null) {
                this.getLog().info((CharSequence)"    Empty");
            } else {
                for (int j = 0; j < this.javaHomeClassPath.length; ++j) {
                    this.getLog().info((CharSequence)("    [" + j + "] = " + this.javaHomeClassPath[j]));
                }
            }
        }
    }

    private void processModuleDependencies(SignatureBuilder builder) throws IOException {
        PatternIncludesArtifactFilter includesFilter = this.includeDependencies == null ? null : new PatternIncludesArtifactFilter(Arrays.asList(this.includeDependencies));
        PatternExcludesArtifactFilter excludesFilter = this.excludeDependencies == null ? null : new PatternExcludesArtifactFilter(Arrays.asList(this.excludeDependencies));
        for (Artifact artifact : this.project.getArtifacts()) {
            if (includesFilter != null && !includesFilter.include(artifact)) {
                this.getLog().debug((CharSequence)("Artifact " + BuildSignaturesMojo.artifactId(artifact) + " ignored as it does not match include rules."));
                continue;
            }
            if (excludesFilter != null && !excludesFilter.include(artifact)) {
                this.getLog().debug((CharSequence)("Artifact " + BuildSignaturesMojo.artifactId(artifact) + " ignored as it does match exclude rules."));
                continue;
            }
            if (!artifact.getArtifactHandler().isAddedToClasspath()) continue;
            this.getLog().info((CharSequence)("Parsing signatures from " + BuildSignaturesMojo.artifactId(artifact)));
            builder.process(artifact.getFile());
        }
    }

    private void processModuleClasses(SignatureBuilder builder) throws IOException {
        if (this.includeModuleClasses && this.classesDirectory.isDirectory()) {
            this.getLog().info((CharSequence)("Parsing signatures from " + this.classesDirectory));
            builder.process(this.classesDirectory);
        }
    }

    private void processJavaBootClasspath(SignatureBuilder builder) throws IOException {
        if (this.includeJavaHome && this.javaHomeClassPath != null && this.javaHomeClassPath.length > 0) {
            this.getLog().debug((CharSequence)"Parsing signatures java classpath:");
            for (File file : this.javaHomeClassPath) {
                if (file.isFile() || file.isDirectory()) {
                    this.getLog().debug((CharSequence)("Processing " + file));
                    builder.process(file);
                    continue;
                }
                this.getLog().warn((CharSequence)("Could not add signatures from boot classpath element: " + file + " as it does not exist."));
            }
        }
    }

    private InputStream[] getBaseSignatures() throws FileNotFoundException {
        ArrayList<FileInputStream> baseSignatures = new ArrayList<FileInputStream>();
        for (Artifact artifact : this.project.getArtifacts()) {
            if (!StringUtils.equals((String)"signature", (String)artifact.getType())) continue;
            this.getLog().info((CharSequence)("Importing sigantures from " + artifact.getFile()));
            baseSignatures.add(new FileInputStream(artifact.getFile()));
        }
        return baseSignatures.toArray(new InputStream[0]);
    }

    private Toolchain getJdkToolchain() throws MojoExecutionException {
        Toolchain tc = this.getJdkToolchainFromConfiguration();
        if (tc == null) {
            tc = this.getJdkToolchainFromContext();
        }
        return tc;
    }

    private Toolchain getJdkToolchainFromContext() {
        if (this.toolchainManager != null) {
            return this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return null;
    }

    private Toolchain getJdkToolchainFromConfiguration() throws MojoExecutionException {
        if (this.toolchainManager != null && this.jdk != null && this.jdk.getParameters() != null) {
            try {
                ToolchainPrivate[] tcp;
                for (ToolchainPrivate toolchainPrivate : tcp = this.getToolchains("jdk")) {
                    if (!toolchainPrivate.getType().equals("jdk") || !toolchainPrivate.matchesRequirements(this.jdk.getParameters())) continue;
                    return toolchainPrivate;
                }
            }
            catch (MisconfiguredToolchainException e) {
                throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
            }
        }
        return null;
    }

    static String artifactId(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + (artifact.getClassifier() != null ? ":" + artifact.getClassifier() : "") + ":" + artifact.getBaseVersion();
    }

    private ToolchainPrivate[] getToolchains(String type) throws MojoExecutionException, MisconfiguredToolchainException {
        Class<?> managerClass = this.toolchainManagerPrivate.getClass();
        try {
            try {
                Method newMethod = managerClass.getMethod("getToolchainsForType", String.class, MavenSession.class);
                return (ToolchainPrivate[])newMethod.invoke((Object)this.toolchainManagerPrivate, type, this.session);
            }
            catch (NoSuchMethodException e1) {
                try {
                    try {
                        Method oldMethod = managerClass.getMethod("getToolchainsForType", String.class);
                        return (ToolchainPrivate[])oldMethod.invoke((Object)this.toolchainManagerPrivate, type);
                    }
                    catch (NoSuchMethodException e2) {
                        e2.initCause(e1);
                        throw e2;
                    }
                }
                catch (NoSuchMethodException e) {
                    Method[] methods;
                    StringBuilder buf = new StringBuilder("Incompatible toolchain API.");
                    buf.append("\n\nCannot find a suitable 'getToolchainsForType' method. Available methods are:\n");
                    for (Method method : methods = managerClass.getMethods()) {
                        buf.append("  ").append(method).append('\n');
                    }
                    throw new MojoExecutionException(buf.toString(), (Exception)e);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Incompatible toolchain API", (Exception)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof MisconfiguredToolchainException) {
                throw (MisconfiguredToolchainException)cause;
            }
            throw new MojoExecutionException("Incompatible toolchain API", (Exception)e);
        }
    }

    private static File getTargetFile(File basedir, String finalName, String classifier, String type) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + "." + type);
    }
}

