/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.nodes;

import java.io.Externalizable;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.rule.Behavior;
import org.drools.core.rule.SlidingTimeWindow;
import org.drools.core.spi.PropagationContext;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.TimerService;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.PointInTimeTrigger;

public class ReteSlidingTimeWindow
extends SlidingTimeWindow
implements Externalizable,
Behavior {
    private static final ReteBehaviorJob reteJob = new ReteBehaviorJob();

    public ReteSlidingTimeWindow() {
        this(0L);
    }

    public ReteSlidingTimeWindow(long size) {
        super(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean assertFact(Object context, InternalFactHandle fact, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        SlidingTimeWindow.SlidingTimeWindowContext queue = (SlidingTimeWindow.SlidingTimeWindowContext)context;
        EventFactHandle handle = (EventFactHandle)fact;
        long currentTime = workingMemory.getTimerService().getCurrentTime();
        if (this.isExpired(currentTime, handle)) {
            return false;
        }
        SlidingTimeWindow.SlidingTimeWindowContext slidingTimeWindowContext = queue;
        synchronized (slidingTimeWindowContext) {
            queue.add(handle);
            if (queue.peek() == handle) {
                this.updateNextExpiration((InternalFactHandle)handle, workingMemory, (Behavior.Context)queue, this.nodeId);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retractFact(Object context, InternalFactHandle fact, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        SlidingTimeWindow.SlidingTimeWindowContext queue = (SlidingTimeWindow.SlidingTimeWindowContext)context;
        EventFactHandle handle = (EventFactHandle)fact;
        SlidingTimeWindow.SlidingTimeWindowContext slidingTimeWindowContext = queue;
        synchronized (slidingTimeWindowContext) {
            if (queue.getExpiringHandle() != handle) {
                if (queue.peek() == handle) {
                    queue.poll();
                    this.updateNextExpiration((InternalFactHandle)queue.peek(), workingMemory, (Behavior.Context)queue, this.nodeId);
                } else {
                    queue.remove(handle);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireFacts(Object context, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        SlidingTimeWindow.SlidingTimeWindowContext queue;
        TimerService clock = workingMemory.getTimerService();
        long currentTime = clock.getCurrentTime();
        SlidingTimeWindow.SlidingTimeWindowContext slidingTimeWindowContext = queue = (SlidingTimeWindow.SlidingTimeWindowContext)context;
        synchronized (slidingTimeWindowContext) {
            EventFactHandle handle = queue.peek();
            while (handle != null && this.isExpired(currentTime, handle)) {
                queue.setExpiringHandle(handle);
                queue.remove();
                if (handle.isValid()) {
                    PropagationContextFactory pctxFactory = workingMemory.getKnowledgeBase().getConfiguration().getComponentFactory().getPropagationContextFactory();
                    PropagationContext expiresPctx = pctxFactory.createPropagationContext(workingMemory.getNextPropagationIdCounter(), 5, null, null, (InternalFactHandle)handle);
                    ObjectTypeNode.doRetractObject((InternalFactHandle)handle, (PropagationContext)expiresPctx, (InternalWorkingMemory)workingMemory);
                    expiresPctx.evaluateActionQueue(workingMemory);
                }
                queue.setExpiringHandle(null);
                handle = queue.peek();
            }
            this.updateNextExpiration((InternalFactHandle)handle, workingMemory, (Behavior.Context)queue, this.nodeId);
        }
    }

    protected void updateNextExpiration(InternalFactHandle fact, InternalWorkingMemory workingMemory, Behavior.Context context, int nodeId) {
        TimerService clock = workingMemory.getTimerService();
        if (fact != null) {
            long nextTimestamp = ((EventFactHandle)fact).getStartTimestamp() + this.getSize();
            if (nextTimestamp < clock.getCurrentTime()) {
                workingMemory.queueWorkingMemoryAction((WorkingMemoryAction)new SlidingTimeWindow.BehaviorExpireWMAction(nodeId, (Behavior)this, context));
            } else {
                SlidingTimeWindow.BehaviorJobContext jobctx = new SlidingTimeWindow.BehaviorJobContext(nodeId, workingMemory, (Behavior)this, context);
                JobHandle handle = clock.scheduleJob((Job)reteJob, (JobContext)jobctx, (Trigger)new PointInTimeTrigger(nextTimestamp, null, null));
                jobctx.setJobHandle(handle);
            }
        }
    }

    public static class ReteBehaviorJob
    implements Job {
        public void execute(JobContext ctx) {
            SlidingTimeWindow.BehaviorJobContext context = (SlidingTimeWindow.BehaviorJobContext)ctx;
            context.workingMemory.queueWorkingMemoryAction((WorkingMemoryAction)new SlidingTimeWindow.BehaviorExpireWMAction(context.nodeId, context.behavior, context.behaviorContext));
        }
    }
}

