/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.shingle.FixedShingleFilter;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.NormsFieldExistsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.FieldMaskingSpanQuery;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.similarity.SimilarityProvider;

public class SearchAsYouTypeFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "search_as_you_type";
    private static final int MAX_SHINGLE_SIZE_LOWER_BOUND = 2;
    private static final int MAX_SHINGLE_SIZE_UPPER_BOUND = 4;
    private static final String PREFIX_FIELD_SUFFIX = "._index_prefix";
    private final int maxShingleSize;
    private PrefixFieldMapper prefixField;
    private final ShingleFieldMapper[] shingleFields;

    private static int countPosition(TokenStream stream) throws IOException {
        assert (stream instanceof CachingTokenFilter);
        PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)stream.getAttribute(PositionIncrementAttribute.class);
        stream.reset();
        int positionCount = 0;
        while (stream.incrementToken()) {
            if (posIncAtt.getPositionIncrement() == 0) continue;
            positionCount += posIncAtt.getPositionIncrement();
        }
        return positionCount;
    }

    public SearchAsYouTypeFieldMapper(String simpleName, FieldType fieldType, SearchAsYouTypeFieldType mappedFieldType, FieldMapper.CopyTo copyTo, int maxShingleSize, PrefixFieldMapper prefixField, ShingleFieldMapper[] shingleFields) {
        super(simpleName, fieldType, (MappedFieldType)mappedFieldType, FieldMapper.MultiFields.empty(), copyTo);
        this.prefixField = prefixField;
        this.shingleFields = shingleFields;
        this.maxShingleSize = maxShingleSize;
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        String value;
        String string = value = context.externalValueSet() ? context.externalValue().toString() : context.parser().textOrNull();
        if (value == null) {
            return;
        }
        context.doc().add((IndexableField)new Field(this.fieldType().name(), (CharSequence)value, (IndexableFieldType)this.fieldType));
        for (ShingleFieldMapper subFieldMapper : this.shingleFields) {
            context.doc().add((IndexableField)new Field(subFieldMapper.fieldType().name(), (CharSequence)value, (IndexableFieldType)subFieldMapper.getLuceneFieldType()));
        }
        context.doc().add((IndexableField)new Field(this.prefixField.fieldType().name(), (CharSequence)value, (IndexableFieldType)this.prefixField.getLuceneFieldType()));
        if (this.fieldType.omitNorms()) {
            this.createFieldNamesField(context);
        }
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        SearchAsYouTypeFieldMapper m = (SearchAsYouTypeFieldMapper)other;
        if (this.shingleFields.length != m.shingleFields.length) {
            conflicts.add("mapper [" + this.name() + "] has a different [max_shingle_size]");
        } else {
            this.prefixField = (PrefixFieldMapper)this.prefixField.merge((Mapper)m.prefixField);
            for (int i = 0; i < m.shingleFields.length; ++i) {
                this.shingleFields[i] = (ShingleFieldMapper)this.shingleFields[i].merge((Mapper)m.shingleFields[i]);
            }
        }
        if (!Objects.equals(this.fieldType().getTextSearchInfo().getSimilarity(), other.fieldType().getTextSearchInfo().getSimilarity())) {
            conflicts.add("mapper [" + this.name() + "] has different [similarity] settings");
        }
    }

    public static String getShingleFieldName(String parentField, int shingleSize) {
        return parentField + "._" + shingleSize + "gram";
    }

    public SearchAsYouTypeFieldType fieldType() {
        return (SearchAsYouTypeFieldType)super.fieldType();
    }

    public int maxShingleSize() {
        return this.maxShingleSize;
    }

    public PrefixFieldMapper prefixField() {
        return this.prefixField;
    }

    public ShingleFieldMapper[] shingleFields() {
        return this.shingleFields;
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        this.doXContentAnalyzers(builder, includeDefaults);
        if (this.fieldType().getTextSearchInfo().getSimilarity() != null) {
            builder.field("similarity", this.fieldType().getTextSearchInfo().getSimilarity().name());
        } else if (includeDefaults) {
            builder.field("similarity", "BM25");
        }
        builder.field("max_shingle_size", this.maxShingleSize);
    }

    public Iterator<Mapper> iterator() {
        ArrayList<FieldMapper> subIterators = new ArrayList<FieldMapper>();
        subIterators.add(this.prefixField);
        subIterators.addAll(Arrays.asList(this.shingleFields));
        Iterator concat = Iterators.concat((Iterator[])new Iterator[]{super.iterator(), subIterators.iterator()});
        return concat;
    }

    static final class PrefixFieldMapper
    extends FieldMapper {
        PrefixFieldMapper(FieldType fieldType, PrefixFieldType mappedFieldType) {
            super(mappedFieldType.name(), fieldType, (MappedFieldType)mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        }

        public PrefixFieldType fieldType() {
            return (PrefixFieldType)super.fieldType();
        }

        FieldType getLuceneFieldType() {
            return this.fieldType;
        }

        protected void parseCreateField(ParseContext context) {
            throw new UnsupportedOperationException();
        }

        protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        }

        protected String contentType() {
            return "prefix";
        }

        public String toString() {
            return this.fieldType().toString();
        }
    }

    static final class ShingleFieldMapper
    extends FieldMapper {
        ShingleFieldMapper(FieldType fieldType, ShingleFieldType mappedFieldtype) {
            super(mappedFieldtype.name(), fieldType, (MappedFieldType)mappedFieldtype, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        }

        FieldType getLuceneFieldType() {
            return this.fieldType;
        }

        public ShingleFieldType fieldType() {
            return (ShingleFieldType)super.fieldType();
        }

        protected void parseCreateField(ParseContext context) {
            throw new UnsupportedOperationException();
        }

        protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        }

        protected String contentType() {
            return "shingle";
        }
    }

    static class SearchAsYouTypeFieldType
    extends StringFieldType {
        PrefixFieldType prefixField;
        ShingleFieldType[] shingleFields = new ShingleFieldType[0];

        SearchAsYouTypeFieldType(String name, FieldType fieldType, SimilarityProvider similarity, NamedAnalyzer searchAnalyzer, NamedAnalyzer searchQuoteAnalyzer, Map<String, String> meta) {
            super(name, fieldType.indexOptions() != IndexOptions.NONE, false, new TextSearchInfo(fieldType, similarity, searchAnalyzer, searchQuoteAnalyzer), meta);
        }

        public void setPrefixField(PrefixFieldType prefixField) {
            this.prefixField = prefixField;
        }

        public void setShingleFields(ShingleFieldType[] shingleFields) {
            this.shingleFields = shingleFields;
        }

        public String typeName() {
            return SearchAsYouTypeFieldMapper.CONTENT_TYPE;
        }

        private ShingleFieldType shingleFieldForPositions(int positions) {
            int indexFromShingleSize = Math.max(positions - 2, 0);
            return this.shingleFields[Math.min(indexFromShingleSize, this.shingleFields.length - 1)];
        }

        public Query existsQuery(QueryShardContext context) {
            if (!this.getTextSearchInfo().hasNorms()) {
                return new TermQuery(new Term("_field_names", this.name()));
            }
            return new NormsFieldExistsQuery(this.name());
        }

        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            if (this.prefixField == null || !this.prefixField.termLengthWithinBounds(value.length())) {
                return super.prefixQuery(value, method, context);
            }
            Query query = this.prefixField.prefixQuery(value, method, context);
            if (method == null || method == MultiTermQuery.CONSTANT_SCORE_REWRITE || method == MultiTermQuery.CONSTANT_SCORE_BOOLEAN_REWRITE) {
                return new ConstantScoreQuery(query);
            }
            return query;
        }

        public Query phraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
            int numPos = SearchAsYouTypeFieldMapper.countPosition(stream);
            if (this.shingleFields.length == 0 || slop > 0 || TextFieldMapper.TextFieldType.hasGaps((TokenStream)stream) || numPos <= 1) {
                return TextFieldMapper.createPhraseQuery((TokenStream)stream, (String)this.name(), (int)slop, (boolean)enablePositionIncrements);
            }
            ShingleFieldType shingleField = this.shingleFieldForPositions(numPos);
            stream = new FixedShingleFilter(stream, shingleField.shingleSize);
            return shingleField.phraseQuery(stream, 0, true);
        }

        public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
            int numPos = SearchAsYouTypeFieldMapper.countPosition(stream);
            if (this.shingleFields.length == 0 || slop > 0 || TextFieldMapper.TextFieldType.hasGaps((TokenStream)stream) || numPos <= 1) {
                return TextFieldMapper.createPhraseQuery((TokenStream)stream, (String)this.name(), (int)slop, (boolean)enablePositionIncrements);
            }
            ShingleFieldType shingleField = this.shingleFieldForPositions(numPos);
            stream = new FixedShingleFilter(stream, shingleField.shingleSize);
            return shingleField.multiPhraseQuery(stream, 0, true);
        }

        public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions) throws IOException {
            int numPos = SearchAsYouTypeFieldMapper.countPosition(stream);
            if (this.shingleFields.length == 0 || slop > 0 || TextFieldMapper.TextFieldType.hasGaps((TokenStream)stream) || numPos <= 1) {
                return TextFieldMapper.createPhrasePrefixQuery((TokenStream)stream, (String)this.name(), (int)slop, (int)maxExpansions, null, null);
            }
            ShingleFieldType shingleField = this.shingleFieldForPositions(numPos);
            stream = new FixedShingleFilter(stream, shingleField.shingleSize);
            return shingleField.phrasePrefixQuery(stream, 0, maxExpansions);
        }

        public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, QueryShardContext context) {
            if (this.prefixField != null && this.prefixField.termLengthWithinBounds(value.length())) {
                return new FieldMaskingSpanQuery((SpanQuery)new SpanTermQuery(new Term(this.prefixField.name(), this.indexedValueForSearch(value))), this.name());
            }
            SpanMultiTermQueryWrapper spanMulti = new SpanMultiTermQueryWrapper((MultiTermQuery)new PrefixQuery(new Term(this.name(), this.indexedValueForSearch(value))));
            spanMulti.setRewriteMethod(method);
            return spanMulti;
        }
    }

    static class ShingleFieldType
    extends StringFieldType {
        final int shingleSize;
        PrefixFieldType prefixFieldType;

        ShingleFieldType(String name, int shingleSize, TextSearchInfo textSearchInfo) {
            super(name, true, false, textSearchInfo, Collections.emptyMap());
            this.shingleSize = shingleSize;
        }

        void setPrefixFieldType(PrefixFieldType prefixFieldType) {
            this.prefixFieldType = prefixFieldType;
        }

        public String typeName() {
            return SearchAsYouTypeFieldMapper.CONTENT_TYPE;
        }

        public Query existsQuery(QueryShardContext context) {
            if (!this.getTextSearchInfo().hasNorms()) {
                return new TermQuery(new Term("_field_names", this.name()));
            }
            return new NormsFieldExistsQuery(this.name());
        }

        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            if (this.prefixFieldType == null || !this.prefixFieldType.termLengthWithinBounds(value.length())) {
                return super.prefixQuery(value, method, context);
            }
            Query query = this.prefixFieldType.prefixQuery(value, method, context);
            if (method == null || method == MultiTermQuery.CONSTANT_SCORE_REWRITE || method == MultiTermQuery.CONSTANT_SCORE_BOOLEAN_REWRITE) {
                return new ConstantScoreQuery(query);
            }
            return query;
        }

        public Query phraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
            return TextFieldMapper.createPhraseQuery((TokenStream)stream, (String)this.name(), (int)slop, (boolean)enablePositionIncrements);
        }

        public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
            return TextFieldMapper.createPhraseQuery((TokenStream)stream, (String)this.name(), (int)slop, (boolean)enablePositionIncrements);
        }

        public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions) throws IOException {
            String prefixFieldName = slop > 0 ? null : this.prefixFieldType.name();
            return TextFieldMapper.createPhrasePrefixQuery((TokenStream)stream, (String)this.name(), (int)slop, (int)maxExpansions, (String)prefixFieldName, this.prefixFieldType::termLengthWithinBounds);
        }

        public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, QueryShardContext context) {
            if (this.prefixFieldType != null && this.prefixFieldType.termLengthWithinBounds(value.length())) {
                return new FieldMaskingSpanQuery((SpanQuery)new SpanTermQuery(new Term(this.prefixFieldType.name(), this.indexedValueForSearch(value))), this.name());
            }
            SpanMultiTermQueryWrapper spanMulti = new SpanMultiTermQueryWrapper((MultiTermQuery)new PrefixQuery(new Term(this.name(), this.indexedValueForSearch(value))));
            spanMulti.setRewriteMethod(method);
            return spanMulti;
        }
    }

    static final class PrefixFieldType
    extends StringFieldType {
        final int minChars;
        final int maxChars;
        final String parentField;

        PrefixFieldType(String parentField, TextSearchInfo textSearchInfo, int minChars, int maxChars) {
            super(parentField + SearchAsYouTypeFieldMapper.PREFIX_FIELD_SUFFIX, true, false, textSearchInfo, Collections.emptyMap());
            this.minChars = minChars;
            this.maxChars = maxChars;
            this.parentField = parentField;
        }

        boolean termLengthWithinBounds(int length) {
            return length >= this.minChars - 1 && length <= this.maxChars;
        }

        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            if (value.length() >= this.minChars) {
                return super.termQuery((Object)value, context);
            }
            ArrayList<Automaton> automata = new ArrayList<Automaton>();
            automata.add(Automata.makeString((String)value));
            for (int i = value.length(); i < this.minChars; ++i) {
                automata.add(Automata.makeAnyChar());
            }
            Automaton automaton = Operations.concatenate(automata);
            AutomatonQuery query = new AutomatonQuery(new Term(this.name(), value + "*"), automaton);
            query.setRewriteMethod(method);
            return new BooleanQuery.Builder().add((Query)query, BooleanClause.Occur.SHOULD).add((Query)new TermQuery(new Term(this.parentField, value)), BooleanClause.Occur.SHOULD).build();
        }

        public String typeName() {
            return "prefix";
        }

        public String toString() {
            return super.toString() + ",prefixChars=" + this.minChars + ":" + this.maxChars;
        }

        public Query existsQuery(QueryShardContext context) {
            throw new UnsupportedOperationException();
        }
    }

    static class SearchAsYouTypeAnalyzer
    extends AnalyzerWrapper {
        private final Analyzer delegate;
        private final int shingleSize;
        private final boolean indexPrefixes;

        private SearchAsYouTypeAnalyzer(Analyzer delegate, int shingleSize, boolean indexPrefixes) {
            super(delegate.getReuseStrategy());
            this.delegate = Objects.requireNonNull(delegate);
            this.shingleSize = shingleSize;
            this.indexPrefixes = indexPrefixes;
        }

        static SearchAsYouTypeAnalyzer withShingle(Analyzer delegate, int shingleSize) {
            return new SearchAsYouTypeAnalyzer(delegate, shingleSize, false);
        }

        static SearchAsYouTypeAnalyzer withShingleAndPrefix(Analyzer delegate, int shingleSize) {
            return new SearchAsYouTypeAnalyzer(delegate, shingleSize, true);
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            return this.delegate;
        }

        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
            Object tokenStream = components.getTokenStream();
            if (this.indexPrefixes) {
                tokenStream = new TrailingShingleTokenFilter((TokenStream)tokenStream, this.shingleSize - 1);
            }
            tokenStream = new FixedShingleFilter(tokenStream, this.shingleSize, " ", "");
            if (this.indexPrefixes) {
                tokenStream = new EdgeNGramTokenFilter(tokenStream, 1, 20, true);
            }
            return new Analyzer.TokenStreamComponents(components.getSource(), tokenStream);
        }

        public int shingleSize() {
            return this.shingleSize;
        }

        public boolean indexPrefixes() {
            return this.indexPrefixes;
        }

        public String toString() {
            return "<" + ((Object)((Object)this)).getClass().getCanonicalName() + " shingleSize=[" + this.shingleSize + "] indexPrefixes=[" + this.indexPrefixes + "]>";
        }

        private static class TrailingShingleTokenFilter
        extends TokenFilter {
            private final int extraPositionIncrements;
            private final PositionIncrementAttribute positionIncrementAttribute;

            TrailingShingleTokenFilter(TokenStream input, int extraPositionIncrements) {
                super(input);
                this.extraPositionIncrements = extraPositionIncrements;
                this.positionIncrementAttribute = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
            }

            public boolean incrementToken() throws IOException {
                return this.input.incrementToken();
            }

            public void end() throws IOException {
                super.end();
                this.positionIncrementAttribute.setPositionIncrement(this.extraPositionIncrements);
            }
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder> {
        private int maxShingleSize = 3;
        private SimilarityProvider similarity;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public void similarity(SimilarityProvider similarity) {
            this.similarity = similarity;
        }

        public Builder maxShingleSize(int maxShingleSize) {
            if (maxShingleSize < 2 || maxShingleSize > 4) {
                throw new MapperParsingException("[max_shingle_size] must be at least [2] and at most [4], got [" + maxShingleSize + "]");
            }
            this.maxShingleSize = maxShingleSize;
            return (Builder)this.builder;
        }

        public Builder docValues(boolean docValues) {
            if (docValues) {
                throw new IllegalArgumentException("mapper [" + this.name() + "] of type [search_as_you_type] does not support doc values");
            }
            return this;
        }

        public SearchAsYouTypeFieldMapper build(Mapper.BuilderContext context) {
            SearchAsYouTypeFieldType ft = new SearchAsYouTypeFieldType(this.buildFullName(context), this.fieldType, this.similarity, this.searchAnalyzer, this.searchQuoteAnalyzer, this.meta);
            ft.setIndexAnalyzer(this.indexAnalyzer);
            FieldType prefixft = new FieldType((IndexableFieldType)this.fieldType);
            prefixft.setStoreTermVectors(false);
            prefixft.setOmitNorms(true);
            prefixft.setStored(false);
            String fullName = this.buildFullName(context);
            SearchAsYouTypeAnalyzer prefixIndexWrapper = SearchAsYouTypeAnalyzer.withShingleAndPrefix(this.indexAnalyzer.analyzer(), this.maxShingleSize);
            NamedAnalyzer prefixSearchWrapper = new NamedAnalyzer(this.searchAnalyzer.name(), this.searchAnalyzer.scope(), (Analyzer)SearchAsYouTypeAnalyzer.withShingle(this.searchAnalyzer.analyzer(), this.maxShingleSize));
            TextSearchInfo prefixSearchInfo = new TextSearchInfo(prefixft, this.similarity, prefixSearchWrapper, this.searchQuoteAnalyzer);
            PrefixFieldType prefixFieldType = new PrefixFieldType(fullName, prefixSearchInfo, 1, 20);
            prefixFieldType.setIndexAnalyzer(new NamedAnalyzer(this.indexAnalyzer.name(), AnalyzerScope.INDEX, (Analyzer)prefixIndexWrapper));
            PrefixFieldMapper prefixFieldMapper = new PrefixFieldMapper(prefixft, prefixFieldType);
            ShingleFieldMapper[] shingleFieldMappers = new ShingleFieldMapper[this.maxShingleSize - 1];
            ShingleFieldType[] shingleFieldTypes = new ShingleFieldType[this.maxShingleSize - 1];
            for (int i = 0; i < shingleFieldMappers.length; ++i) {
                int shingleSize = i + 2;
                FieldType shingleft = new FieldType((IndexableFieldType)this.fieldType);
                shingleft.setStored(false);
                String fieldName = SearchAsYouTypeFieldMapper.getShingleFieldName(this.buildFullName(context), shingleSize);
                SearchAsYouTypeAnalyzer shingleIndexWrapper = SearchAsYouTypeAnalyzer.withShingle(this.indexAnalyzer.analyzer(), shingleSize);
                NamedAnalyzer shingleSearchWrapper = new NamedAnalyzer(this.searchAnalyzer.name(), this.searchAnalyzer.scope(), (Analyzer)SearchAsYouTypeAnalyzer.withShingle(this.searchAnalyzer.analyzer(), shingleSize));
                NamedAnalyzer shingleSearchQuoteWrapper = new NamedAnalyzer(this.searchQuoteAnalyzer.name(), this.searchQuoteAnalyzer.scope(), (Analyzer)SearchAsYouTypeAnalyzer.withShingle(this.searchQuoteAnalyzer.analyzer(), shingleSize));
                TextSearchInfo textSearchInfo = new TextSearchInfo(shingleft, this.similarity, shingleSearchWrapper, shingleSearchQuoteWrapper);
                ShingleFieldType shingleFieldType = new ShingleFieldType(fieldName, shingleSize, textSearchInfo);
                shingleFieldType.setIndexAnalyzer(new NamedAnalyzer(this.indexAnalyzer.name(), AnalyzerScope.INDEX, (Analyzer)shingleIndexWrapper));
                shingleFieldType.setPrefixFieldType(prefixFieldType);
                shingleFieldTypes[i] = shingleFieldType;
                shingleFieldMappers[i] = new ShingleFieldMapper(shingleft, shingleFieldType);
            }
            ft.setPrefixField(prefixFieldType);
            ft.setShingleFields(shingleFieldTypes);
            return new SearchAsYouTypeFieldMapper(this.name, this.fieldType, ft, this.copyTo, this.maxShingleSize, prefixFieldMapper, shingleFieldMappers);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            builder.indexAnalyzer(parserContext.getIndexAnalyzers().getDefaultIndexAnalyzer());
            builder.searchAnalyzer(parserContext.getIndexAnalyzers().getDefaultSearchAnalyzer());
            builder.searchQuoteAnalyzer(parserContext.getIndexAnalyzers().getDefaultSearchQuoteAnalyzer());
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                TypeParsers.checkNull((String)fieldName, (Object)fieldNode);
                if (fieldName.equals("max_shingle_size")) {
                    builder.maxShingleSize(XContentMapValues.nodeIntegerValue((Object)fieldNode));
                    iterator.remove();
                    continue;
                }
                if (!fieldName.equals("similarity")) continue;
                SimilarityProvider similarityProvider = TypeParsers.resolveSimilarity((Mapper.TypeParser.ParserContext)parserContext, (String)fieldName, (String)fieldNode.toString());
                builder.similarity(similarityProvider);
                iterator.remove();
            }
            TypeParsers.parseTextField((FieldMapper.Builder)builder, (String)name, node, (Mapper.TypeParser.ParserContext)parserContext);
            return builder;
        }
    }

    public static class Defaults {
        public static final int MIN_GRAM = 1;
        public static final int MAX_GRAM = 20;
        public static final int MAX_SHINGLE_SIZE = 3;
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            FIELD_TYPE.freeze();
        }
    }
}

