/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.flowable.content.engine.impl.persistence.entity.data;

import org.flowable.common.engine.impl.cfg.IdGenerator;
import org.flowable.common.engine.impl.db.AbstractDataManager;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.content.engine.ContentEngineConfiguration;

/**
 * @author Joram Barrez
 * @author Tijs Rademakers
 */
public abstract class AbstractContentDataManager<EntityImpl extends Entity> extends AbstractDataManager<EntityImpl> {
    
    protected ContentEngineConfiguration contentEngineConfiguration;

    public AbstractContentDataManager(ContentEngineConfiguration contentEngineConfiguration) {
        this.contentEngineConfiguration = contentEngineConfiguration;
    }

    @Override
    protected IdGenerator getIdGenerator() {
        return contentEngineConfiguration.getIdGenerator();
    }
}
