/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.configurator.impl.deployer;

import java.util.Map;
import org.flowable.common.engine.api.repository.EngineDeployment;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.common.engine.impl.EngineDeployer;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.impl.bpmn.deployer.ResourceNameUtil;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.repository.DeploymentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnDeployer
implements EngineDeployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BpmnDeployer.class);

    public void deploy(EngineDeployment deployment, Map<String, Object> deploymentSettings) {
        if (!deployment.isNew()) {
            return;
        }
        LOGGER.debug("BpmnDeployer: processing deployment {}", (Object)deployment.getName());
        DeploymentBuilder bpmnDeploymentBuilder = null;
        Map resources = deployment.getResources();
        for (String resourceName : resources.keySet()) {
            if (!this.isBpmnResource(resourceName)) continue;
            LOGGER.info("BpmnDeployer: processing resource {}", (Object)resourceName);
            if (bpmnDeploymentBuilder == null) {
                RepositoryService repositoryService = CommandContextUtil.getProcessEngineConfiguration().getRepositoryService();
                bpmnDeploymentBuilder = repositoryService.createDeployment().name(deployment.getName());
            }
            bpmnDeploymentBuilder.addBytes(resourceName, ((EngineResource)resources.get(resourceName)).getBytes());
        }
        if (bpmnDeploymentBuilder != null) {
            bpmnDeploymentBuilder.parentDeploymentId(deployment.getId());
            bpmnDeploymentBuilder.key(deployment.getKey());
            if (deployment.getTenantId() != null && deployment.getTenantId().length() > 0) {
                bpmnDeploymentBuilder.tenantId(deployment.getTenantId());
            }
            bpmnDeploymentBuilder.deploy();
        }
    }

    protected boolean isBpmnResource(String resourceName) {
        for (String suffix : ResourceNameUtil.BPMN_RESOURCE_SUFFIXES) {
            if (!resourceName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }
}

