/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.flowable.engine.impl.cmd;

import java.io.Serializable;

import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.task.Comment;

/**
 * @author Frederik Heremans
 */
public class GetCommentCmd implements Command<Comment>, Serializable {

    private static final long serialVersionUID = 1L;
    protected String commentId;

    public GetCommentCmd(String commentId) {
        this.commentId = commentId;

        if (commentId == null) {
            throw new FlowableIllegalArgumentException("commentId is null");
        }
    }

    public Comment execute(CommandContext commandContext) {
        return commandContext.getCommentEntityManager().findComment(commentId);
    }
}
