/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.flowable.engine.impl.context;

import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.ProcessDefinition;

/**
 * @author Tom Baeyens
 */
public class ExecutionContext {

    protected ExecutionEntity execution;

    public ExecutionContext(ExecutionEntity execution) {
        this.execution = execution;
    }

    public ExecutionEntity getExecution() {
        return execution;
    }

    public ExecutionEntity getProcessInstance() {
        return execution.getProcessInstance();
    }

    public ProcessDefinition getProcessDefinition() {
        return ProcessDefinitionUtil.getProcessDefinition(execution.getProcessDefinitionId());
    }

    public DeploymentEntity getDeployment() {
        String deploymentId = getProcessDefinition().getDeploymentId();
        DeploymentEntity deployment = Context.getCommandContext().getDeploymentEntityManager().findById(deploymentId);
        return deployment;
    }
}
