/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.helper;

import java.util.List;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.parser.FieldDeclaration;
import org.flowable.engine.impl.util.ReflectUtil;

public abstract class AbstractClassDelegate
extends AbstractBpmnActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected String serviceTaskId;
    protected String className;
    protected List<FieldDeclaration> fieldDeclarations;

    public AbstractClassDelegate(String className, List<FieldDeclaration> fieldDeclarations) {
        this.className = className;
        this.fieldDeclarations = fieldDeclarations;
    }

    public AbstractClassDelegate(Class<?> clazz, List<FieldDeclaration> fieldDeclarations) {
        this.className = clazz.getName();
        this.fieldDeclarations = fieldDeclarations;
    }

    protected Object instantiateDelegate(String className, List<FieldDeclaration> fieldDeclarations) {
        return AbstractClassDelegate.defaultInstantiateDelegate(className, fieldDeclarations);
    }

    public static Object defaultInstantiateDelegate(Class<?> clazz, List<FieldDeclaration> fieldDeclarations, ServiceTask serviceTask) {
        return AbstractClassDelegate.defaultInstantiateDelegate(clazz.getName(), fieldDeclarations, serviceTask);
    }

    public static Object defaultInstantiateDelegate(Class<?> clazz, List<FieldDeclaration> fieldDeclarations) {
        return AbstractClassDelegate.defaultInstantiateDelegate(clazz.getName(), fieldDeclarations);
    }

    public static Object defaultInstantiateDelegate(String className, List<FieldDeclaration> fieldDeclarations, ServiceTask serviceTask) {
        Object object = ReflectUtil.instantiate(className);
        AbstractClassDelegate.applyFieldDeclaration(fieldDeclarations, object);
        if (serviceTask != null) {
            ReflectUtil.invokeSetterOrField(object, "serviceTask", serviceTask, false);
        }
        return object;
    }

    public static Object defaultInstantiateDelegate(String className, List<FieldDeclaration> fieldDeclarations) {
        return AbstractClassDelegate.defaultInstantiateDelegate(className, fieldDeclarations, null);
    }

    public static void applyFieldDeclaration(List<FieldDeclaration> fieldDeclarations, Object target) {
        AbstractClassDelegate.applyFieldDeclaration(fieldDeclarations, target, true);
    }

    public static void applyFieldDeclaration(List<FieldDeclaration> fieldDeclarations, Object target, boolean throwExceptionOnMissingField) {
        if (fieldDeclarations != null) {
            for (FieldDeclaration declaration : fieldDeclarations) {
                AbstractClassDelegate.applyFieldDeclaration(declaration, target, throwExceptionOnMissingField);
            }
        }
    }

    public static void applyFieldDeclaration(FieldDeclaration declaration, Object target) {
        AbstractClassDelegate.applyFieldDeclaration(declaration, target, true);
    }

    public static void applyFieldDeclaration(FieldDeclaration declaration, Object target, boolean throwExceptionOnMissingField) {
        ReflectUtil.invokeSetterOrField(target, declaration.getName(), declaration.getValue(), throwExceptionOnMissingField);
    }

    public String getClassName() {
        return this.className;
    }
}

