/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.ProcessDefinitionQueryImpl;
import org.flowable.engine.impl.ProcessInstanceQueryImpl;
import org.flowable.engine.impl.cmd.AbstractSetProcessInstanceStateCmd;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.jobexecutor.TimerChangeProcessDefinitionSuspensionStateJobHandler;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntityManager;
import org.flowable.engine.impl.persistence.entity.SuspensionState;
import org.flowable.engine.impl.persistence.entity.TimerJobEntity;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;

public abstract class AbstractSetProcessDefinitionStateCmd
implements Command<Void> {
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected ProcessDefinitionEntity processDefinitionEntity;
    protected boolean includeProcessInstances;
    protected Date executionDate;
    protected String tenantId;

    public AbstractSetProcessDefinitionStateCmd(ProcessDefinitionEntity processDefinitionEntity, boolean includeProcessInstances, Date executionDate, String tenantId) {
        this.processDefinitionEntity = processDefinitionEntity;
        this.includeProcessInstances = includeProcessInstances;
        this.executionDate = executionDate;
        this.tenantId = tenantId;
    }

    public AbstractSetProcessDefinitionStateCmd(String processDefinitionId, String processDefinitionKey, boolean includeProcessInstances, Date executionDate, String tenantId) {
        this.processDefinitionId = processDefinitionId;
        this.processDefinitionKey = processDefinitionKey;
        this.includeProcessInstances = includeProcessInstances;
        this.executionDate = executionDate;
        this.tenantId = tenantId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        List<ProcessDefinitionEntity> processDefinitions = this.findProcessDefinition(commandContext);
        boolean hasV5ProcessDefinitions = false;
        for (ProcessDefinitionEntity processDefinitionEntity : processDefinitions) {
            if (!Flowable5Util.isFlowable5ProcessDefinition((ProcessDefinition)processDefinitionEntity, commandContext)) continue;
            hasV5ProcessDefinitions = true;
            break;
        }
        if (hasV5ProcessDefinitions) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            if (this.getProcessDefinitionSuspensionState() == SuspensionState.ACTIVE) {
                compatibilityHandler.activateProcessDefinition(this.processDefinitionId, this.processDefinitionKey, this.includeProcessInstances, this.executionDate, this.tenantId);
            } else if (this.getProcessDefinitionSuspensionState() == SuspensionState.SUSPENDED) {
                compatibilityHandler.suspendProcessDefinition(this.processDefinitionId, this.processDefinitionKey, this.includeProcessInstances, this.executionDate, this.tenantId);
            }
            return null;
        }
        if (this.executionDate != null) {
            this.createTimerForDelayedExecution(commandContext, processDefinitions);
        } else {
            this.changeProcessDefinitionState(commandContext, processDefinitions);
        }
        return null;
    }

    protected List<ProcessDefinitionEntity> findProcessDefinition(CommandContext commandContext) {
        if (this.processDefinitionEntity != null) {
            return Collections.singletonList(this.processDefinitionEntity);
        }
        if (this.processDefinitionId == null && this.processDefinitionKey == null) {
            throw new FlowableIllegalArgumentException("Process definition id or key cannot be null");
        }
        ArrayList<ProcessDefinitionEntity> processDefinitionEntities = new ArrayList<ProcessDefinitionEntity>();
        ProcessDefinitionEntityManager processDefinitionManager = commandContext.getProcessDefinitionEntityManager();
        if (this.processDefinitionId != null) {
            ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)processDefinitionManager.findById(this.processDefinitionId);
            if (processDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("Cannot find process definition for id '" + this.processDefinitionId + "'", ProcessDefinition.class);
            }
            processDefinitionEntities.add(processDefinitionEntity);
        } else {
            ProcessDefinitionQueryImpl query = new ProcessDefinitionQueryImpl(commandContext).processDefinitionKey(this.processDefinitionKey);
            if (this.tenantId == null || "".equals(this.tenantId)) {
                query.processDefinitionWithoutTenantId();
            } else {
                query.processDefinitionTenantId(this.tenantId);
            }
            List processDefinitions = query.list();
            if (processDefinitions.isEmpty()) {
                throw new FlowableException("Cannot find process definition for key '" + this.processDefinitionKey + "'");
            }
            for (ProcessDefinition processDefinition : processDefinitions) {
                processDefinitionEntities.add((ProcessDefinitionEntity)processDefinition);
            }
        }
        return processDefinitionEntities;
    }

    protected void createTimerForDelayedExecution(CommandContext commandContext, List<ProcessDefinitionEntity> processDefinitions) {
        for (ProcessDefinitionEntity processDefinition : processDefinitions) {
            if (Flowable5Util.isFlowable5ProcessDefinition((ProcessDefinition)processDefinition, commandContext)) continue;
            TimerJobEntity timer = (TimerJobEntity)commandContext.getTimerJobEntityManager().create();
            timer.setJobType("timer");
            timer.setProcessDefinitionId(processDefinition.getId());
            if (processDefinition.getTenantId() != null) {
                timer.setTenantId(processDefinition.getTenantId());
            }
            timer.setDuedate(this.executionDate);
            timer.setJobHandlerType(this.getDelayedExecutionJobHandlerType());
            timer.setJobHandlerConfiguration(TimerChangeProcessDefinitionSuspensionStateJobHandler.createJobHandlerConfiguration(this.includeProcessInstances));
            commandContext.getJobManager().scheduleTimerJob(timer);
        }
    }

    protected void changeProcessDefinitionState(CommandContext commandContext, List<ProcessDefinitionEntity> processDefinitions) {
        for (ProcessDefinitionEntity processDefinition : processDefinitions) {
            if (Flowable5Util.isFlowable5ProcessDefinition((ProcessDefinition)processDefinition, commandContext)) continue;
            SuspensionState.SuspensionStateUtil.setSuspensionState(processDefinition, this.getProcessDefinitionSuspensionState());
            commandContext.getProcessEngineConfiguration().getDeploymentManager().getProcessDefinitionCache().remove(processDefinition.getId());
            if (!this.includeProcessInstances) continue;
            int currentStartIndex = 0;
            List<ProcessInstance> processInstances = this.fetchProcessInstancesPage(commandContext, processDefinition, currentStartIndex);
            while (!processInstances.isEmpty()) {
                for (ProcessInstance processInstance : processInstances) {
                    AbstractSetProcessInstanceStateCmd processInstanceCmd = this.getProcessInstanceChangeStateCmd(processInstance);
                    processInstanceCmd.execute(commandContext);
                }
                processInstances = this.fetchProcessInstancesPage(commandContext, processDefinition, currentStartIndex += processInstances.size());
            }
        }
    }

    protected List<ProcessInstance> fetchProcessInstancesPage(CommandContext commandContext, ProcessDefinition processDefinition, int currentPageStartIndex) {
        if (SuspensionState.ACTIVE.equals(this.getProcessDefinitionSuspensionState())) {
            return new ProcessInstanceQueryImpl(commandContext).processDefinitionId(processDefinition.getId()).suspended().listPage(currentPageStartIndex, commandContext.getProcessEngineConfiguration().getBatchSizeProcessInstances());
        }
        return new ProcessInstanceQueryImpl(commandContext).processDefinitionId(processDefinition.getId()).active().listPage(currentPageStartIndex, commandContext.getProcessEngineConfiguration().getBatchSizeProcessInstances());
    }

    protected abstract SuspensionState getProcessDefinitionSuspensionState();

    protected abstract String getDelayedExecutionJobHandlerType();

    protected abstract AbstractSetProcessInstanceStateCmd getProcessInstanceChangeStateCmd(ProcessInstance var1);
}

