/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.HistoryLevel;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.TaskEntity;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.task.Task;
import org.flowable.engine.task.TaskInfo;

public class SaveTaskCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected TaskEntity task;

    public SaveTaskCmd(Task task) {
        this.task = (TaskEntity)task;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.task == null) {
            throw new FlowableIllegalArgumentException("task is null");
        }
        if (this.task.getProcessDefinitionId() != null && Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, this.task.getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            compatibilityHandler.saveTask(this.task);
            return null;
        }
        if (this.task.getRevision() == 0) {
            commandContext.getTaskEntityManager().insert(this.task, null, true);
            if (commandContext.getEventDispatcher().isEnabled()) {
                commandContext.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_CREATED, this.task));
            }
        } else {
            ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
            TaskInfo originalTaskEntity = (TaskInfo)commandContext.getTaskEntityManager().findById(this.task.getId());
            if (originalTaskEntity == null && processEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
                originalTaskEntity = (TaskInfo)commandContext.getHistoricTaskInstanceEntityManager().findById(this.task.getId());
            }
            String originalAssignee = originalTaskEntity.getAssignee();
            commandContext.getHistoryManager().recordTaskInfoChange(this.task);
            if (!StringUtils.equals((CharSequence)originalAssignee, (CharSequence)this.task.getAssignee())) {
                commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners(this.task, "assignment");
                if (commandContext.getEventDispatcher().isEnabled()) {
                    commandContext.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_ASSIGNED, this.task));
                }
            }
            commandContext.getTaskEntityManager().update(this.task);
        }
        return null;
    }
}

