/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.el;

import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.javax.el.ELContext;
import org.flowable.engine.common.impl.javax.el.ELException;
import org.flowable.engine.common.impl.javax.el.MethodNotFoundException;
import org.flowable.engine.common.impl.javax.el.PropertyNotFoundException;
import org.flowable.engine.common.impl.javax.el.ValueExpression;
import org.flowable.engine.delegate.Expression;
import org.flowable.engine.delegate.VariableScope;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.delegate.invocation.ExpressionGetInvocation;
import org.flowable.engine.impl.delegate.invocation.ExpressionSetInvocation;
import org.flowable.engine.impl.el.ExpressionManager;
import org.flowable.engine.impl.interceptor.DelegateInterceptor;

public class JuelExpression
implements Expression {
    private static final long serialVersionUID = 1L;
    protected String expressionText;
    protected ValueExpression valueExpression;
    protected ExpressionManager expressionManager;
    protected DelegateInterceptor delegateInterceptor;

    public JuelExpression(ExpressionManager expressionManager, DelegateInterceptor delegateInterceptor, ValueExpression valueExpression, String expressionText) {
        this.valueExpression = valueExpression;
        this.expressionText = expressionText;
        this.expressionManager = expressionManager;
        this.delegateInterceptor = delegateInterceptor;
    }

    @Override
    public Object getValue(VariableScope variableScope) {
        ELContext elContext = this.expressionManager.getElContext(variableScope);
        try {
            ExpressionGetInvocation invocation = new ExpressionGetInvocation(this.valueExpression, elContext);
            this.delegateInterceptor.handleInvocation(invocation);
            return invocation.getInvocationResult();
        }
        catch (PropertyNotFoundException pnfe) {
            throw new FlowableException("Unknown property used in expression: " + this.expressionText, (Throwable)pnfe);
        }
        catch (MethodNotFoundException mnfe) {
            throw new FlowableException("Unknown method used in expression: " + this.expressionText, (Throwable)mnfe);
        }
        catch (ELException ele) {
            throw new FlowableException("Error while evaluating expression: " + this.expressionText, (Throwable)ele);
        }
        catch (Exception e) {
            throw new FlowableException("Error while evaluating expression: " + this.expressionText, (Throwable)e);
        }
    }

    @Override
    public void setValue(Object value, VariableScope variableScope) {
        ELContext elContext = this.expressionManager.getElContext(variableScope);
        try {
            ExpressionSetInvocation invocation = new ExpressionSetInvocation(this.valueExpression, elContext, value);
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
        }
        catch (Exception e) {
            throw new FlowableException("Error while evaluating expression: " + this.expressionText, (Throwable)e);
        }
    }

    public String toString() {
        if (this.valueExpression != null) {
            return this.valueExpression.getExpressionString();
        }
        return super.toString();
    }

    @Override
    public String getExpressionText() {
        return this.expressionText;
    }
}

