/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.impl.history.async.AsyncHistoryJobNotApplicableException;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.jobexecutor.HistoryJobHandler;
import org.flowable.engine.impl.persistence.entity.HistoryJobEntity;

public abstract class AbstractAsyncHistoryJobHandler
implements HistoryJobHandler {
    protected boolean isJsonGzipCompressionEnabled;
    protected boolean isAsyncHistoryJsonGroupingEnabled;

    @Override
    public void execute(HistoryJobEntity job, String configuration, CommandContext commandContext) {
        ObjectMapper objectMapper = commandContext.getProcessEngineConfiguration().getObjectMapper();
        if (job.getAdvancedJobHandlerConfigurationByteArrayRef() != null) {
            try {
                byte[] bytes = job.getAdvancedJobHandlerConfigurationByteArrayRef().getBytes();
                if (this.isJsonGzipCompressionEnabled) {
                    bytes = this.decompress(bytes);
                }
                JsonNode historyNode = objectMapper.readTree(bytes);
                if (this.isAsyncHistoryJsonGroupingEnabled() && historyNode.isArray()) {
                    ArrayNode arrayNode = (ArrayNode)historyNode;
                    for (JsonNode jsonNode : arrayNode) {
                        this.processHistoryJson(commandContext, job, jsonNode);
                    }
                } else {
                    this.processHistoryJson(commandContext, job, historyNode);
                }
            }
            catch (AsyncHistoryJobNotApplicableException e) {
                throw e;
            }
            catch (Exception e) {
                throw new FlowableException("Could not deserialize async history json for job (id=" + job.getId() + ")", (Throwable)e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected byte[] decompress(byte[] compressed) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract void processHistoryJson(CommandContext var1, HistoryJobEntity var2, JsonNode var3);

    public boolean isJsonGzipCompressionEnabled() {
        return this.isJsonGzipCompressionEnabled;
    }

    public void setJsonGzipCompressionEnabled(boolean isJsonGzipCompressionEnabled) {
        this.isJsonGzipCompressionEnabled = isJsonGzipCompressionEnabled;
    }

    public boolean isAsyncHistoryJsonGroupingEnabled() {
        return this.isAsyncHistoryJsonGroupingEnabled;
    }

    public void setAsyncHistoryJsonGroupingEnabled(boolean isAsyncHistoryJsonGroupingEnabled) {
        this.isAsyncHistoryJsonGroupingEnabled = isAsyncHistoryJsonGroupingEnabled;
    }
}

