/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricVariableInstanceEntityManager;
import org.flowable.engine.impl.persistence.entity.HistoryJobEntity;
import org.flowable.engine.impl.variable.VariableType;
import org.flowable.engine.impl.variable.VariableTypes;

public class VariableCreatedHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    @Override
    public String getType() {
        return "variable-created";
    }

    @Override
    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        return true;
    }

    @Override
    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        HistoricVariableInstanceEntityManager historicVariableInstanceEntityManager = commandContext.getProcessEngineConfiguration().getHistoricVariableInstanceEntityManager();
        HistoricVariableInstanceEntity historicVariableInstanceEntity = (HistoricVariableInstanceEntity)historicVariableInstanceEntityManager.create();
        historicVariableInstanceEntity.setId(this.getStringFromJson(historicalData, "id"));
        historicVariableInstanceEntity.setProcessInstanceId(this.getStringFromJson(historicalData, "processInstanceId"));
        historicVariableInstanceEntity.setExecutionId(this.getStringFromJson(historicalData, "executionId"));
        historicVariableInstanceEntity.setTaskId(this.getStringFromJson(historicalData, "taskId"));
        historicVariableInstanceEntity.setRevision(this.getIntegerFromJson(historicalData, "revision"));
        historicVariableInstanceEntity.setName(this.getStringFromJson(historicalData, "name"));
        VariableTypes variableTypes = Context.getProcessEngineConfiguration().getVariableTypes();
        VariableType variableType = variableTypes.getVariableType(this.getStringFromJson(historicalData, "variableType"));
        historicVariableInstanceEntity.setVariableType(variableType);
        historicVariableInstanceEntity.setTextValue(this.getStringFromJson(historicalData, "variableTextValue"));
        historicVariableInstanceEntity.setTextValue2(this.getStringFromJson(historicalData, "variableTextValue2"));
        historicVariableInstanceEntity.setDoubleValue(this.getDoubleFromJson(historicalData, "variableDoubleValue"));
        historicVariableInstanceEntity.setLongValue(this.getLongFromJson(historicalData, "variableLongValue"));
        String variableBytes = this.getStringFromJson(historicalData, "variableBytesValue");
        if (StringUtils.isNotEmpty((CharSequence)variableBytes)) {
            historicVariableInstanceEntity.setBytes(Base64.decodeBase64((String)variableBytes));
        }
        Date time = this.getDateFromJson(historicalData, "createTime");
        historicVariableInstanceEntity.setCreateTime(time);
        historicVariableInstanceEntity.setLastUpdatedTime(time);
        historicVariableInstanceEntityManager.insert(historicVariableInstanceEntity);
    }
}

