/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.interceptor;

import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.flowable.engine.impl.agenda.AbstractOperation;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.interceptor.AbstractCommandInterceptor;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.interceptor.CommandInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandInvoker
extends AbstractCommandInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(CommandInvoker.class);

    @Override
    public <T> T execute(CommandConfig config, final Command<T> command) {
        final CommandContext commandContext = Context.getCommandContext();
        if (commandContext.isReused()) {
            return command.execute(commandContext);
        }
        commandContext.getAgenda().planOperation(new Runnable(){

            @Override
            public void run() {
                commandContext.setResult(command.execute(commandContext));
            }
        });
        this.executeOperations(commandContext);
        if (!commandContext.isReused() && commandContext.hasInvolvedExecutions()) {
            commandContext.getAgenda().planExecuteInactiveBehaviorsOperation();
            this.executeOperations(commandContext);
        }
        return (T)commandContext.getResult();
    }

    protected void executeOperations(CommandContext commandContext) {
        while (!commandContext.getAgenda().isEmpty()) {
            Runnable runnable = commandContext.getAgenda().getNextOperation();
            this.executeOperation(runnable);
        }
    }

    public void executeOperation(Runnable runnable) {
        if (runnable instanceof AbstractOperation) {
            AbstractOperation operation = (AbstractOperation)runnable;
            if (operation.getExecution() == null || !operation.getExecution().isEnded()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Executing operation {} ", operation.getClass());
                }
                runnable.run();
            }
        } else {
            runnable.run();
        }
    }

    @Override
    public CommandInterceptor getNext() {
        return null;
    }

    @Override
    public void setNext(CommandInterceptor next) {
        throw new UnsupportedOperationException("CommandInvoker must be the last interceptor in the chain");
    }
}

