/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.jobexecutor;

import org.flowable.engine.common.impl.cfg.TransactionPropagation;
import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.flowable.engine.impl.asyncexecutor.AsyncExecutor;
import org.flowable.engine.impl.cfg.TransactionListener;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.interceptor.CommandExecutor;
import org.flowable.engine.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobAddedTransactionListener
implements TransactionListener {
    private static Logger log = LoggerFactory.getLogger(JobAddedTransactionListener.class);
    protected JobEntity job;
    protected AsyncExecutor asyncExecutor;

    public JobAddedTransactionListener(JobEntity job, AsyncExecutor asyncExecutor) {
        this.job = job;
        this.asyncExecutor = asyncExecutor;
    }

    @Override
    public void execute(CommandContext commandContext) {
        CommandExecutor commandExecutor = commandContext.getProcessEngineConfiguration().getCommandExecutor();
        CommandConfig commandConfig = new CommandConfig(false, TransactionPropagation.REQUIRES_NEW);
        commandExecutor.execute(commandConfig, new Command<Void>(){

            @Override
            public Void execute(CommandContext commandContext) {
                if (log.isTraceEnabled()) {
                    log.trace("notifying job executor of new job");
                }
                JobAddedTransactionListener.this.asyncExecutor.executeAsyncJob(JobAddedTransactionListener.this.job);
                return null;
            }
        });
    }
}

