/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity.data.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.flowable.engine.common.impl.Page;
import org.flowable.engine.common.impl.db.ListQueryParameterObject;
import org.flowable.engine.impl.HistoryJobQueryImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.HistoryJobEntity;
import org.flowable.engine.impl.persistence.entity.HistoryJobEntityImpl;
import org.flowable.engine.impl.persistence.entity.data.AbstractDataManager;
import org.flowable.engine.impl.persistence.entity.data.HistoryJobDataManager;
import org.flowable.engine.runtime.HistoryJob;

public class MybatisHistoryJobDataManager
extends AbstractDataManager<HistoryJobEntity>
implements HistoryJobDataManager {
    public MybatisHistoryJobDataManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends HistoryJobEntity> getManagedEntityClass() {
        return HistoryJobEntityImpl.class;
    }

    public HistoryJobEntity create() {
        return new HistoryJobEntityImpl();
    }

    @Override
    public List<HistoryJobEntity> findJobsToExecute(Page page) {
        ListQueryParameterObject params = new ListQueryParameterObject();
        params.setFirstResult(page.getFirstResult());
        params.setMaxResults(page.getMaxResults());
        params.setOrderByColumns("CREATE_TIME_ ASC");
        return this.getDbSqlSession().selectList("selectHistoryJobsToExecute", params);
    }

    @Override
    public List<HistoryJobEntity> findJobsByExecutionId(String executionId) {
        return this.getDbSqlSession().selectList("selectHistoryJobsByExecutionId", executionId);
    }

    @Override
    public List<HistoryJobEntity> findJobsByProcessInstanceId(String processInstanceId) {
        return this.getDbSqlSession().selectList("selectHistoryJobsByProcessInstanceId", processInstanceId);
    }

    @Override
    public List<HistoryJobEntity> findExpiredJobs(Page page) {
        Date now = this.getClock().getCurrentTime();
        return this.getDbSqlSession().selectList("selectExpiredHistoryJobs", now, page);
    }

    @Override
    public List<HistoryJob> findHistoryJobsByQueryCriteria(HistoryJobQueryImpl jobQuery) {
        String query = "selectHistoryJobByQueryCriteria";
        return this.getDbSqlSession().selectList("selectHistoryJobByQueryCriteria", jobQuery);
    }

    @Override
    public long findHistoryJobCountByQueryCriteria(HistoryJobQueryImpl jobQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectHistoryJobCountByQueryCriteria", jobQuery);
    }

    @Override
    public void updateJobTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateHistoryJobTenantIdForDeployment", params);
    }

    @Override
    public void resetExpiredJob(String jobId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("id", jobId);
        this.getDbSqlSession().update("resetExpiredHistoryJob", params);
    }
}

