/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.deployer;

import java.util.LinkedHashMap;
import java.util.Map;
import org.flowable.common.engine.impl.cfg.IdGenerator;
import org.flowable.form.engine.impl.deployer.CachingAndArtifactsManager;
import org.flowable.form.engine.impl.deployer.FormDefinitionDeploymentHelper;
import org.flowable.form.engine.impl.deployer.ParsedDeployment;
import org.flowable.form.engine.impl.deployer.ParsedDeploymentBuilderFactory;
import org.flowable.form.engine.impl.persistence.deploy.Deployer;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntity;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntityManager;
import org.flowable.form.engine.impl.persistence.entity.FormDeploymentEntity;
import org.flowable.form.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormDefinitionDeployer
implements Deployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormDefinitionDeployer.class);
    protected IdGenerator idGenerator;
    protected ParsedDeploymentBuilderFactory parsedDeploymentBuilderFactory;
    protected FormDefinitionDeploymentHelper formDeploymentHelper;
    protected CachingAndArtifactsManager cachingAndArtifactsManager;

    @Override
    public void deploy(FormDeploymentEntity deployment) {
        LOGGER.debug("Processing deployment {}", (Object)deployment.getName());
        ParsedDeployment parsedDeployment = this.parsedDeploymentBuilderFactory.getBuilderForDeployment(deployment).build();
        this.formDeploymentHelper.verifyFormsDoNotShareKeys(parsedDeployment.getAllFormDefinitions());
        this.formDeploymentHelper.copyDeploymentValuesToForms(parsedDeployment.getDeployment(), parsedDeployment.getAllFormDefinitions());
        this.formDeploymentHelper.setResourceNamesOnFormDefinitions(parsedDeployment);
        if (deployment.isNew()) {
            Map<FormDefinitionEntity, FormDefinitionEntity> mapOfNewFormToPreviousVersion = this.getPreviousVersionsOfFormDefinitions(parsedDeployment);
            this.setFormDefinitionVersionsAndIds(parsedDeployment, mapOfNewFormToPreviousVersion);
            this.persistFormDefinitions(parsedDeployment);
        } else {
            this.makeFormDefinitionsConsistentWithPersistedVersions(parsedDeployment);
        }
        this.cachingAndArtifactsManager.updateCachingAndArtifacts(parsedDeployment);
    }

    protected Map<FormDefinitionEntity, FormDefinitionEntity> getPreviousVersionsOfFormDefinitions(ParsedDeployment parsedDeployment) {
        LinkedHashMap<FormDefinitionEntity, FormDefinitionEntity> result = new LinkedHashMap<FormDefinitionEntity, FormDefinitionEntity>();
        for (FormDefinitionEntity newDefinition : parsedDeployment.getAllFormDefinitions()) {
            FormDefinitionEntity existingFormDefinition = this.formDeploymentHelper.getMostRecentVersionOfForm(newDefinition);
            if (existingFormDefinition == null) continue;
            result.put(newDefinition, existingFormDefinition);
        }
        return result;
    }

    protected void setFormDefinitionVersionsAndIds(ParsedDeployment parsedDeployment, Map<FormDefinitionEntity, FormDefinitionEntity> mapNewToOldForms) {
        for (FormDefinitionEntity formDefinition : parsedDeployment.getAllFormDefinitions()) {
            int version = 1;
            FormDefinitionEntity latest = mapNewToOldForms.get(formDefinition);
            if (latest != null) {
                version = latest.getVersion() + 1;
            }
            formDefinition.setVersion(version);
            formDefinition.setId(this.idGenerator.getNextId());
        }
    }

    protected void persistFormDefinitions(ParsedDeployment parsedDeployment) {
        FormDefinitionEntityManager formDefinitionEntityManager = CommandContextUtil.getFormDefinitionEntityManager();
        for (FormDefinitionEntity formDefinition : parsedDeployment.getAllFormDefinitions()) {
            formDefinitionEntityManager.insert(formDefinition);
        }
    }

    protected void makeFormDefinitionsConsistentWithPersistedVersions(ParsedDeployment parsedDeployment) {
        for (FormDefinitionEntity formDefinition : parsedDeployment.getAllFormDefinitions()) {
            FormDefinitionEntity persistedFormDefinition = this.formDeploymentHelper.getPersistedInstanceOfFormDefinition(formDefinition);
            if (persistedFormDefinition == null) continue;
            formDefinition.setId(persistedFormDefinition.getId());
            formDefinition.setVersion(persistedFormDefinition.getVersion());
        }
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public ParsedDeploymentBuilderFactory getExParsedDeploymentBuilderFactory() {
        return this.parsedDeploymentBuilderFactory;
    }

    public void setParsedDeploymentBuilderFactory(ParsedDeploymentBuilderFactory parsedDeploymentBuilderFactory) {
        this.parsedDeploymentBuilderFactory = parsedDeploymentBuilderFactory;
    }

    public FormDefinitionDeploymentHelper getFormDeploymentHelper() {
        return this.formDeploymentHelper;
    }

    public void setFormDeploymentHelper(FormDefinitionDeploymentHelper formDeploymentHelper) {
        this.formDeploymentHelper = formDeploymentHelper;
    }

    public CachingAndArtifactsManager getCachingAndArtifcatsManager() {
        return this.cachingAndArtifactsManager;
    }

    public void setCachingAndArtifactsManager(CachingAndArtifactsManager manager) {
        this.cachingAndArtifactsManager = manager;
    }
}

