/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.service.debugger;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.scripting.ScriptingEngines;
import org.flowable.engine.HistoryService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.event.EventLogEntry;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityImpl;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessDebugger;
import org.flowable.job.api.Job;
import org.flowable.job.api.JobQuery;
import org.flowable.job.api.SuspendedJobQuery;
import org.flowable.ui.task.model.debugger.BreakpointRepresentation;
import org.flowable.ui.task.model.debugger.ExecutionRepresentation;
import org.flowable.ui.task.service.debugger.DebuggerRestVariable;
import org.flowable.variable.api.delegate.VariableScope;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class DebuggerService
implements ProcessDebugger,
ApplicationContextAware {
    protected List<BreakpointRepresentation> breakpoints = new ArrayList<BreakpointRepresentation>();
    protected ApplicationContext applicationContext;

    public void addBreakpoint(BreakpointRepresentation breakpointRepresentation) {
        assert (breakpointRepresentation != null && StringUtils.isNotBlank((CharSequence)breakpointRepresentation.getActivityId()));
        this.breakpoints.add(breakpointRepresentation);
    }

    public void removeBreakpoint(BreakpointRepresentation breakpointRepresentation) {
        assert (breakpointRepresentation != null && StringUtils.isNotBlank((CharSequence)breakpointRepresentation.getActivityId()));
        if (!this.breakpoints.remove((Object)breakpointRepresentation)) {
            throw new FlowableException("Breakpoint is not set on the activityId");
        }
    }

    public List<BreakpointRepresentation> getBreakpoints() {
        return this.breakpoints;
    }

    public Collection<String> getBrokenExecutions(String activityId, String processInstanceId) {
        List brokenJobs = ((SuspendedJobQuery)((SuspendedJobQuery)this.getManagementService().createSuspendedJobQuery().processInstanceId(processInstanceId)).handlerType("breakpoint")).list();
        ArrayList<String> executions = new ArrayList<String>();
        for (Job brokenJob : brokenJobs) {
            Execution brokenJobExecution = (Execution)this.getRuntimeService().createExecutionQuery().executionId(brokenJob.getExecutionId()).singleResult();
            if (!activityId.equals(brokenJobExecution.getActivityId())) continue;
            executions.add(brokenJob.getExecutionId());
        }
        return executions;
    }

    public List<EventLogEntry> getProcessInstanceEventLog(String processInstanceId) {
        return this.getManagementService().getEventLogEntriesByProcessInstanceId(processInstanceId);
    }

    public void continueExecution(String executionId) {
        Job job = (Job)((SuspendedJobQuery)((SuspendedJobQuery)this.getManagementService().createSuspendedJobQuery().handlerType("breakpoint")).executionId(executionId)).singleResult();
        if (job == null) {
            throw new FlowableException("No broken job found for execution '" + executionId + "'");
        }
        this.getManagementService().moveSuspendedJobToExecutableJob(job.getId());
        try {
            while (((JobQuery)this.getManagementService().createJobQuery().jobId(job.getId())).count() > 0L) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isBreakpoint(Execution execution) {
        for (BreakpointRepresentation breakpoint : this.breakpoints) {
            if (!breakpoint.getActivityId().equals(execution.getActivityId())) continue;
            if (StringUtils.isEmpty((CharSequence)breakpoint.getProcessDefinitionId())) {
                return true;
            }
            if (!Objects.equals(breakpoint.getProcessDefinitionId(), ((ExecutionEntity)execution).getProcessDefinitionId())) continue;
            return true;
        }
        return false;
    }

    protected ManagementService getManagementService() {
        return (ManagementService)this.applicationContext.getBean(ManagementService.class);
    }

    protected RuntimeService getRuntimeService() {
        return (RuntimeService)this.applicationContext.getBean(RuntimeService.class);
    }

    protected HistoryService getHistoricService() {
        return (HistoryService)this.applicationContext.getBean(HistoryService.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public List<DebuggerRestVariable> getExecutionVariables(String executionId) {
        List executions = this.getRuntimeService().createExecutionQuery().executionId(executionId).list();
        if (executions.isEmpty()) {
            return this.getHistoricService().createHistoricVariableInstanceQuery().executionId(executionId).list().stream().map(DebuggerRestVariable::new).collect(Collectors.toList());
        }
        return this.getRuntimeService().getVariableInstances(executionId).values().stream().map(DebuggerRestVariable::new).collect(Collectors.toList());
    }

    public List<ExecutionRepresentation> getExecutions(String processInstanceId) {
        List executions = this.getRuntimeService().createExecutionQuery().processInstanceId(processInstanceId).list();
        ArrayList<ExecutionRepresentation> executionRepresentations = new ArrayList<ExecutionRepresentation>(executions.size());
        for (Execution execution : executions) {
            executionRepresentations.add(new ExecutionRepresentation(execution.getId(), execution.getParentId(), execution.getProcessInstanceId(), execution.getSuperExecutionId(), execution.getActivityId(), execution.isSuspended(), execution.getTenantId()));
        }
        return executionRepresentations;
    }

    public Object evaluateExpression(String executionId, String expressionString) {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)this.applicationContext.getBean(ProcessEngineConfigurationImpl.class);
        return processEngineConfiguration.getManagementService().executeCommand(commandContext -> {
            ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
            Expression expression = expressionManager.createExpression(expressionString);
            Execution execution = (Execution)Context.getProcessEngineConfiguration().getExecutionEntityManager().findById(executionId);
            return expression.getValue((VariableContainer)((VariableScope)execution));
        });
    }

    public void evaluateScript(String executionId, String scriptLanguage, String script) {
        this.getManagementService().executeCommand(commandContext -> {
            ScriptingEngines scriptingEngines = Context.getProcessEngineConfiguration().getScriptingEngines();
            Execution execution = (Execution)Context.getProcessEngineConfiguration().getExecutionEntityManager().findById(executionId);
            scriptingEngines.evaluate(script, scriptLanguage, (VariableContainer)((ExecutionEntityImpl)execution), false);
            return null;
        });
    }
}

