/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.sign.verify.container;

import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.ofdrw.core.signatures.SigType;
import org.ofdrw.sign.verify.SignedDataValidateContainer;
import org.ofdrw.sign.verify.exceptions.InvalidSignedValueException;

public class DigitalValidateContainer
implements SignedDataValidateContainer {
    public PublicKey pk;

    public DigitalValidateContainer(PublicKey pk) {
        if (pk == null) {
            throw new IllegalArgumentException("\u9a8c\u8bc1\u4f7f\u7528\u7684\u516c\u94a5\u53c2\u6570(pk)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.pk = pk;
    }

    public DigitalValidateContainer(Certificate certificate) {
        this(certificate.getPublicKey());
    }

    @Override
    public void validate(SigType type, String alg, byte[] tbsContent, byte[] signedValue) throws InvalidSignedValueException, GeneralSecurityException {
        if (type != SigType.Sign) {
            throw new IllegalArgumentException("\u7b7e\u540d\u7c7b\u578b(type)\u5fc5\u987b\u662f Sign\uff0c\u4e0d\u652f\u6301\u7535\u5b50\u5370\u7ae0\u9a8c\u8bc1");
        }
        Signature sg = Signature.getInstance(alg, (Provider)new BouncyCastleProvider());
        sg.initVerify(this.pk);
        sg.update(tbsContent);
        if (!sg.verify(signedValue)) {
            throw new InvalidSignedValueException("\u7b7e\u540d\u503c\u4e0d\u4e00\u81f4");
        }
    }
}

