/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script;

import java.beans.Transient;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.ssssssss.script.MagicScript;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.MagicScriptEngineFactory;
import org.ssssssss.script.ScriptClass;
import org.ssssssss.script.reflection.JavaReflection;

public class MagicScriptEngine
extends AbstractScriptEngine
implements ScriptEngine,
Compilable {
    private static final Map<String, Object> DEFAULT_IMPORTS = new ConcurrentHashMap<String, Object>();
    private static Map<String, ScriptClass> classMap = null;
    private final MagicScriptEngineFactory magicScriptEngineFactory;

    public MagicScriptEngine(MagicScriptEngineFactory magicScriptEngineFactory) {
        this.magicScriptEngineFactory = magicScriptEngineFactory;
    }

    public static void addScriptClass(Class<?> clazz) {
        if (classMap == null) {
            MagicScriptEngine.getScriptClassMap();
        }
        MagicScriptEngine.getScriptClass(clazz).forEach(scriptClass -> classMap.put(scriptClass.getClassName(), (ScriptClass)scriptClass));
    }

    public static synchronized Map<String, ScriptClass> getScriptClassMap() {
        if (classMap == null) {
            classMap = new HashMap<String, ScriptClass>();
            Arrays.asList(String.class, Object.class, Date.class, Integer.class, Double.class, Float.class, Long.class, List.class, Short.class, Byte.class, Boolean.class, BigDecimal.class).forEach(clazz -> MagicScriptEngine.getScriptClass(clazz).forEach(scriptClass -> classMap.put(scriptClass.getClassName(), (ScriptClass)scriptClass)));
        }
        return classMap;
    }

    public static List<ScriptClass.ScriptMethod> getFunctions() {
        return JavaReflection.getFunctions().stream().map(it -> new ScriptClass.ScriptMethod((Method)it.getExecutable())).collect(Collectors.toList());
    }

    public static Map<String, ScriptClass> getExtensionScriptClass() {
        Map<Class<?>, List<Class<?>>> extensionMap = JavaReflection.getExtensionMap();
        HashMap<String, ScriptClass> classMap = new HashMap<String, ScriptClass>();
        for (Map.Entry<Class<?>, List<Class<?>>> entry : extensionMap.entrySet()) {
            ScriptClass clazz = (ScriptClass)classMap.get(entry.getKey().getName());
            if (clazz == null) {
                clazz = new ScriptClass();
                classMap.put(entry.getKey().getName(), clazz);
            }
            for (Class<?> extensionClass : entry.getValue()) {
                for (ScriptClass.ScriptMethod method : MagicScriptEngine.getMethod(extensionClass)) {
                    clazz.addMethod(method);
                }
            }
        }
        return classMap;
    }

    public static ScriptClass getScriptClassFromClass(Class<?> clazz) {
        Class<?> superClass = clazz.getSuperclass();
        ScriptClass scriptClass = new ScriptClass();
        scriptClass.setClassName(clazz.getName());
        scriptClass.setSuperClass(superClass != null ? superClass.getName() : null);
        MagicScriptEngine.appendMethod(clazz, scriptClass);
        return scriptClass;
    }

    public static List<ScriptClass> getScriptClass(Class<?> clazz) {
        Class<?> superClass;
        ArrayList<ScriptClass> classList = new ArrayList<ScriptClass>();
        do {
            superClass = clazz.getSuperclass();
            ScriptClass scriptClass = new ScriptClass();
            scriptClass.setClassName(clazz.getName());
            scriptClass.setSuperClass(superClass != null ? superClass.getName() : null);
            if (clazz.isEnum()) {
                scriptClass.setEnums(clazz.getEnumConstants());
            } else {
                MagicScriptEngine.appendAttributes(clazz, scriptClass);
            }
            MagicScriptEngine.appendMethod(clazz, scriptClass);
            classList.add(scriptClass);
            Class<?>[] interfaces = clazz.getInterfaces();
            ArrayList<String> interfaceList = new ArrayList<String>();
            for (Class<?> interfaceClazz : interfaces) {
                classList.addAll(MagicScriptEngine.getScriptClass(interfaceClazz));
                interfaceList.add(interfaceClazz.getName());
            }
            scriptClass.setInterfaces(interfaceList);
            clazz = superClass;
        } while (superClass != null && superClass != Object.class && superClass != Class.class);
        return classList;
    }

    private static void appendMethod(Class<?> clazz, ScriptClass scriptClass) {
        MagicScriptEngine.getMethod(clazz).forEach(method -> {
            scriptClass.addMethod((ScriptClass.ScriptMethod)method);
            String methodName = method.getName();
            if (method.getParameters().isEmpty() && (methodName.startsWith("get") && methodName.length() > 3 || methodName.startsWith("is") && methodName.length() > 2)) {
                String attributeName = method.getName().substring(3);
                if (!"class".equalsIgnoreCase(attributeName = attributeName.substring(0, 1).toLowerCase() + attributeName.substring(1))) {
                    scriptClass.addAttribute(new ScriptClass.ScriptAttribute(method.getReturnType(), attributeName));
                }
            }
        });
    }

    public static Set<ScriptClass> getScriptClass(String className) {
        try {
            return new LinkedHashSet<ScriptClass>(MagicScriptEngine.getScriptClass(Class.forName(className)));
        }
        catch (ClassNotFoundException e) {
            return Collections.emptySet();
        }
    }

    private static List<ScriptClass.ScriptMethod> getMethod(Class<?> clazz) {
        ArrayList<ScriptClass.ScriptMethod> methods = new ArrayList<ScriptClass.ScriptMethod>();
        try {
            Method[] declaredMethods;
            for (Method declaredMethod : declaredMethods = clazz.getDeclaredMethods()) {
                if (Modifier.isVolatile(declaredMethod.getModifiers()) || !Modifier.isPublic(declaredMethod.getModifiers()) || declaredMethod.getAnnotation(Transient.class) != null || !Modifier.isPublic(declaredMethod.getModifiers())) continue;
                methods.add(new ScriptClass.ScriptMethod(declaredMethod));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return methods;
    }

    private static void appendAttributes(Class<?> clazz, ScriptClass target) {
        try {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!Modifier.isPublic(field.getModifiers()) || field.getAnnotation(Transient.class) != null) continue;
                target.addAttribute(new ScriptClass.ScriptAttribute(field.getType().getName(), field.getName()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addDefaultImport(String name, Object target) {
        DEFAULT_IMPORTS.put(name, target);
    }

    public static Map<String, Object> getDefaultImports() {
        return DEFAULT_IMPORTS;
    }

    public static Object execute(MagicScript magicScript, MagicScriptContext context) {
        SimpleScriptContext simpleScriptContext = new SimpleScriptContext();
        simpleScriptContext.setAttribute("ROOT", context, 100);
        return magicScript.eval(simpleScriptContext);
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        return this.compile(script).eval(context);
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        return this.compile(reader).eval(context);
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.magicScriptEngineFactory;
    }

    @Override
    public CompiledScript compile(String script) {
        return MagicScript.create(script, this);
    }

    @Override
    public CompiledScript compile(Reader script) {
        return this.compile(this.readString(script));
    }

    private String readString(Reader reader) {
        StringBuilder builder = new StringBuilder();
        char[] buf = new char[1024];
        try {
            int len;
            while ((len = reader.read(buf, 0, buf.length)) != -1) {
                builder.append(buf, 0, len);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return builder.toString();
    }
}

