/*
 * Decompiled with CFR 0.152.
 */
package org.tio.websocket.common;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.exception.AioDecodeException;
import org.tio.core.utils.ByteBufferUtils;
import org.tio.websocket.common.Opcode;
import org.tio.websocket.common.WsRequest;
import org.tio.websocket.common.WsSessionContext;

public class WsServerDecoder {
    private static Logger log = LoggerFactory.getLogger(WsServerDecoder.class);

    public static WsRequest decode(ByteBuffer buf, ChannelContext channelContext) throws AioDecodeException {
        boolean hasMask;
        int headLength;
        WsSessionContext imSessionContext = (WsSessionContext)channelContext.getAttribute();
        List<byte[]> lastParts = imSessionContext.getLastParts();
        int initPosition = buf.position();
        int readableLength = buf.limit() - initPosition;
        if (readableLength < (headLength = 2)) {
            return null;
        }
        byte first = buf.get();
        boolean fin = (first & 0x80) > 0;
        int rsv = (first & 0x70) >>> 4;
        byte opCodeByte = (byte)(first & 0xF);
        Opcode opcode = Opcode.valueOf(opCodeByte);
        if (opcode == Opcode.CLOSE) {
            // empty if block
        }
        if (!fin) {
            log.error("{} \u6682\u65f6\u4e0d\u652f\u6301fin\u4e3afalse\u7684\u8bf7\u6c42", (Object)channelContext);
            Tio.remove((ChannelContext)channelContext, (String)"\u6682\u65f6\u4e0d\u652f\u6301fin\u4e3afalse\u7684\u8bf7\u6c42");
            return null;
        }
        imSessionContext.setLastParts(null);
        byte second = buf.get();
        boolean bl = hasMask = (second & 0xFF) >> 7 == 1;
        if (hasMask) {
            headLength += 4;
        }
        int payloadLength = second & 0x7F;
        byte[] mask = null;
        if (payloadLength == 126) {
            if (readableLength < (headLength += 2)) {
                return null;
            }
            payloadLength = ByteBufferUtils.readUB2WithBigEdian((ByteBuffer)buf);
            log.info("{} payloadLengthFlag: 126\uff0cpayloadLength {}", (Object)channelContext, (Object)payloadLength);
        } else if (payloadLength == 127) {
            if (readableLength < (headLength += 8)) {
                return null;
            }
            payloadLength = (int)buf.getLong();
            log.info("{} payloadLengthFlag: 127\uff0cpayloadLength {}", (Object)channelContext, (Object)payloadLength);
        }
        if (payloadLength < 0 || payloadLength > 524288) {
            throw new AioDecodeException("body length(" + payloadLength + ") is not right");
        }
        if (readableLength < headLength + payloadLength) {
            return null;
        }
        if (hasMask) {
            mask = ByteBufferUtils.readBytes((ByteBuffer)buf, (int)4);
        }
        WsRequest websocketPacket = new WsRequest();
        websocketPacket.setWsEof(fin);
        websocketPacket.setWsHasMask(hasMask);
        websocketPacket.setWsMask(mask);
        websocketPacket.setWsOpcode(opcode);
        websocketPacket.setWsBodyLength(payloadLength);
        if (payloadLength == 0) {
            return websocketPacket;
        }
        byte[] array = ByteBufferUtils.readBytes((ByteBuffer)buf, (int)payloadLength);
        if (hasMask) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = (byte)(array[i] ^ mask[i % 4]);
            }
        }
        if (!fin) {
            log.error("payloadLength {}, lastParts size {}, array length {}", new Object[]{payloadLength, lastParts.size(), array.length});
            return websocketPacket;
        }
        int allLength = array.length;
        if (lastParts != null) {
            for (byte[] part : lastParts) {
                allLength += part.length;
            }
            byte[] allByte = new byte[allLength];
            int offset = 0;
            for (byte[] part : lastParts) {
                System.arraycopy(part, 0, allByte, offset, part.length);
                offset += part.length;
            }
            System.arraycopy(array, 0, allByte, offset, array.length);
            array = allByte;
        }
        websocketPacket.setBody(array);
        if (opcode != Opcode.BINARY) {
            try {
                String text = null;
                text = new String(array, "utf-8");
                websocketPacket.setWsBodyText(text);
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
        return websocketPacket;
    }

    public static enum Step {
        header,
        remain_header,
        data;

    }
}

