/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.xz.xz.index;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.vafer.jdeb.shaded.xz.xz.CorruptedInputException;
import org.vafer.jdeb.shaded.xz.xz.XZIOException;
import org.vafer.jdeb.shaded.xz.xz.check.Check;
import org.vafer.jdeb.shaded.xz.xz.check.SHA256;
import org.vafer.jdeb.shaded.xz.xz.common.DecoderUtil;
import org.vafer.jdeb.shaded.xz.xz.index.IndexBase;

public class IndexHash
extends IndexBase {
    private Check hash;

    public IndexHash() {
        super(new CorruptedInputException());
        try {
            this.hash = new SHA256();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.hash = new org.vafer.jdeb.shaded.xz.xz.check.CRC32();
        }
    }

    @Override
    public void add(long l, long l2) throws XZIOException {
        super.add(l, l2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.putLong(l);
        byteBuffer.putLong(l2);
        this.hash.update(byteBuffer.array());
    }

    public void validate(InputStream inputStream) throws IOException {
        CRC32 cRC32 = new CRC32();
        cRC32.update(0);
        CheckedInputStream checkedInputStream = new CheckedInputStream(inputStream, cRC32);
        long l = DecoderUtil.decodeVLI(checkedInputStream);
        if (l != this.recordCount) {
            throw new CorruptedInputException("XZ Block Header or the start of XZ Index is corrupt");
        }
        IndexHash indexHash = new IndexHash();
        for (long i = 0L; i < this.recordCount; ++i) {
            long l2 = DecoderUtil.decodeVLI(checkedInputStream);
            long l3 = DecoderUtil.decodeVLI(checkedInputStream);
            try {
                indexHash.add(l2, l3);
            }
            catch (XZIOException xZIOException) {
                throw new CorruptedInputException("XZ Index is corrupt");
            }
            if (indexHash.blocksSum <= this.blocksSum && indexHash.uncompressedSum <= this.uncompressedSum && indexHash.indexListSize <= this.indexListSize) continue;
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        if (indexHash.blocksSum != this.blocksSum || indexHash.uncompressedSum != this.uncompressedSum || indexHash.indexListSize != this.indexListSize || !Arrays.equals(indexHash.hash.finish(), this.hash.finish())) {
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        DataInputStream dataInputStream = new DataInputStream(checkedInputStream);
        for (int i = this.getIndexPaddingSize(); i > 0; --i) {
            if (dataInputStream.readUnsignedByte() == 0) continue;
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        long l4 = cRC32.getValue();
        for (int i = 0; i < 4; ++i) {
            if ((l4 >>> i * 8 & 0xFFL) == (long)dataInputStream.readUnsignedByte()) continue;
            throw new CorruptedInputException("XZ Index is corrupt");
        }
    }
}

