/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class CompressUtil {
    private static final Logger logger = Logger.getLogger(CompressUtil.class);

    public static String compress(String str) {
        if (str == null || str.length() <= 0) {
            return str;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPOutputStream gzip = new GZIPOutputStream(out);){
            gzip.write(str.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            logger.error((Object)("\u5b57\u7b26\u4e32\u538b\u7f29\u5931\u8d25str:{" + str + "}\uff0c\u9519\u8bef\u4fe1\u606f:{" + e.getMessage() + "}"));
            throw new RuntimeException("\u5b57\u7b26\u4e32\u538b\u7f29\u5931\u8d25");
        }
        return Base64.encodeBase64String((byte[])out.toByteArray());
    }

    public static String uncompress(String compressedStr) {
        String decompressed;
        if (compressedStr == null || compressedStr.length() <= 0) {
            return compressedStr;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPInputStream gzip = null;
        try {
            int offset;
            byte[] compressed = Base64.decodeBase64((String)compressedStr);
            ByteArrayInputStream in = new ByteArrayInputStream(compressed);
            gzip = new GZIPInputStream(in);
            byte[] buffer = new byte[1024];
            while ((offset = gzip.read(buffer)) != -1) {
                out.write(buffer, 0, offset);
            }
            decompressed = out.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            logger.error((Object)("\u5b57\u7b26\u4e32\u89e3\u538b\u5931\u8d25compressedStr:{" + compressedStr + "}\uff0c\u9519\u8bef\u4fe1\u606f:{" + e.getMessage() + "}"));
            throw new RuntimeException("\u5b57\u7b26\u4e32\u89e3\u538b\u5931\u8d25");
        }
        finally {
            if (gzip != null) {
                try {
                    gzip.close();
                }
                catch (IOException iOException) {}
            }
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        return decompressed;
    }
}

