/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.util.DateUtils;
import com.efuture.ocp.common.util.PrecisionUtils;
import com.efuture.ocp.common.util.StorageUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.StringUtils;

public class DataUtils {
    public static String nvl(String BeanVal, String ... DefaultVal) {
        if (StringUtils.isEmpty((Object)BeanVal)) {
            for (String val : DefaultVal) {
                if (StringUtils.isEmpty((Object)val)) continue;
                return val;
            }
            return null;
        }
        return BeanVal;
    }

    public static double nvl(double BeanVal, double ... DefaultVal) {
        if (StringUtils.isEmpty((Object)BeanVal) || BeanVal == -1.0) {
            for (double val : DefaultVal) {
                if (StringUtils.isEmpty((Object)val) || val == -1.0) continue;
                return val;
            }
            return 0.0;
        }
        return BeanVal;
    }

    public static int nvl(int BeanVal, int ... DefaultVal) {
        if (StringUtils.isEmpty((Object)BeanVal) || BeanVal == 0) {
            for (int val : DefaultVal) {
                if (StringUtils.isEmpty((Object)val) || val == 0) continue;
                return val;
            }
            return 0;
        }
        return BeanVal;
    }

    public static long nvl(long BeanVal, long ... DefaultVal) {
        if (StringUtils.isEmpty((Object)BeanVal) || BeanVal == 0L) {
            for (long val : DefaultVal) {
                if (StringUtils.isEmpty((Object)val) || val == 0L) continue;
                return val;
            }
            return 0L;
        }
        return BeanVal;
    }

    public static Object checkNull(Object obj, String colName) throws Exception {
        if (StringUtils.isEmpty((Object)obj)) {
            throw new Exception(colName.concat(" must provide!"));
        }
        if (obj instanceof JSONArray && ((JSONArray)obj).size() <= 0) {
            throw new Exception(colName.concat(" must contain content!"));
        }
        return obj;
    }

    public static Object checkValid(Object obj, String colName, String validVals) throws Exception {
        if (StringUtils.isEmpty((Object)obj)) {
            throw new Exception(colName.concat(" must provide!"));
        }
        if (StringUtils.isEmpty((Object)validVals)) {
            return obj;
        }
        if (">0".equals(validVals)) {
            if (PrecisionUtils.doubleCompare(Double.parseDouble(obj.toString()), 0.0, 4) <= 0) {
                throw new Exception(colName.concat(" is invalid, must be >0 !"));
            }
        } else if (">=0".equals(validVals)) {
            if (PrecisionUtils.doubleCompare(Double.parseDouble(obj.toString()), 0.0, 4) < 0) {
                throw new Exception(colName.concat(" is invalid, must be >=0 !"));
            }
        } else {
            List<String> vals = Arrays.asList(validVals.split(","));
            if (!vals.contains(obj)) {
                throw new Exception(colName.concat(" is invalid, must in [" + validVals + "], but input [" + obj.toString() + "]!"));
            }
        }
        return obj;
    }

    public static void setDefaultValue(Object obj, String defaultValue) throws Exception {
    }

    public static String rpad(String src, int len, char ch) {
        int diff = len - src.length();
        if (diff <= 0) {
            return src;
        }
        char[] charr = new char[len];
        System.arraycopy(src.toCharArray(), 0, charr, 0, src.length());
        for (int i = src.length(); i < len; ++i) {
            charr[i] = ch;
        }
        return new String(charr);
    }

    public static String lpad(String src, int len, char ch) {
        int diff = len - src.length();
        if (diff <= 0) {
            return src;
        }
        char[] charr = new char[len];
        System.arraycopy(src.toCharArray(), 0, charr, diff, src.length());
        for (int i = 0; i < diff; ++i) {
            charr[i] = ch;
        }
        return new String(charr);
    }

    public static String fill(char ch, int len) {
        char[] charr = new char[len];
        for (int i = 0; i < len; ++i) {
            charr[i] = ch;
        }
        return new String(charr);
    }

    public static JSONArray AddToArray(String key, JSONArray arr) {
        JSONArray result = new JSONArray();
        JSONObject jsonObj = new JSONObject();
        jsonObj.put(key, (Object)arr);
        result.add((Object)jsonObj);
        return result;
    }

    public static JSONArray AddToArray(Object obj) {
        JSONArray result = new JSONArray();
        result.add(obj);
        return result;
    }

    public static String Add_Days(JSONObject json, String key, int days) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (StringUtils.isEmpty((Object)json) || !json.containsKey((Object)key)) {
            return null;
        }
        try {
            return sdf.format(DateUtils.addDays((Date)sdf.parse(json.getString(key)), (int)days));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Map<String, Object> cloneMap(Map<String, Object> map) {
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            result.put(entry.getKey().toString(), entry.getValue());
        }
        return result;
    }

    public static String getJsonData(JSONObject param, String key, boolean checknull, String defaultVal) throws Exception {
        if (StringUtils.isEmpty((Object)param) || !param.containsKey((Object)key) || StringUtils.isEmpty((Object)param.get((Object)key))) {
            if (checknull) {
                throw new ServiceException("10000", "\u3010{0}\u3011 is Null", key);
            }
            return defaultVal;
        }
        return param.getString(key);
    }

    public static int getJsonData(JSONObject param, String key, boolean checknull, int defaultVal) throws Exception {
        if (StringUtils.isEmpty((Object)param) || !param.containsKey((Object)key) || StringUtils.isEmpty((Object)param.get((Object)key))) {
            if (checknull) {
                throw new ServiceException("10000", "\u3010{0}\u3011 is Null", key);
            }
            return defaultVal;
        }
        return param.getInteger(key);
    }

    public static long getJsonData(JSONObject param, String key, boolean checknull, long defaultVal) throws Exception {
        if (StringUtils.isEmpty((Object)param) || !param.containsKey((Object)key) || StringUtils.isEmpty((Object)param.get((Object)key))) {
            if (checknull) {
                throw new ServiceException("10000", "\u3010{0}\u3011 is Null", key);
            }
            return defaultVal;
        }
        return param.getLongValue(key);
    }

    public static double getJsonData(JSONObject param, String key, boolean checknull, double defaultVal) throws Exception {
        if (StringUtils.isEmpty((Object)param) || !param.containsKey((Object)key) || StringUtils.isEmpty((Object)param.get((Object)key))) {
            if (checknull) {
                throw new ServiceException("10000", "\u3010{0}\u3011 is Null", key);
            }
            return defaultVal;
        }
        return param.getDoubleValue(key);
    }

    public static JSONArray copyArray(JSONArray srcArray, Map<String, String> colMap) throws Exception {
        if (srcArray == null || srcArray.size() <= 0) {
            return new JSONArray();
        }
        JSONArray result = new JSONArray();
        for (int i = 0; i < srcArray.size(); ++i) {
            JSONObject row = new JSONObject();
            for (Map.Entry<String, String> col : colMap.entrySet()) {
                row.put(col.getKey(), (Object)DataUtils.getJsonData(srcArray.getJSONObject(i), col.getValue(), false, ""));
            }
            result.add((Object)row);
        }
        return result;
    }

    public static <T> T parseObject(JSONObject jsonparam, String key, Class<T> clazz) throws Exception {
        if (jsonparam == null || !jsonparam.containsKey((Object)key)) {
            return null;
        }
        return StorageUtils.parseBeanObject((JSONObject)jsonparam.get((Object)key), clazz);
    }

    public static JSONObject parseJSONObject(Object bean) throws Exception {
        if (bean == null) {
            return new JSONObject();
        }
        return (JSONObject)JSONObject.toJSON((Object)bean);
    }

    public static <T> List<T> getListByArray(Class<T> class1, String jArrayStr) {
        ArrayList<Object> list = new ArrayList<Object>();
        JSONArray jsonArray = JSONArray.parseArray((String)jArrayStr);
        if (jsonArray == null || jsonArray.isEmpty()) {
            return list;
        }
        for (Object object : jsonArray) {
            JSONObject jsonObject = (JSONObject)object;
            Object t = JSONObject.toJavaObject((JSON)jsonObject, class1);
            list.add(t);
        }
        return list;
    }

    public static JSONArray getJSONArrayByList(List<?> list) {
        JSONArray jsonArray = new JSONArray();
        if (list == null || list.isEmpty()) {
            return jsonArray;
        }
        for (Object object : list) {
            jsonArray.add(object);
        }
        return jsonArray;
    }

    public static JSONObject newJSONObject(String key, Object value) {
        JSONObject result = new JSONObject();
        if (StringUtils.isEmpty((Object)key) || value == null) {
            return result;
        }
        result.put(key, value);
        return result;
    }

    public static boolean parseBoolean(Object value) {
        String str;
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        return value instanceof String && ("1".equals(str = (String)value) || "true".equalsIgnoreCase(str) || "Y".equalsIgnoreCase(str));
    }

    public static boolean ObjectMatch(JSONObject src, JSONObject dst, String key) throws Exception {
        if (!src.containsKey((Object)key) && !dst.containsKey((Object)key)) {
            return true;
        }
        if (!src.containsKey((Object)key) || !dst.containsKey((Object)key)) {
            return false;
        }
        return src.get((Object)key).equals(dst.get((Object)key));
    }

    public static void copyData(JSONObject src, JSONObject dst, String key) throws Exception {
        DataUtils.copyData(src, dst, key, key);
    }

    public static void copyData(JSONObject src, JSONObject dst, String key, String dstKey) throws Exception {
        if (src.containsKey((Object)key) && !StringUtils.isEmpty((Object)src.get((Object)key))) {
            dst.put(dstKey, src.get((Object)key));
        }
    }

    public static String getStringPara(String srcStr, String seperator, int index, String defValue) {
        return DataUtils.nvl(DataUtils.getStringPara(srcStr, seperator, index), defValue);
    }

    public static String getStringPara(String srcStr, String seperator, int index) {
        if (srcStr == null) {
            return srcStr;
        }
        String[] srcList = srcStr.split(",");
        if (srcList != null && index <= srcList.length - 1) {
            return srcList[index];
        }
        return null;
    }
}

