/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.language;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class MessageUtils {
    private static MessageUtils instance = null;
    private ReloadableResourceBundleMessageSource handler = null;
    private static Properties springEnv = new Properties();
    protected static final ThreadLocal<Locale> threadLocales = new ThreadLocal();
    private static Locale defaultLocale = Locale.SIMPLIFIED_CHINESE;
    private static Locale failoverLocale = Locale.US;
    public static final String[] localeCodes = new String[]{"en_US", "zh_CN"};
    public static final String[] localeDescr = new String[]{"English (US)", "\u7b80\u4f53\u4e2d\u6587"};
    private static final String[] defaultProject = new String[]{"i18n/ocp-common", "i18n/ocp-boot", "i18n/ocp-job", "i18n/ocp-rocketmq", "i18n/ocp-taskcore", "i18n/ocp-taskflow"};
    public static final String CR;

    private MessageUtils() {
        this.init();
    }

    public static MessageUtils getInstance() {
        if (instance == null) {
            instance = new MessageUtils();
        }
        return instance;
    }

    private void init() {
        String locale;
        MessageUtils.loadSpringEnv();
        this.handler = new ReloadableResourceBundleMessageSource();
        this.handler.setCacheSeconds(Integer.parseInt(MessageUtils.getEnv("efuture.messages.cache-seconds", MessageUtils.getEnv("spring.messages.cache-seconds", "-1"))));
        this.handler.setDefaultEncoding(MessageUtils.getEnv("efuture.messages.encoding", MessageUtils.getEnv("spring.messages.encoding", "UTF-8")));
        String[] paths = MessageUtils.getBasenames(MessageUtils.getEnv("efuture.messages.basename", MessageUtils.getEnv("spring.messages.basename", "classpath:i18n/messages")));
        this.handler.setBasenames(paths);
        String codeAsDefault = MessageUtils.getEnv("efuture.messages.use-code-as-default-message", MessageUtils.getEnv("spring.messages.use-code-as-default-message", "1"));
        if ("true".equalsIgnoreCase(codeAsDefault) || "1".equalsIgnoreCase(codeAsDefault)) {
            this.handler.setUseCodeAsDefaultMessage(true);
        }
        if ((locale = MessageUtils.getEnv("efuture.messages.default-locale", MessageUtils.getEnv("spring.messages.default-locale", null))) != null) {
            defaultLocale = MessageUtils.createLocale(locale);
        }
        if ((locale = MessageUtils.getEnv("efuture.messages.failover-locale", MessageUtils.getEnv("spring.messages.failover-locale", null))) != null) {
            failoverLocale = MessageUtils.createLocale(locale);
        }
        MessageUtils.setLocale(defaultLocale);
    }

    public static synchronized Locale getLocale() {
        Locale rtn = threadLocales.get();
        if (rtn != null) {
            return rtn;
        }
        MessageUtils.setLocale(defaultLocale);
        return defaultLocale;
    }

    public static synchronized void setLocale(Locale newLocale) {
        threadLocales.set(newLocale);
    }

    protected static String getLocaleString(String locString) {
        if (locString != null && ((String)locString).length() == 5 && ((String)locString).charAt(2) == '_') {
            locString = ((String)locString).substring(0, 2).toLowerCase() + "_" + ((String)locString).substring(3).toUpperCase();
        }
        return locString;
    }

    public static Locale createLocale(String localeCode) {
        Locale resultLocale = null;
        if (localeCode != null) {
            StringTokenizer parser = new StringTokenizer(localeCode, "_");
            resultLocale = parser.countTokens() == 2 ? new Locale(parser.nextToken(), parser.nextToken()) : new Locale(localeCode);
        }
        return resultLocale;
    }

    private static String getEnv(String key, String defaultVal) {
        String val = System.getenv(key);
        if (!MessageUtils.isEmpty(val)) {
            return val;
        }
        val = System.getProperty(key);
        if (!MessageUtils.isEmpty(val)) {
            return val;
        }
        val = springEnv.getProperty(key);
        if (!MessageUtils.isEmpty(val)) {
            return val;
        }
        return defaultVal;
    }

    private static void loadSpringEnv() {
        ClassPathResource res3;
        ClassPathResource res2;
        String pro = System.getenv("spring.active.profile");
        String cfg = "/application";
        String sec = null;
        if (!MessageUtils.isEmpty(pro)) {
            sec = "/application-" + pro;
        } else {
            pro = System.getProperty("spring.active.profile");
            if (!MessageUtils.isEmpty(pro)) {
                sec = "/application-" + pro;
            }
        }
        Properties m1 = null;
        Properties m2 = null;
        try {
            res2 = new ClassPathResource(cfg + ".properties");
            m1 = PropertiesLoaderUtils.loadProperties((Resource)res2);
        }
        catch (Exception x) {
            try {
                res3 = new ClassPathResource(cfg + ".yml");
                m1 = PropertiesLoaderUtils.loadProperties((Resource)res3);
            }
            catch (Exception res3) {
                // empty catch block
            }
        }
        try {
            res2 = new ClassPathResource(sec + ".properties");
            m2 = PropertiesLoaderUtils.loadProperties((Resource)res2);
        }
        catch (Exception x) {
            try {
                res3 = new ClassPathResource(sec + ".yml");
                m2 = PropertiesLoaderUtils.loadProperties((Resource)res3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (m1 != null) {
            springEnv.putAll((Map<?, ?>)m1);
        }
        if (m2 != null) {
            springEnv.putAll((Map<?, ?>)m2);
        }
    }

    private static String[] split(String cfg) {
        if (cfg == null) {
            return null;
        }
        return cfg.split("\\,|\\|");
    }

    public static String[] getBasenames(String cfg) {
        String[] names = MessageUtils.split(cfg);
        ArrayList<String> patterns = new ArrayList<String>();
        if (names != null) {
            for (String path : names) {
                File fp;
                try {
                    URL url = new URL(path);
                    fp = new File(url.getFile());
                }
                catch (MalformedURLException ex) {
                    fp = new File(path);
                }
                MessageUtils.getPaths(path, fp, patterns);
            }
        }
        for (String p : defaultProject) {
            boolean isInc = false;
            for (String s : patterns) {
                if (s.indexOf(p) == -1) continue;
                isInc = true;
                break;
            }
            if (isInc) continue;
            patterns.add(p);
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    private static void getPaths(String src, File dir, List<String> paths) {
        Object prefix = src;
        if (!src.endsWith("\\") && !src.endsWith("/")) {
            prefix = (String)prefix + "/";
        }
        if (dir.isDirectory()) {
            File[] fps;
            for (File fp : fps = dir.listFiles()) {
                if (fp.isFile() && fp.canRead()) {
                    String fname = fp.getName();
                    int idx = fname.lastIndexOf(46);
                    if (idx != -1) {
                        fname = fname.substring(0, idx);
                    }
                    for (String lang : localeCodes) {
                        if (!fname.endsWith("_" + lang)) continue;
                        fname = fname.substring(0, fname.lastIndexOf("_" + lang));
                        break;
                    }
                    if (paths.contains((String)prefix + fname)) continue;
                    paths.add((String)prefix + fname);
                    continue;
                }
                if (!fp.isDirectory()) continue;
                MessageUtils.getPaths((String)prefix + fp.getName(), fp, paths);
            }
        } else {
            paths.add(src);
        }
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    protected ReloadableResourceBundleMessageSource getHandler() {
        return this.handler;
    }

    protected static ReloadableResourceBundleMessageSource getInstanceHandler() {
        return MessageUtils.getInstance().getHandler();
    }

    public static String getString(String key) {
        String string = null;
        try {
            string = MessageUtils.getInstanceHandler().getMessage(key, (Object[])new String[0], defaultLocale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string != null) {
            return string;
        }
        try {
            string = MessageUtils.getInstanceHandler().getMessage(key, (Object[])new String[0], failoverLocale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string != null) {
            return string;
        }
        return key;
    }

    public static String getString(String key, String ... parameters) {
        String string = null;
        try {
            string = MessageUtils.getInstanceHandler().getMessage(key, (Object[])parameters, defaultLocale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string != null) {
            return string;
        }
        try {
            string = MessageUtils.getInstanceHandler().getMessage(key, (Object[])parameters, failoverLocale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string != null) {
            return string;
        }
        return key;
    }

    public static String getString(String key, Object ... parameters) {
        Object[] strings = new String[parameters.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = parameters[i] != null ? parameters[i].toString() : "";
        }
        String string = null;
        try {
            string = MessageUtils.getInstanceHandler().getMessage(key, strings, defaultLocale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string != null) {
            return string;
        }
        try {
            string = MessageUtils.getInstanceHandler().getMessage(key, strings, failoverLocale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string != null) {
            return string;
        }
        return key;
    }

    public static final String getClassTrace(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        String string = stringWriter.toString();
        try {
            stringWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public static String getCustomTrace(Throwable aThrowable) {
        StringBuilder result = new StringBuilder();
        String errorMessage = aThrowable.toString();
        result.append(errorMessage);
        if (!errorMessage.contains(CR)) {
            result.append(CR);
        }
        for (StackTraceElement element : aThrowable.getStackTrace()) {
            result.append(element);
            result.append(CR);
        }
        return result.toString();
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = MessageUtils.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    static {
        MessageUtils.getInstance();
        CR = System.getProperty("line.separator");
    }
}

