/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.sysparam;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.sysparam.RestserviceParam;
import com.efuture.ocp.common.sysparam.SystemParam;
import com.efuture.ocp.common.util.EnviromentUtil;
import com.efuture.ocp.common.util.SpringBeanFactory;
import java.lang.reflect.Method;
import org.springframework.util.StringUtils;

public class SystemParamUtil {
    private static final String ENUM_CLASSPATH = "java.lang.Enum";

    public static JSONArray systemParamEnumList(Class<?> ... enumCls) {
        JSONArray resultArray = new JSONArray();
        for (int i = 0; i < enumCls.length; ++i) {
            Enum[] enums;
            Class<?> enumClass = enumCls[i];
            if (!ENUM_CLASSPATH.equals(enumClass.getSuperclass().getCanonicalName())) continue;
            for (Enum anEnum : enums = (Enum[])enumClass.getEnumConstants()) {
                SystemParam para = (SystemParam)((Object)anEnum);
                JSONObject json = new JSONObject();
                json.put("key", (Object)para.getKey());
                json.put("desc", (Object)para.getDesc());
                json.put("defaultVal", (Object)para.getDefaultVal());
                resultArray.add((Object)json);
            }
        }
        return resultArray;
    }

    public static JSONArray restServiceEnumList(Class<?> ... enumCls) {
        JSONArray resultArray = new JSONArray();
        for (int i = 0; i < enumCls.length; ++i) {
            Enum[] enums;
            Class<?> enumClass = enumCls[i];
            if (!ENUM_CLASSPATH.equals(enumClass.getSuperclass().getCanonicalName())) continue;
            for (Enum anEnum : enums = (Enum[])enumClass.getEnumConstants()) {
                RestserviceParam para = (RestserviceParam)((Object)anEnum);
                JSONObject json = new JSONObject();
                json.put("key", (Object)para.getKey());
                json.put("desc", (Object)para.getDesc());
                json.put("defaultUrl", (Object)para.getDefaultUrl());
                resultArray.add((Object)json);
            }
        }
        return resultArray;
    }

    public static JSONArray xxlJobEnumList() {
        JSONArray resultArray = new JSONArray();
        try {
            Class<?> clhandle = Class.forName("com.xxl.job.core.handler.annotation.JobHandler");
            Class<?> cl = Class.forName("com.xxljob.boot.IJobHandlerBase");
            String[] ss = SpringBeanFactory.getContext().getBeanNamesForType(cl);
            for (int i = 0; ss != null && i < ss.length; ++i) {
                Object objinst = SpringBeanFactory.getBean(ss[i], cl);
                JSONObject json = new JSONObject();
                String key = clhandle.getMethod("value", new Class[0]).invoke(clhandle.cast(objinst.getClass().getAnnotation(clhandle)), new Object[0]).toString();
                json.put("key", (Object)key);
                Method desc = cl.getMethod("jobDescribe", String.class);
                json.put("desc", desc.invoke(objinst, new Object[]{null}));
                Method param = cl.getMethod("jobParamExample", new Class[0]);
                json.put("param", param.invoke(objinst, new Object[0]));
                Method cron = cl.getMethod("jobCronSuggestion", new Class[0]);
                json.put("cron", cron.invoke(objinst, new Object[0]));
                json.put("bean", (Object)ss[i]);
                resultArray.add((Object)json);
            }
        }
        catch (Exception ex) {
            return null;
        }
        return resultArray;
    }

    public static String printSystemParamList(String bean) {
        StringBuilder sb = new StringBuilder();
        sb.append("<style>");
        sb.append("table{border:1px solid #cad9ea;text-align:center;cellspacing:0px;cellpadding:50px} ");
        sb.append("table th{border:1px solid #cad9ea;text-align:center;cellspacing:0px;cellpadding:50px} ");
        sb.append("table tr td{border:1px solid #cad9ea;text-align:center;padding:5px;cellpadding:50px;max-width:500px;word-break:break-all} ");
        sb.append(".title{position:absolute;text-align: right;text-align-last: right;}");
        sb.append(".value{padding-left: 100;}");
        sb.append("</style>");
        JSONObject json = SpringBeanFactory.getBean(bean, JSONObject.class);
        if (json != null) {
            for (String key : json.keySet()) {
                sb.append("<br><div class='title'>").append(key).append("</div></br>");
                sb.append("<TABLE>");
                boolean printHeader = false;
                JSONArray array = json.getJSONArray(key);
                for (int i = 0; array != null && i < array.size(); ++i) {
                    if (!printHeader) {
                        sb.append("<tr style='background-color: #CCE8EB;'>");
                        sb.append("<td rowspan=2>\u53c2\u6570KEY</td>");
                        sb.append("<td rowspan=2>\u63cf\u8ff0</td>");
                        sb.append("<td rowspan=2>\u7f3a\u7701\u503c</td>");
                        sb.append("<td rowspan=2>\u5907\u6ce8</td>");
                        sb.append("<td rowspan=2>\u5f53\u524d\u503c</td>");
                        sb.append("</tr><tr><tr/>");
                        printHeader = true;
                    } else {
                        sb.append("<tr>");
                    }
                    JSONObject item = array.getJSONObject(i);
                    sb.append("<td style='text-align:left'>" + item.getString("key") + "</td>");
                    sb.append("<td style='text-align:left'>" + item.getString("desc") + "</td>");
                    String def = item.getString("defaultVal");
                    sb.append("<td>" + def + "</td>");
                    String memo = item.getString("memo");
                    sb.append("<td style='text-align:left'>" + (StringUtils.isEmpty((Object)memo) ? "" : memo) + "</td>");
                    String val = EnviromentUtil.getProperty(item.getString("key"));
                    sb.append("<td>" + (StringUtils.isEmpty((Object)val) ? "" : val) + "</td>");
                    sb.append("</tr>");
                }
                sb.append("<TABLE>");
            }
        }
        return sb.toString();
    }

    public static String printRestServiceList(String bean) {
        StringBuilder sb = new StringBuilder();
        sb.append("<style>");
        sb.append("table{border:1px solid #cad9ea;text-align:center;cellspacing:0px;cellpadding:50px} ");
        sb.append("table th{border:1px solid #cad9ea;text-align:center;cellspacing:0px;cellpadding:50px} ");
        sb.append("table tr td{border:1px solid #cad9ea;text-align:center;padding:5px;cellpadding:50px;max-width:500px;word-break:break-all} ");
        sb.append(".title{position:absolute;text-align: right;text-align-last: right;}");
        sb.append(".value{padding-left: 100;}");
        sb.append("</style>");
        JSONObject json = SpringBeanFactory.getBean(bean, JSONObject.class);
        if (json != null) {
            for (String key : json.keySet()) {
                sb.append("<br><div class='title'>").append(key).append("</div></br>");
                sb.append("<TABLE>");
                boolean printHeader = false;
                JSONArray array = json.getJSONArray(key);
                for (int i = 0; array != null && i < array.size(); ++i) {
                    if (!printHeader) {
                        sb.append("<tr style='background-color: #CCE8EB;'>");
                        sb.append("<td rowspan=2>\u8f6c\u53d1KEY</td>");
                        sb.append("<td rowspan=2>\u63cf\u8ff0</td>");
                        sb.append("<td rowspan=2>\u793a\u4f8b</td>");
                        sb.append("<td rowspan=2>\u5f53\u524d\u503c</td>");
                        sb.append("</tr><tr><tr/>");
                        printHeader = true;
                    } else {
                        sb.append("<tr>");
                    }
                    JSONObject item = array.getJSONObject(i);
                    sb.append("<td style='text-align:left'>" + item.getString("key") + "</td>");
                    sb.append("<td style='text-align:left'>" + item.getString("desc") + "</td>");
                    String def = item.getString("defaultUrl");
                    sb.append("<td style='text-align:left'>" + def + "</td>");
                    String url = SystemParamUtil.queryServiceURI(item.getString("key"));
                    sb.append("<td style='text-align:left'>" + (StringUtils.isEmpty((Object)url) ? "" : url) + "</td>");
                    sb.append("</tr>");
                }
                sb.append("<TABLE>");
            }
        }
        return sb.toString();
    }

    protected static String queryServiceURI(String method) {
        Object servicePath = "";
        Object curservice = method;
        while (!StringUtils.isEmpty((Object)curservice)) {
            int n;
            String url = EnviromentUtil.getProperty((String)curservice);
            if (url != null && !url.equals("")) {
                servicePath = url;
                break;
            }
            if (((String)curservice).equals("*")) break;
            if (((String)curservice).endsWith(".*")) {
                curservice = ((String)curservice).substring(0, ((String)curservice).lastIndexOf("."));
            }
            if ((n = ((String)curservice).lastIndexOf(".")) > 0) {
                curservice = ((String)curservice).substring(0, n) + ".*";
                continue;
            }
            curservice = "*";
        }
        if (servicePath != null) {
            servicePath = ((String)servicePath).trim();
            if (!method.equals(curservice) && !"*".equals(curservice)) {
                servicePath = (String)curservice + " => " + (String)servicePath;
            }
        }
        return servicePath;
    }

    public static String printXxlJobList(String bean) {
        StringBuilder sb = new StringBuilder();
        sb.append("<style>");
        sb.append("table{border:1px solid #cad9ea;text-align:center;cellspacing:0px;cellpadding:50px} ");
        sb.append("table th{border:1px solid #cad9ea;text-align:center;cellspacing:0px;cellpadding:50px} ");
        sb.append("table tr td{border:1px solid #cad9ea;text-align:center;padding:5px;cellpadding:50px;max-width:500px;word-break:break-all} ");
        sb.append(".title{position:absolute;text-align: right;text-align-last: right;}");
        sb.append(".value{padding-left: 100;}");
        sb.append("</style>");
        JSONObject json = SpringBeanFactory.getBean(bean, JSONObject.class);
        if (json != null) {
            for (String key : json.keySet()) {
                sb.append("<br><div class='title'>").append(key).append("</div></br>");
                sb.append("<TABLE>");
                boolean printHeader = false;
                JSONArray array = json.getJSONArray(key);
                for (int i = 0; array != null && i < array.size(); ++i) {
                    if (!printHeader) {
                        sb.append("<tr style='background-color: #CCE8EB;'>");
                        sb.append("<td rowspan=2>JobHandle</td>");
                        sb.append("<td rowspan=2>\u63cf\u8ff0</td>");
                        sb.append("<td rowspan=2>\u4f20\u53c2\u793a\u4f8b</td>");
                        sb.append("<td rowspan=2>\u8c03\u5ea6\u5efa\u8bae</td>");
                        sb.append("<td rowspan=2>Bean\u7c7b\u540d</td>");
                        sb.append("<td rowspan=2>\u89c4\u8303\u547d\u540d</td>");
                        sb.append("</tr><tr><tr/>");
                        printHeader = true;
                    } else {
                        sb.append("<tr>");
                    }
                    JSONObject item = array.getJSONObject(i);
                    sb.append("<td style='text-align:left'>" + item.getString("key") + "</td>");
                    String desc = item.getString("desc");
                    sb.append("<td style='text-align:left'>" + (StringUtils.isEmpty((Object)desc) ? "" : desc) + "</td>");
                    String param = item.getString("param");
                    sb.append("<td style='text-align:left'>" + (StringUtils.isEmpty((Object)param) ? "" : param) + "</td>");
                    String cron = item.getString("cron");
                    sb.append("<td style='text-align:left'>" + (StringUtils.isEmpty((Object)cron) ? "" : cron) + "</td>");
                    sb.append("<td style='text-align:left'>" + item.getString("bean") + "</td>");
                    sb.append("<td style='text-align:center'>" + (item.getString("bean").equalsIgnoreCase(item.getString("key")) ? "" : "\u4e0d\u89c4\u8303") + "</td>");
                    sb.append("</tr>");
                }
                sb.append("<TABLE>");
            }
        }
        return sb.toString();
    }
}

