/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.cache;

import com.efuture.ocp.common.SerializeUtil.SerializeUtil;
import com.efuture.ocp.common.annotation.CallTime;
import com.efuture.ocp.common.cache.CacheUtils;
import com.efuture.ocp.common.cache.redis.ObjectBytesExchange;
import com.efuture.ocp.common.util.Utils;
import com.efuture.ocp.common.util.WebPathUtils;
import com.efuture.ocp.common.util.ZipUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.rubyeye.xmemcached.GetsResponse;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.params.SetParams;

public class CacheUtilsRediscached
extends CacheUtils
implements Serializable {
    private JedisPool jedispool;
    private String cfgFile = null;
    private int cachetime = -1;
    public Logger logger = Logger.getLogger(CacheUtilsRediscached.class);

    public CacheUtilsRediscached() {
        this(null);
    }

    public CacheUtilsRediscached(String config) {
        this(config, -1);
    }

    public CacheUtilsRediscached(String config, int cachetime) {
        this.cfgFile = config;
        this.cachetime = cachetime;
    }

    private Jedis getJedis() {
        if (this.jedispool == null) {
            try {
                this.jedispool = this.CreateJedisPool();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            return this.jedispool.getResource();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void returnJedis(Jedis jedis) {
        if (jedis != null) {
            try {
                jedis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    @CallTime(Service="OCP", KeyArgIndex=0)
    public String putData(String key, Object object, int timeout) {
        return this.putDataByElapsed(key, object, timeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String putDataByElapsed(String key, Object object, int timeout, List<String> elapsed) {
        String string;
        block13: {
            long start_time = System.currentTimeMillis();
            Jedis jedis = this.getJedis();
            if (elapsed != null) {
                String msg = String.format("redis\u8fde\u63a5A/I/W(%d/%d/%d)", this.jedispool.getNumActive(), this.jedispool.getNumIdle(), this.jedispool.getNumWaiters());
                start_time = this.addElapsed(elapsed, msg, start_time, System.currentTimeMillis());
            }
            try {
                if (timeout < 0) {
                    timeout = this.cachetime > 0 ? this.cachetime : 0;
                }
                byte[] obj = SerializeUtil.serialize(object);
                if (elapsed != null) {
                    String msg = String.format("redis\u5e8f\u5217\u5316(%d)", obj != null ? obj.length : 0);
                    start_time = this.addElapsed(elapsed, msg, start_time, System.currentTimeMillis());
                }
                if (this.config.getCompressSize() > 0 && obj != null && obj.length > this.config.getCompressSize()) {
                    long ziplen = obj.length;
                    obj = ZipUtils.zip(obj);
                    if (elapsed != null) {
                        String msg = String.format("zip\u524d\u540e(%d/%d)", ziplen, obj.length);
                        start_time = this.addElapsed(elapsed, msg, start_time, System.currentTimeMillis());
                    }
                }
                if (timeout > 0) {
                    jedis.setex(this.getKey(key).getBytes(), timeout, obj);
                } else {
                    jedis.set(this.getKey(key).getBytes(), obj);
                }
                if (elapsed != null) {
                    start_time = this.addElapsed(elapsed, "redis\u5199\u8017\u65f6", start_time, System.currentTimeMillis());
                }
                string = key;
                this.returnJedis(jedis);
                if (elapsed == null) break block13;
            }
            catch (Exception e) {
                String string2;
                block14: {
                    try {
                        e.printStackTrace();
                        string2 = null;
                        this.returnJedis(jedis);
                        if (elapsed == null) break block14;
                    }
                    catch (Throwable throwable) {
                        this.returnJedis(jedis);
                        if (elapsed != null) {
                            String msg = String.format("redis\u91ca\u653eA/I/W(%d/%d/%d)", this.jedispool.getNumActive(), this.jedispool.getNumIdle(), this.jedispool.getNumWaiters());
                            start_time = this.addElapsed(elapsed, msg, start_time, System.currentTimeMillis());
                        }
                        throw throwable;
                    }
                    String msg = String.format("redis\u91ca\u653eA/I/W(%d/%d/%d)", this.jedispool.getNumActive(), this.jedispool.getNumIdle(), this.jedispool.getNumWaiters());
                    start_time = this.addElapsed(elapsed, msg, start_time, System.currentTimeMillis());
                }
                return string2;
            }
            String msg = String.format("redis\u91ca\u653eA/I/W(%d/%d/%d)", this.jedispool.getNumActive(), this.jedispool.getNumIdle(), this.jedispool.getNumWaiters());
            start_time = this.addElapsed(elapsed, msg, start_time, System.currentTimeMillis());
        }
        return string;
    }

    @Override
    @CallTime(Service="OCP", KeyArgIndex=0)
    public Object getData(String key) {
        return this.getDataByElapsed(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getDataByElapsed(String key, List<String> elapsed) {
        long start_time = System.currentTimeMillis();
        Jedis jedis = this.getJedis();
        if (elapsed != null) {
            String msg = String.format("redis\u8fde\u63a5A/I/W(%d/%d/%d)", this.jedispool.getNumActive(), this.jedispool.getNumIdle(), this.jedispool.getNumWaiters());
            start_time = this.addElapsed(elapsed, msg, start_time, System.currentTimeMillis());
        }
        Object result = null;
        try {
            byte[] obj = jedis.get(this.getKey(key).getBytes());
            if (elapsed != null) {
                start_time = this.addElapsed(elapsed, "redis\u8bfb\u8017\u65f6", start_time, System.currentTimeMillis());
            }
            if (this.config.getCompressSize() > 0 && obj != null) {
                long ziplen = obj.length;
                obj = ZipUtils.unZip(obj);
                if (elapsed != null && (long)obj.length != ziplen) {
                    String msg = String.format("unzip\u524d\u540e(%d/%d)", ziplen, obj.length);
                    start_time = this.addElapsed(elapsed, msg, start_time, System.currentTimeMillis());
                }
            }
            result = SerializeUtil.unserialize(obj);
            if (elapsed != null) {
                String msg = String.format("redis\u53cd\u5e8f\u5217(%d)", obj != null ? obj.length : 0);
                start_time = this.addElapsed(elapsed, msg, start_time, System.currentTimeMillis());
            }
            this.returnJedis(jedis);
            if (elapsed == null) return result;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                this.returnJedis(jedis);
                if (elapsed == null) return result;
            }
            catch (Throwable throwable) {
                this.returnJedis(jedis);
                if (elapsed == null) throw throwable;
                String msg = String.format("redis\u91ca\u653eA/I/W(%d/%d/%d)", this.jedispool.getNumActive(), this.jedispool.getNumIdle(), this.jedispool.getNumWaiters());
                start_time = this.addElapsed(elapsed, msg, start_time, System.currentTimeMillis());
                throw throwable;
            }
            String msg = String.format("redis\u91ca\u653eA/I/W(%d/%d/%d)", this.jedispool.getNumActive(), this.jedispool.getNumIdle(), this.jedispool.getNumWaiters());
            start_time = this.addElapsed(elapsed, msg, start_time, System.currentTimeMillis());
            return result;
        }
        String msg = String.format("redis\u91ca\u653eA/I/W(%d/%d/%d)", this.jedispool.getNumActive(), this.jedispool.getNumIdle(), this.jedispool.getNumWaiters());
        start_time = this.addElapsed(elapsed, msg, start_time, System.currentTimeMillis());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteData(String key) {
        Jedis jedis = this.getJedis();
        try {
            jedis.del(this.getKey(key));
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.returnJedis(jedis);
        }
        return true;
    }

    private synchronized JedisPool CreateJedisPool() throws FileNotFoundException, IOException {
        if (this.jedispool != null) {
            return this.jedispool;
        }
        if (this.config != null) {
            this.logger.info((Object)"Redis client is creating with configuration.");
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setTestOnBorrow(this.config.isRedisTestOnBorrow());
            poolConfig.setMaxTotal(this.config.getRedisMaxActive());
            poolConfig.setMaxIdle(this.config.getRedisMaxIdle());
            poolConfig.setMinIdle(this.config.getRedisMinIdle());
            poolConfig.setMaxWaitMillis((long)this.config.getRedisMaxWait());
            this.jedispool = new JedisPool((GenericObjectPoolConfig)poolConfig, this.config.getRedisHost(), this.config.getRedisPort(), this.config.getRedisTimeout(), this.config.getRedisPassword(), this.config.getRedisDatabase());
            System.out.println("Redis server:" + this.config.getRedisHost() + ":" + this.config.getRedisPort() + ":" + this.config.getRedisPassword());
        } else {
            Object ini = null;
            String ini0 = null;
            if (StringUtils.isEmpty((Object)this.cfgFile)) {
                p = WebPathUtils.getWebRootClassPath();
                ini = p + "/redis.ini";
                ini0 = p + "/conf/redis.ini";
            } else if (this.cfgFile.startsWith("\\") || this.cfgFile.startsWith("/")) {
                p = WebPathUtils.getWebRootClassPath();
                ini = p + this.cfgFile;
                ini0 = p + "/conf" + this.cfgFile;
            } else {
                ini = this.cfgFile;
            }
            int maxActive = 100;
            int timeout = 5000;
            int maxIdle = 30;
            int minIdle = 10;
            boolean testOnBorrow = true;
            String host = "localhost";
            int port = 6379;
            int database = 0;
            int maxWait = 5000;
            File input = new File((String)ini);
            if (ini0 != null && !input.exists()) {
                input = new File(ini0);
            }
            this.logger.info((Object)("redis.ini path:" + (String)ini));
            if (input.exists()) {
                String sdatabase;
                String password_prop;
                String password;
                String smaxWait;
                String sport;
                String stestOnBorrow;
                String sminIdle;
                String smaxIdle;
                String stimeout;
                String smaxActive;
                FileInputStream is = new FileInputStream(input);
                Properties p = new Properties();
                p.load(is);
                ((InputStream)is).close();
                String sServer = Utils.getEnvValue(p.getProperty("redis.host"));
                if (sServer != null) {
                    host = sServer.trim();
                }
                if ((smaxActive = p.getProperty("redis.maxActive")) != null) {
                    maxActive = Integer.parseInt(smaxActive);
                }
                if ((stimeout = p.getProperty("redis.timeout")) != null) {
                    timeout = Integer.parseInt(stimeout);
                }
                if ((smaxIdle = p.getProperty("redis.maxIdle")) != null) {
                    maxIdle = Integer.parseInt(smaxIdle);
                }
                if ((sminIdle = p.getProperty("redis.minIdle")) != null) {
                    minIdle = Integer.parseInt(sminIdle);
                }
                if ((stestOnBorrow = p.getProperty("redis.testOnBorrow")) != null) {
                    boolean bl = testOnBorrow = stestOnBorrow == null || !stestOnBorrow.equalsIgnoreCase("false");
                }
                if ((sport = Utils.getEnvValue(p.getProperty("redis.port"))) != null) {
                    port = Integer.parseInt(sport);
                }
                if ((smaxWait = p.getProperty("redis.maxWait")) != null) {
                    maxWait = Integer.parseInt(smaxWait);
                }
                if ((password = Utils.getEnvValue(password_prop = p.getProperty("redis.password"))) != null) {
                    password = password.trim();
                }
                if ((sdatabase = Utils.getEnvValue(p.getProperty("redis.database"))) != null) {
                    database = Integer.parseInt(sdatabase);
                }
                this.logger.info((Object)("rediscached server:" + host + ":" + sport + "(" + sdatabase + ")"));
                JedisPoolConfig config = new JedisPoolConfig();
                config.setTestOnBorrow(true);
                config.setMaxTotal(maxActive);
                config.setMaxIdle(maxIdle);
                config.setMinIdle(minIdle);
                config.setMaxWaitMillis((long)maxWait);
                this.jedispool = new JedisPool((GenericObjectPoolConfig)config, host, port, timeout, password, database);
            } else {
                this.logger.warn((Object)"redis.ini not exits!");
                JedisPoolConfig config = new JedisPoolConfig();
                config.setTestOnBorrow(true);
                config.setMaxTotal(maxActive);
                config.setMaxIdle(maxIdle);
                config.setMinIdle(minIdle);
                config.setMaxWaitMillis((long)maxWait);
                this.jedispool = new JedisPool((GenericObjectPoolConfig)config, host, port, timeout);
                System.out.println("rediscached server-\u5730\u5740:localhost:" + port);
            }
        }
        return this.jedispool;
    }

    @Override
    public long getCasValue(String key) {
        return 0L;
    }

    @Override
    public GetsResponse getCasData(String key) {
        return null;
    }

    @Override
    public boolean putbyCas(String key, Object object, int timeout, long casvalue) {
        return false;
    }

    @Override
    public Object getCacheType() {
        return "single";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getBatchData(List<String> keys) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Jedis jedis = this.getJedis();
        try {
            HashMap<String, Response> resp_map = new HashMap<String, Response>();
            for (int i = 0; i < keys.size(); ++i) {
                String key = keys.get(i);
                if (!key.endsWith("*")) continue;
                keys.remove(i);
                --i;
                Set ks = jedis.keys(this.getKey(key));
                for (String k : ks) {
                    keys.add(k);
                }
            }
            Pipeline pipeline = jedis.pipelined();
            pipeline.multi();
            for (String key : keys) {
                resp_map.put(key, pipeline.get(this.getKey(key).getBytes()));
            }
            pipeline.exec();
            pipeline.sync();
            for (String key : keys) {
                byte[] obj = (byte[])((Response)resp_map.get(key)).get();
                if (this.config.getCompressSize() > 0 && obj != null) {
                    obj = ZipUtils.unZip(obj);
                }
                result.put(key, SerializeUtil.unserialize(obj));
            }
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.returnJedis(jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean AddData(String key, Object object, int timeout) {
        Jedis jedis = this.getJedis();
        try {
            SetParams params = new SetParams();
            params.nx().ex(timeout);
            if ("OK".equalsIgnoreCase(jedis.set(this.getKey(key), object.toString(), params))) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = true;
            return bl;
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getHashMap(int db, String key) {
        Jedis jedis = this.getJedis();
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            jedis.select(db);
            Map val = jedis.hgetAll(this.getKey(key));
            for (Map.Entry e : val.entrySet()) {
                result.put((String)e.getKey(), e.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.returnJedis(jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteBatch(String key) {
        HashMap result = new HashMap();
        Jedis jedis = this.getJedis();
        if (jedis == null) {
            return 0;
        }
        try {
            Set keys = jedis.keys(this.getKey(key).concat("*"));
            if (keys.size() <= 0) {
                int n = 0;
                return n;
            }
            Pipeline pipeline = jedis.pipelined();
            pipeline.multi();
            for (String str : keys) {
                pipeline.del(str.getBytes());
            }
            pipeline.exec();
            pipeline.sync();
            int n = keys.size();
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.returnJedis(jedis);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tryLock(String lockKey, String lockId, int timeout, int waitTime) {
        Jedis jedis = this.getJedis();
        if (jedis == null) {
            return false;
        }
        Long start = System.currentTimeMillis();
        try {
            while (true) {
                String script = "if (redis.call('exists', KEYS[1]) == 0) then    redis.call('hset', KEYS[1], ARGV[2], 1);    redis.call('pexpire', KEYS[1], ARGV[1]);    return 0; end; if (redis.call('hexists', KEYS[1], ARGV[2]) == 1) then    redis.call('hincrby', KEYS[1], ARGV[2], 1);    redis.call('pexpire', KEYS[1], ARGV[1]);    return 0; end; return redis.call('pttl', KEYS[1]);";
                Object result = jedis.eval(script, Collections.singletonList(lockKey), Arrays.asList(String.valueOf(timeout * 1000), lockId));
                if ("0".equals(result.toString())) {
                    boolean bl = true;
                    return bl;
                }
                long l = System.currentTimeMillis() - start;
                if (l >= (long)waitTime) {
                    boolean bl = false;
                    return bl;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int releaseLock(String lockKey, int timeout, String lockId) {
        Jedis jedis = this.getJedis();
        try {
            String script = "if (redis.call('hexists', KEYS[1], ARGV[2]) == 0) then    return 1; end; local counter = redis.call('hincrby', KEYS[1], ARGV[2], -1); if (counter > 0) then \tredis.call('pexpire', KEYS[1], ARGV[1]); \treturn 0; else \tredis.call('del', KEYS[1]); \treturn 1; end;return 1;";
            Object result = jedis.eval(script, Collections.singletonList(lockKey), Arrays.asList(String.valueOf(timeout * 1000), lockId));
            int n = Integer.parseInt(result.toString());
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.returnJedis(jedis);
        }
        return -1;
    }

    String encode(String str) {
        String ret = null;
        if (str != null) {
            try {
                ret = URLEncoder.encode(str, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error((Object)e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double incrByFloat(String key, double integer) {
        if (key == null) {
            return 0.0;
        }
        Jedis jedis = this.getJedis();
        try {
            double d = jedis.incrByFloat(key, integer);
            return d;
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.get(key);
            return string;
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock(String key, int seconds) {
        Jedis jedis = this.getJedis();
        try {
            boolean bl = jedis.setnx(this.encode(key), String.valueOf(System.currentTimeMillis() + (long)(seconds * 1000))) == 1L;
            return bl;
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long delObject(String key) {
        Jedis jedis = this.getJedis();
        try {
            long l = jedis.del(key);
            return l;
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public String setObject(String key, int seconds, Object obj) {
        Jedis jedis = this.getJedis();
        String ret = "";
        if (key == null || obj == null) {
            return null;
        }
        byte[] byteObj = ObjectBytesExchange.toByteArray(obj);
        if (null == byteObj) {
            return null;
        }
        ret = seconds <= 0 ? jedis.set(key.getBytes(), byteObj) : jedis.setex(key.getBytes(), seconds, byteObj);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rpush(String key, String value) {
        Jedis jedis = this.getJedis();
        try {
            long l = jedis.rpush(key, new String[]{value});
            return l;
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long lpush(String key, String ... value) {
        if (key == null) {
            return 0L;
        }
        Jedis jedis = this.getJedis();
        try {
            long l = jedis.lpush(key, value);
            return l;
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rpush(String key, String ... value) {
        if (key == null) {
            return 0L;
        }
        Jedis jedis = this.getJedis();
        try {
            long l = jedis.rpush(key, value);
            return l;
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long llen(String key) {
        if (key == null) {
            return 0L;
        }
        Jedis jedis = this.getJedis();
        try {
            long l = jedis.llen(key);
            return l;
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String rpop(String key) {
        if (key == null) {
            return null;
        }
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.rpop(key);
            return string;
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(byte[] key) {
        if (key == null) {
            return null;
        }
        Jedis jedis = this.getJedis();
        try {
            byte[] byArray = jedis.get(key);
            return byArray;
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public Object getObject(String key) {
        if (key == null) {
            return null;
        }
        byte[] ret = this.getBytes(key.getBytes());
        if (ret == null) {
            return null;
        }
        return ObjectBytesExchange.toObject(ret);
    }
}

