/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.task;

import cn.hutool.core.util.StrUtil;
import com.efuture.ocp.common.task.TaskEntity;
import java.util.Map;

public class TaskResult {
    int code;
    String msg;
    long start;
    long end;
    long elapsed;
    Map<String, Object> data;
    TaskEntity result;

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public TaskEntity getResult() {
        return this.result;
    }

    public void setResult(TaskEntity result) {
        this.result = result;
    }

    public TaskResult(int code, String msg, long start, long end, Map<String, Object> data) {
        this.code = code;
        this.msg = msg;
        this.start = start;
        this.end = end;
        this.data = data;
        if (start > 0L) {
            this.elapsed = (end - start) / 1000L;
        }
    }

    public boolean isSuccess() {
        return this.code == RTN_CODE.SUCCESS.code;
    }

    public static TaskResult error(String msgKey, String msg) {
        return TaskResult.complete(RTN_CODE.ERROR.getCode(), RTN_CODE.ERROR.getMsg(msgKey, msg), 0L, 0L, null);
    }

    public static TaskResult complete(int msgCode, String msg, long start, long end, Map<String, Object> data) {
        return new TaskResult(msgCode, msg, start, end, data);
    }

    public static TaskResult success(String msgKey, String msg, long start) {
        return TaskResult.complete(RTN_CODE.SUCCESS.getCode(), RTN_CODE.SUCCESS.getMsg(msgKey, msg), start, System.currentTimeMillis(), null);
    }

    static enum RTN_CODE {
        SUCCESS(0, "{}\u6267\u884c\u5b8c\u6210:{}"),
        ERROR(100, "\u4efb\u52a1:{},\u53d1\u751f\u672a\u77e5\u9519\u8bef:{}");

        int code;
        String msgTmp;

        private RTN_CODE(int code, String msgTmp) {
            this.code = code;
            this.msgTmp = msgTmp;
        }

        public int getCode() {
            return this.code;
        }

        public String getMsgTmp() {
            return this.msgTmp;
        }

        public String getMsg(String ... msg) {
            return StrUtil.format((CharSequence)this.msgTmp, (Object[])msg);
        }
    }
}

