/*
 * Decompiled with CFR 0.152.
 */
package com.product.annotation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.product.annotation.ReferQueryRepeatedValues;
import com.product.annotation.ReferService;
import com.product.annotation.ReferServiceRepeatedValues;
import com.product.component.BaseAnnotationService;
import com.product.model.RowMap;
import com.product.model.ServiceSession;
import com.product.service.OperationFlag;
import com.product.util.SpringContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplate;

public abstract class ReferServiceImpl<T extends RestTemplate>
extends BaseAnnotationService<ReferService> {
    protected static final SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();

    protected abstract T getTemplate();

    public ReferServiceImpl() {
        super(ReferService.class);
    }

    private void onAction(ServiceSession session, Object targetObject, ReferService referService, OperationFlag operFlag) throws Exception {
        JSONObject returnData;
        String returnCode;
        String tagTemplate = this.getTemplateUrl(referService);
        String tagTable = referService.table();
        String tagQuery = referService.query();
        String tagSet = referService.set();
        Integer connTimeout = TypeUtils.castToInt((Object)referService.connectTimeout());
        Integer readTimeout = TypeUtils.castToInt((Object)referService.readTimeout());
        String mediaType = referService.mediaType();
        OperationFlag[] tagFlags = referService.operationFlags();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        JSONObject paramsQuery = JSON.parseObject((String)tagQuery);
        JSONObject paramsSet = JSON.parseObject((String)tagSet);
        JSONObject paramsObject = new JSONObject();
        ArrayList<Object> fieldList = new ArrayList<Object>();
        Set keySet = paramsQuery.keySet();
        for (Object key : keySet) {
            String keyValue;
            fieldList.add(key);
            Object value = paramsQuery.get(key);
            if (value != null && value instanceof String && (keyValue = (String)value).startsWith("$")) {
                value = this.onValueGet(targetObject, keyValue.substring(1));
            }
            paramsObject.put((String)key, value);
        }
        HashMap<Object, String> keyMap = new HashMap<Object, String>();
        keySet = paramsSet.keySet();
        for (String key : keySet) {
            String fieldName = paramsSet.getString(key);
            keyMap.put(fieldName, key);
            fieldList.add(fieldName);
        }
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (String string : fieldList) {
            if (first) {
                buffer.append(string);
                first = false;
                continue;
            }
            buffer.append(",");
            buffer.append(string);
        }
        paramsObject.put("fields", (Object)buffer.toString());
        T template = this.getTemplate();
        if (connTimeout > 0) {
            requestFactory.setConnectTimeout(connTimeout.intValue());
        }
        if (readTimeout > 0) {
            requestFactory.setReadTimeout(readTimeout.intValue());
        }
        template.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        HttpHeaders httpHeaders = new HttpHeaders();
        if (!StringUtils.isEmpty((Object)mediaType)) {
            MediaType type = MediaType.parseMediaType((String)mediaType);
            httpHeaders.setContentType(type);
        }
        String remoteURL = "";
        String response = "";
        try {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put("session", JSON.toJSONString((Object)session));
            UriTemplate uriTemplate = new UriTemplate(tagTemplate);
            try {
                remoteURL = uriTemplate.expand(paramsMap).toString();
            }
            catch (Exception e) {
                System.out.println(String.format("RemoteURL: %1$s params:%2$s onFaiure for expand:%3$s", tagTemplate, JSON.toJSONString(paramsMap), e.getMessage()));
                throw e;
            }
            HttpEntity postEntity = new HttpEntity((Object)paramsObject.toJSONString(), (MultiValueMap)httpHeaders);
            response = (String)template.postForObject(remoteURL, (Object)postEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            String message = "\u8fdc\u7a0b\u8bf7\u6c42:---->" + e.getMessage();
            System.out.println(message);
            throw e;
        }
        JSONObject jsonResult = JSON.parseObject((String)response);
        if (jsonResult.containsKey((Object)"returncode") && jsonResult.containsKey((Object)"data") && "0".equals(returnCode = jsonResult.getString("returncode")) && (returnData = jsonResult.getJSONObject("data")).containsKey((Object)tagTable)) {
            JSONArray dataList = returnData.getJSONArray(tagTable);
            for (int i = 0; i < dataList.size(); ++i) {
                JSONObject resultRow = dataList.getJSONObject(i);
                keySet = resultRow.keySet();
                for (String key : keySet) {
                    if (keyMap.get(key) == null) continue;
                    this.onValueSet(targetObject, (String)keyMap.get(key), resultRow.get((Object)key));
                }
            }
        }
    }

    private String getTemplateUrl(ReferService referService) {
        String serviceUrl = "";
        try {
            String urlParam = referService.template();
            if (urlParam.indexOf("http") < 0) {
                Object obj = SpringContext.getBean((String)"environment");
                if (obj != null) {
                    ConfigurableEnvironment environment = (ConfigurableEnvironment)obj;
                    String metherdName = org.apache.commons.lang.StringUtils.substringAfter((String)urlParam, (String)"{");
                    metherdName = org.apache.commons.lang.StringUtils.substringBefore((String)metherdName, (String)"}");
                    serviceUrl = environment.getProperty(metherdName);
                }
            } else {
                serviceUrl = referService.template();
            }
        }
        catch (Exception e) {
            this.logger.error("getTemplateUrl error:{}", (Object)e.getMessage(), (Object)e);
        }
        return serviceUrl;
    }

    public void onAction(ServiceSession session, Object targetObject, OperationFlag operFlag, Class<?> beanClass) throws Exception {
        if (targetObject == null) {
            this.printStack(this.logger, "ReferServiceImpl", "\u8bf7\u6c42\u5199\u5165\u5bf9\u8c61\u7981\u6b62\u4e3a\u7a7a");
            return;
        }
        if (beanClass.isAnnotationPresent(ReferQueryRepeatedValues.class)) {
            ReferService[] referServices;
            ReferServiceRepeatedValues referServiceRepeate = beanClass.getAnnotation(ReferServiceRepeatedValues.class);
            for (ReferService referService : referServices = referServiceRepeate.value()) {
                this.onAction(session, targetObject, referService, operFlag);
            }
        } else if (beanClass.isAnnotationPresent(this.getAnnotationClass())) {
            ReferService referQuery = (ReferService)beanClass.getAnnotation(this.getAnnotationClass());
            if (targetObject instanceof List) {
                List dataList = (List)targetObject;
                for (RowMap dataRow : dataList) {
                    this.onAction(session, (Object)dataRow, referQuery, operFlag);
                }
            } else {
                this.onAction(session, targetObject, referQuery, operFlag);
            }
        }
    }
}

