/*
 * Decompiled with CFR 0.152.
 */
package com.product.annotation;

import com.alibaba.fastjson.JSONObject;
import com.product.annotation.AssertFalse;
import com.product.annotation.AssertTrue;
import com.product.annotation.DecimalMax;
import com.product.annotation.DecimalMin;
import com.product.annotation.DefaultValue;
import com.product.annotation.Digits;
import com.product.annotation.Email;
import com.product.annotation.IDCard;
import com.product.annotation.Length;
import com.product.annotation.Max;
import com.product.annotation.Min;
import com.product.annotation.NotEmpty;
import com.product.annotation.NotNull;
import com.product.annotation.Null;
import com.product.annotation.Phone;
import com.product.annotation.Size;
import com.product.annotation.VerificationBase;
import com.product.component.BaseAnnotationService;
import com.product.model.ServiceSession;
import com.product.service.OperationFlag;
import com.product.util.TypeUtils;
import com.shiji.core.util.I18nUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class VerificationImpl
extends BaseAnnotationService<VerificationBase> {
    private static final Logger logger = LoggerFactory.getLogger(VerificationImpl.class);
    private final String ruleEMail = "^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$";
    private final String rulePhone = "^(13[0-9]|14[5|7]|15[0|1|2|3|4|5|6|7|8|9]|18[0|1|2|3|5|6|7|8|9])\\d{8}$";
    private final String ruleIdCard = "(^\\d{15}$)|(^\\d{18}$)|(^\\d{17}(\\d|X|x)$)";
    private final Pattern pattern = Pattern.compile("^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$");
    private final Pattern patternPhone = Pattern.compile("^(13[0-9]|14[5|7]|15[0|1|2|3|4|5|6|7|8|9]|18[0|1|2|3|5|6|7|8|9])\\d{8}$");
    private final Pattern patternIdCard = Pattern.compile("(^\\d{15}$)|(^\\d{18}$)|(^\\d{17}(\\d|X|x)$)");

    public VerificationImpl() {
        super(VerificationBase.class);
    }

    public static void onExistValidator(JSONObject paramsObject, String fieldConfig) throws Exception {
        VerificationImpl.onExistValidator((Map<String, Object>)paramsObject, I18nUtil.getMessage((String)"99001"), fieldConfig);
    }

    public static void onExistValidator(Map<String, Object> paramsObject, String tagName, String fieldConfig) throws Exception {
        List<String> configList = Arrays.asList(fieldConfig.split(";"));
        for (String action : configList) {
            List<String> itemList = Arrays.asList(action.split("\\|"));
            boolean found = false;
            ArrayList<String> messageList = new ArrayList<String>();
            for (String orItem : itemList) {
                String fieldName;
                List<String> childList = Arrays.asList(orItem.split(":"));
                if (childList.size() > 1) {
                    fieldName = childList.get(0);
                    String fieldMsg = childList.get(1);
                    if (!paramsObject.containsKey(fieldName)) {
                        messageList.add(fieldMsg);
                        continue;
                    }
                    found = true;
                    continue;
                }
                if (childList.size() <= 0) continue;
                fieldName = childList.get(0);
                if (!paramsObject.containsKey(fieldName)) {
                    messageList.add(I18nUtil.getMessage((String)"90004", (Object[])new Object[]{tagName, fieldName}));
                    continue;
                }
                found = true;
            }
            if (found) continue;
            String messageCode = "90004";
            if (messageList.size() > 1) {
                messageCode = "90005";
            }
            throw new Exception(I18nUtil.getMessage((String)messageCode, (Object[])new Object[]{tagName, String.join((CharSequence)"\u3001", messageList)}));
        }
    }

    protected void onNull(ServiceSession session, Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        Null nullAnnotation = field.getAnnotation(Null.class);
        OperationFlag[] tagFlags = nullAnnotation.operationFlags();
        String tagMessage = nullAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        Object value = this.onValueGet(targetObject, field.getName());
        if (value != null) {
            if (StringUtils.isEmpty((Object)tagMessage)) {
                throw new Exception(I18nUtil.getMessage((String)"90003", (Object[])new Object[]{field.getName()}, (String)session.getLocale()));
            }
            throw new Exception(tagMessage);
        }
    }

    protected void onNotNull(ServiceSession session, Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        NotNull notNullAnnotation = field.getAnnotation(NotNull.class);
        OperationFlag[] tagFlags = notNullAnnotation.operationFlags();
        String tagMessage = notNullAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        Object value = this.onValueGet(targetObject, field.getName());
        if (value == null) {
            if (StringUtils.isEmpty((Object)tagMessage)) {
                throw new Exception(I18nUtil.getMessage((String)"90003", (Object[])new Object[]{field.getName()}, (String)session.getLocale()));
            }
            throw new Exception(tagMessage);
        }
    }

    protected void onAssertTrue(ServiceSession session, Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        AssertTrue assertAnnotation = field.getAnnotation(AssertTrue.class);
        OperationFlag[] tagFlags = assertAnnotation.operationFlags();
        String tagMessage = assertAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        Object value = this.onValueGet(targetObject, field.getName());
        boolean error = false;
        String message = I18nUtil.getMessage((String)"90007", (Object[])new Object[]{field.getName()}, (String)session.getLocale());
        if (value == null) {
            return;
        }
        if (value instanceof Boolean) {
            Boolean boolValue = (Boolean)value;
            if (!boolValue.equals(true)) {
                error = true;
            }
        } else {
            error = true;
        }
        if (error) {
            if (!StringUtils.isEmpty((Object)tagMessage)) {
                message = tagMessage;
            }
            throw new Exception(message);
        }
    }

    protected void onAssertFalse(ServiceSession session, Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        AssertFalse assertAnnotation = field.getAnnotation(AssertFalse.class);
        OperationFlag[] tagFlags = assertAnnotation.operationFlags();
        String tagMessage = assertAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        Object value = this.onValueGet(targetObject, field.getName());
        boolean error = false;
        String message = I18nUtil.getMessage((String)"90008", (Object[])new Object[]{field.getName()}, (String)session.getLocale());
        if (value == null) {
            return;
        }
        if (value instanceof Boolean) {
            Boolean boolValue = (Boolean)value;
            if (!boolValue.equals(false)) {
                error = true;
            }
        } else {
            error = true;
        }
        if (error) {
            if (!StringUtils.isEmpty((Object)tagMessage)) {
                message = tagMessage;
            }
            throw new Exception(message);
        }
    }

    protected void onDecimalMin(ServiceSession session, Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        BigDecimal valueTag;
        DecimalMin minAnnotation = field.getAnnotation(DecimalMin.class);
        OperationFlag[] tagFlags = minAnnotation.operationFlags();
        String tagMessage = minAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        String tagValue = minAnnotation.value();
        Object value = this.onValueGet(targetObject, field.getName());
        boolean error = false;
        String message = I18nUtil.getMessage((String)"90009", (Object[])new Object[]{field.getName(), tagValue}, (String)session.getLocale());
        if (value == null) {
            return;
        }
        BigDecimal valueSet = TypeUtils.castToBigDecimal((Object)value);
        if (valueSet.compareTo(valueTag = TypeUtils.castToBigDecimal((Object)tagValue)) < 0) {
            error = true;
        }
        if (error) {
            if (!StringUtils.isEmpty((Object)tagMessage)) {
                message = tagMessage;
            }
            throw new Exception(message);
        }
    }

    protected void onDecimalMax(ServiceSession session, Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        BigDecimal valueTag;
        DecimalMax maxAnnotation = field.getAnnotation(DecimalMax.class);
        OperationFlag[] tagFlags = maxAnnotation.operationFlags();
        String tagMessage = maxAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        String tagValue = maxAnnotation.value();
        Object value = this.onValueGet(targetObject, field.getName());
        boolean error = false;
        String message = I18nUtil.getMessage((String)"90010", (Object[])new Object[]{field.getName(), tagValue}, (String)session.getLocale());
        if (value == null) {
            return;
        }
        BigDecimal valueSet = TypeUtils.castToBigDecimal((Object)value);
        if (valueSet.compareTo(valueTag = TypeUtils.castToBigDecimal((Object)tagValue)) > 0) {
            error = true;
        }
        if (error) {
            if (!StringUtils.isEmpty((Object)tagMessage)) {
                message = tagMessage;
            }
            throw new Exception(message);
        }
    }

    protected void onDefaultValue(ServiceSession session, Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        DefaultValue defaultAnnotation = field.getAnnotation(DefaultValue.class);
        OperationFlag[] tagFlags = defaultAnnotation.operationFlags();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        String tagValue = defaultAnnotation.value();
        Object value = this.onValueGet(targetObject, field.getName());
        if (value == null) {
            Class<?> type = field.getType();
            if (type.equals(String.class)) {
                this.onValueSet(targetObject, field.getName(), TypeUtils.castToString((Object)tagValue));
            } else if (type.equals(Boolean.class)) {
                this.onValueSet(targetObject, field.getName(), TypeUtils.castToBoolean((Object)tagValue));
            } else if (type.equals(Integer.class)) {
                this.onValueSet(targetObject, field.getName(), TypeUtils.castToBigInteger((Object)tagValue));
            } else if (type.equals(Double.class)) {
                this.onValueSet(targetObject, field.getName(), TypeUtils.castToDouble((Object)tagValue));
            } else if (type.equals(Float.class)) {
                this.onValueSet(targetObject, field.getName(), TypeUtils.castToFloat((Object)tagValue));
            } else if (type.equals(BigDecimal.class)) {
                this.onValueSet(targetObject, field.getName(), TypeUtils.castToBigDecimal((Object)tagValue));
            } else if (type.equals(Date.class)) {
                this.onValueSet(targetObject, field.getName(), new Date());
            }
        }
    }

    protected void onMin(ServiceSession session, Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        Min minAnnotation = field.getAnnotation(Min.class);
        OperationFlag[] tagFlags = minAnnotation.operationFlags();
        String tagMessage = minAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        String tagValue = minAnnotation.value();
        Object value = this.onValueGet(targetObject, field.getName());
        boolean error = false;
        String message = I18nUtil.getMessage((String)"90009", (Object[])new Object[]{field.getName(), tagValue}, (String)session.getLocale());
        if (value == null) {
            return;
        }
        Double valueSet = TypeUtils.castToDouble((Object)value);
        Double valueTag = TypeUtils.castToDouble((Object)tagValue);
        if (valueSet < valueTag) {
            error = true;
        }
        if (error) {
            if (!StringUtils.isEmpty((Object)tagMessage)) {
                message = tagMessage;
            }
            throw new Exception(message);
        }
    }

    protected void onMax(ServiceSession session, Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        Max maxAnnotation = field.getAnnotation(Max.class);
        OperationFlag[] tagFlags = maxAnnotation.operationFlags();
        String tagMessage = maxAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        String tagValue = maxAnnotation.value();
        Object value = this.onValueGet(targetObject, field.getName());
        boolean error = false;
        String message = I18nUtil.getMessage((String)"90010", (Object[])new Object[]{field.getName(), tagValue}, (String)session.getLocale());
        if (value == null) {
            return;
        }
        Double valueSet = TypeUtils.castToDouble((Object)value);
        Double valueTag = TypeUtils.castToDouble((Object)tagValue);
        if (valueSet > valueTag) {
            error = true;
        }
        if (error) {
            if (!StringUtils.isEmpty((Object)tagMessage)) {
                message = tagMessage;
            }
            throw new Exception(message);
        }
    }

    protected void onSize(ServiceSession session, Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        Size sizeAnnotation = field.getAnnotation(Size.class);
        OperationFlag[] tagFlags = sizeAnnotation.operationFlags();
        String tagMessage = sizeAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        String maxValue = sizeAnnotation.max();
        String minValue = sizeAnnotation.min();
        Object value = this.onValueGet(targetObject, field.getName());
        boolean error = false;
        String message = I18nUtil.getMessage((String)"90011", (Object[])new Object[]{field.getName(), minValue, maxValue}, (String)session.getLocale());
        if (value == null) {
            return;
        }
        Double valueSet = TypeUtils.castToDouble((Object)value);
        Double valueMax = TypeUtils.castToDouble((Object)maxValue);
        Double valueMin = TypeUtils.castToDouble((Object)minValue);
        if (valueSet > valueMax) {
            error = true;
        } else if (valueSet < valueMin) {
            error = true;
        }
        if (error) {
            if (!StringUtils.isEmpty((Object)tagMessage)) {
                message = tagMessage;
            }
            throw new Exception(message);
        }
    }

    protected void onDigits(ServiceSession session, Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        Digits digitsAnnotation = field.getAnnotation(Digits.class);
        OperationFlag[] tagFlags = digitsAnnotation.operationFlags();
        String tagMessage = digitsAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        String fraction = digitsAnnotation.fraction();
        String integer = digitsAnnotation.integer();
        Object value = this.onValueGet(targetObject, field.getName());
        boolean error = false;
        String message = I18nUtil.getMessage((String)"90012", (Object[])new Object[]{field.getName()}, (String)session.getLocale());
        if (value == null) {
            return;
        }
        String valueSet = TypeUtils.castToString((Object)value);
        int integerDigit = valueSet.lastIndexOf(".");
        int fractionDigit = valueSet.length() - integerDigit;
        Integer fractionValue = TypeUtils.castToInt((Object)fraction);
        Integer integerValue = TypeUtils.castToInt((Object)integer);
        if (integerDigit > integerValue) {
            error = true;
        } else if (fractionDigit > fractionValue) {
            error = true;
        }
        if (error) {
            if (!StringUtils.isEmpty((Object)tagMessage)) {
                message = tagMessage;
            }
            throw new Exception(message);
        }
    }

    protected void onEMail(ServiceSession session, Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        Email emailAnnotation = field.getAnnotation(Email.class);
        OperationFlag[] tagFlags = emailAnnotation.operationFlags();
        String tagMessage = emailAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        Object value = this.onValueGet(targetObject, field.getName());
        boolean error = false;
        String message = I18nUtil.getMessage((String)"90013", (Object[])new Object[]{field.getName()}, (String)session.getLocale());
        if (value == null) {
            return;
        }
        String valueSet = TypeUtils.castToString((Object)value);
        Matcher matcher = this.pattern.matcher(valueSet);
        if (!matcher.find()) {
            error = true;
        }
        if (error) {
            if (!StringUtils.isEmpty((Object)tagMessage)) {
                message = tagMessage;
            }
            throw new Exception(message);
        }
    }

    protected void onLength(ServiceSession session, Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        Length lengthAnnotation = field.getAnnotation(Length.class);
        OperationFlag[] tagFlags = lengthAnnotation.operationFlags();
        String tagMessage = lengthAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        String maxValue = lengthAnnotation.max();
        String minValue = lengthAnnotation.min();
        Object value = this.onValueGet(targetObject, field.getName());
        boolean error = false;
        String message = I18nUtil.getMessage((String)"90014", (Object[])new Object[]{field.getName(), minValue, maxValue}, (String)session.getLocale());
        if (value == null) {
            return;
        }
        String valueSet = TypeUtils.castToString((Object)value);
        Integer valueMax = TypeUtils.castToInt((Object)maxValue);
        Integer valueMin = TypeUtils.castToInt((Object)minValue);
        if (valueSet.length() > valueMax) {
            error = true;
        } else if (valueSet.length() < valueMin) {
            error = true;
        }
        if (error) {
            if (!StringUtils.isEmpty((Object)tagMessage)) {
                message = tagMessage;
            }
            throw new Exception(message);
        }
    }

    protected void onNotEmpty(ServiceSession session, Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        Null nullAnnotation = field.getAnnotation(Null.class);
        OperationFlag[] tagFlags = nullAnnotation.operationFlags();
        String tagMessage = nullAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        Object value = this.onValueGet(targetObject, field.getName());
        if (value == null) {
            if (StringUtils.isEmpty((Object)tagMessage)) {
                throw new Exception(I18nUtil.getMessage((String)"90006", (Object[])new Object[]{field.getName()}, (String)session.getLocale()));
            }
            throw new Exception(tagMessage);
        }
    }

    protected void onIDCard(ServiceSession session, Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        IDCard idCardAnnotation = field.getAnnotation(IDCard.class);
        OperationFlag[] tagFlags = idCardAnnotation.operationFlags();
        String tagMessage = idCardAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        Object value = this.onValueGet(targetObject, field.getName());
        boolean error = false;
        String message = I18nUtil.getMessage((String)"90015", (Object[])new Object[]{field.getName()}, (String)session.getLocale());
        if (value == null) {
            return;
        }
        String valueSet = TypeUtils.castToString((Object)value);
        Matcher matcher = this.patternIdCard.matcher(valueSet);
        if (!matcher.matches()) {
            error = true;
        }
        if (error) {
            if (!StringUtils.isEmpty((Object)tagMessage)) {
                message = tagMessage;
            }
            throw new Exception(message);
        }
    }

    protected void onPhone(ServiceSession session, Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        Phone phoneAnnotation = field.getAnnotation(Phone.class);
        OperationFlag[] tagFlags = phoneAnnotation.operationFlags();
        String tagMessage = phoneAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        Object value = this.onValueGet(targetObject, field.getName());
        boolean error = false;
        String message = I18nUtil.getMessage((String)"90016", (Object[])new Object[]{field.getName()}, (String)session.getLocale());
        if (value == null) {
            return;
        }
        String valueSet = TypeUtils.castToString((Object)value);
        Matcher matcher = this.patternPhone.matcher(valueSet);
        if (!matcher.matches()) {
            error = true;
        }
        if (error) {
            if (!StringUtils.isEmpty((Object)tagMessage)) {
                message = tagMessage;
            }
            throw new Exception(message);
        }
    }

    public void onAction(ServiceSession session, Object targetObject, OperationFlag operFlag, Class<?> beanClass) throws Exception {
        Field[] fields;
        if (targetObject == null) {
            this.printStack(logger, "VerificationImpl", "\u8bf7\u6c42\u5199\u5165\u5bf9\u8c61\u7981\u6b62\u4e3a\u7a7a");
            return;
        }
        for (Field field : fields = beanClass.getDeclaredFields()) {
            if (field.isAnnotationPresent(Null.class)) {
                this.onNull(session, targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(NotNull.class)) {
                this.onNotNull(session, targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(AssertTrue.class)) {
                this.onAssertTrue(session, targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(AssertFalse.class)) {
                this.onAssertFalse(session, targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(Min.class)) {
                this.onMin(session, targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(Max.class)) {
                this.onMax(session, targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(DecimalMin.class)) {
                this.onDecimalMin(session, targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(DecimalMax.class)) {
                this.onDecimalMax(session, targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(Size.class)) {
                this.onSize(session, targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(Digits.class)) {
                this.onDigits(session, targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(Email.class)) {
                this.onEMail(session, targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(Length.class)) {
                this.onLength(session, targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(NotEmpty.class)) {
                this.onNotEmpty(session, targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(DefaultValue.class)) {
                this.onDefaultValue(session, targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(Phone.class)) {
                this.onPhone(session, targetObject, field, operFlag);
                continue;
            }
            if (!field.isAnnotationPresent(IDCard.class)) continue;
            this.onIDCard(session, targetObject, field, operFlag);
        }
    }
}

