/*
 * Decompiled with CFR 0.152.
 */
package com.product.component;

import com.alibaba.fastjson.JSON;
import com.product.component.AbstractData;
import com.product.component.IndexBlock;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataWriter
extends AbstractData {
    private static final Logger logger = LoggerFactory.getLogger(DataWriter.class);

    public DataWriter(String dataFilename, String indexFilename, Integer modSize, Integer batchSize, String ... fieldName) throws IOException {
        super(dataFilename, indexFilename, modSize, batchSize, true, fieldName);
    }

    public void onAppend(List<Map<String, Object>> dataList) throws IOException {
        int rowIndex = 0;
        for (Map<String, Object> dataMap : dataList) {
            Map<String, Map<String, Object>> rowMap;
            if (++rowIndex % 100 == 0) {
                logger.debug("Data Row Processing " + rowIndex);
            }
            String dataKey = this.getDataKey(dataMap);
            int hashCode = this.getHashCode(dataKey);
            if (this.getSortedMap().containsKey(hashCode)) {
                rowMap = (Map)this.getSortedMap().get(hashCode);
                if (!rowMap.containsKey(dataKey)) {
                    rowMap.put(dataKey, dataMap);
                }
                if (rowMap.size() <= this.getBatchSize() - 1) continue;
                String content = JSON.toJSONString(rowMap);
                this.onDataWriter(hashCode, content);
                rowMap.clear();
                continue;
            }
            rowMap = new HashMap<String, Map<String, Object>>();
            rowMap.put(dataKey, dataMap);
            this.getSortedMap().put(hashCode, rowMap);
        }
        Set<Integer> partSet = this.getSortedMap().keySet();
        logger.debug("Constant:" + partSet.size());
        for (Integer hashCode : partSet) {
            Map rowMap = (Map)this.getSortedMap().get(hashCode);
            if (rowMap.size() <= 0) continue;
            String content = JSON.toJSONString((Object)rowMap);
            this.onDataWriter(hashCode, content);
            rowMap.clear();
        }
    }

    public void onDataWriter(Integer hashCode, String content) throws IOException {
        IndexBlock index = new IndexBlock();
        index.setHashCode(hashCode);
        index.setStartIdx(this.getDataChannel().position());
        ByteBuffer contentBody = ByteBuffer.wrap(content.getBytes(this.CHARSET.name()));
        this.getDataChannel().write(contentBody);
        index.setEndIdx(this.getDataChannel().position());
        String contentIndex = JSON.toJSONString((Object)index);
        ByteBuffer bufferIndex = ByteBuffer.allocate(this.BLOCK_SIZE);
        bufferIndex.put(ByteBuffer.wrap(contentIndex.getBytes(this.CHARSET.name())));
        bufferIndex.clear();
        this.getIndexChannel().write(bufferIndex);
    }
}

