/*
 * Decompiled with CFR 0.152.
 */
package com.product.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.product.component.JDBCCompomentServiceImpl;
import com.product.exception.ServiceRuntimeException;
import com.product.model.AbstractEntityBean;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.SpringContext;
import com.product.util.TypeUtils;
import com.shiji.core.util.I18nUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class MasterSlaveComponentServiceImpl<X> {
    private static final Logger log = LoggerFactory.getLogger(MasterSlaveComponentServiceImpl.class);
    public String[] slaveServiceNames;
    public boolean subInsertIsBatch = false;
    protected final Class<X> masterClass = GenericTypeResolver.resolveTypeArgument(this.getClass(), MasterSlaveComponentServiceImpl.class);
    public Class masterBean = GenericTypeResolver.resolveTypeArgument(this.masterClass, JDBCCompomentServiceImpl.class);

    public String[] getSlaveServiceNames() {
        return this.slaveServiceNames;
    }

    public void initSubInsertIsBatch() {
        this.setSubInsertIsBatch(false);
    }

    public MasterSlaveComponentServiceImpl(String[] slaveServiceNames) {
        this.slaveServiceNames = slaveServiceNames;
        this.initSubInsertIsBatch();
    }

    public Boolean getSubInsertIsBatch() {
        return this.subInsertIsBatch;
    }

    public void setSubInsertIsBatch(Boolean subInsertIsBatch) {
        this.subInsertIsBatch = subInsertIsBatch;
    }

    public String getCollectionName() {
        String collectionName = null;
        try {
            collectionName = this.getCollectionName(this.masterClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return collectionName;
    }

    public String getKeyfieldName() {
        try {
            Method masterKeyMethod = this.masterClass.getMethod("getKeyfieldName", new Class[0]);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterKeyMethod.invoke(masterServiceObj, new Object[0]);
            return (String)data;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10029"));
        }
    }

    public String getKeyfieldName(Class<?> cl) {
        try {
            Method keyMethod = cl.getMethod("getKeyfieldName", new Class[0]);
            Object serviceObj = SpringContext.getBean(cl, (Object[])new Object[0]);
            Object data = keyMethod.invoke(serviceObj, new Object[0]);
            return (String)data;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10029"));
        }
    }

    public FMybatisTemplate getTemplate() {
        try {
            Method masterTemplateMethod = this.masterClass.getMethod("getTemplate", new Class[0]);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterTemplateMethod.invoke(masterServiceObj, new Object[0]);
            return (FMybatisTemplate)data;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10030"));
        }
    }

    public String getBusinessIdentify() {
        return null;
    }

    public String getModelFlag(JSONObject dataRow) {
        if (dataRow.containsKey((Object)"_flag") && !StringUtils.isEmpty((Object)dataRow.get((Object)"_flag"))) {
            return dataRow.getString("_flag");
        }
        if (dataRow.containsKey((Object)"__flag") && !StringUtils.isEmpty((Object)dataRow.get((Object)"__flag"))) {
            return dataRow.getString("__flag");
        }
        return "#";
    }

    public Class<?> getServiceBean(String serviceName) throws Exception {
        Class<?> c = Class.forName(this.masterClass.getPackage().getName() + "." + serviceName);
        return c;
    }

    public String getCollectionName(Class<?> Clazz) throws Exception {
        Method method = Clazz.getMethod("getCollectionName", new Class[0]);
        Object obj = SpringContext.getBean(Clazz, (Object[])new Object[0]);
        String collectionName = (String)method.invoke(obj, new Object[0]);
        return collectionName;
    }

    protected Field getMasterSlaveField(Class<?> cl) {
        return this.getModelField(cl, "MASTER_SLAVE_KEY");
    }

    protected String getOrderField(Class<?> cl) {
        try {
            Field fld = this.getModelField(cl, "ORDER_FIELD");
            return (String)fld.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getOrderDirection(Class<?> cl) {
        try {
            Field fld = this.getModelField(cl, "ORDER_DIRECTION");
            return (String)fld.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Field getModelField(Class<?> cl, String fieldName) {
        return AbstractEntityBean.fetchDeclaredField(cl, (String)fieldName);
    }

    protected String[] getMasterSlaveFields(Class<?> cl) throws Exception {
        Field fld = this.getMasterSlaveField(cl);
        return (String[])fld.get(null);
    }

    public static Object getFieldValue(Class clazz, Object bean, String col) throws Exception {
        PropertyDescriptor pd = new PropertyDescriptor(col, clazz);
        Method getMethod = pd.getReadMethod();
        Object o1 = getMethod.invoke(bean, new Object[0]);
        return o1;
    }

    public static void setFieldValue(Class clazz, Object bean, String col, Object object) throws Exception {
        PropertyDescriptor pd = new PropertyDescriptor(col, clazz);
        Method getMethod = pd.getWriteMethod();
        getMethod.invoke(bean, object);
    }

    protected Map<String, Class<?>> getSlaveBean(Class<?> masterClazz) throws Exception {
        Field[] fields;
        List<Class> classes = this.getSlaveBeans();
        HashMap map = new HashMap();
        for (Field field : fields = masterClazz.getDeclaredFields()) {
            Type type = field.getGenericType();
            if (type instanceof ParameterizedType) {
                String[] slavekey;
                Class genericType;
                Field fld;
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments.length <= 0 || !(actualTypeArguments[0] instanceof Class) || (fld = this.getMasterSlaveField(genericType = (Class)actualTypeArguments[0])) == null || StringUtils.isEmpty((Object)(slavekey = (String[])fld.get(null)))) continue;
                map.put(field.getName(), genericType);
                continue;
            }
            if (!classes.contains(type)) continue;
            map.put(field.getName(), (Class)type);
        }
        return map;
    }

    public List<Class> getSlaveBeans() throws Exception {
        ArrayList<Class> list = new ArrayList<Class>();
        for (String slaveService : this.slaveServiceNames) {
            Class<?> slaveClass = this.getServiceBean(slaveService);
            Class slaveBean = GenericTypeResolver.resolveTypeArgument(slaveClass, JDBCCompomentServiceImpl.class);
            list.add(slaveBean);
        }
        return list;
    }

    public <T> List<T> dataQuery(Query query) {
        return this.dataQuery(SpringContext.getSession(), query);
    }

    public <T> List<T> dataQuery(ServiceSession session, Query query) {
        try {
            Method masterKeyMethod = this.masterClass.getMethod("dataQuery", ServiceSession.class, Query.class, String.class, Class.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterKeyMethod.invoke(masterServiceObj, session, query, this.getCollectionName(), this.masterBean);
            return (List)data;
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"50024", (Object[])new Object[]{e.getMessage()}, (String)session.getLocale()));
        }
    }

    public <T> List<T> dataQuery(JSONObject paramsObject) {
        return this.dataQuery(SpringContext.getSession(), paramsObject);
    }

    public <T> List<T> dataQuery(ServiceSession session, JSONObject paramsObject) {
        return this.dataQuery(session, paramsObject, this.getCollectionName(), this.masterBean);
    }

    public <T> List<T> dataQuery(JSONObject paramsObject, Class<T> classzz) {
        return this.dataQuery(SpringContext.getSession(), paramsObject, classzz);
    }

    public <T> List<T> dataQuery(ServiceSession session, JSONObject paramsObject, Class<T> classzz) {
        return this.dataQuery(session, paramsObject, this.getCollectionName(), classzz);
    }

    public <T> List<T> dataQuery(JSONObject paramsObject, String collectionName, Class<T> classzz) {
        return this.dataQuery(SpringContext.getSession(), paramsObject, collectionName, classzz);
    }

    public <T> List<T> dataQuery(ServiceSession session, JSONObject paramsObject, String collectionName, Class<T> classzz) {
        try {
            Method masterKeyMethod = this.masterClass.getMethod("dataQuery", ServiceSession.class, JSONObject.class, String.class, Class.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterKeyMethod.invoke(masterServiceObj, session, paramsObject, collectionName, classzz);
            return (List)data;
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"50024", (Object[])new Object[]{e.getMessage()}, (String)session.getLocale()));
        }
    }

    public ServiceResponse onQuery(JSONObject paramsObject) {
        return this.onQuery(SpringContext.getSession(), paramsObject);
    }

    public ServiceResponse onQuery(ServiceSession session, JSONObject paramsObject) {
        try {
            Method masterQueryMethod = this.masterClass.getMethod("onQuery", ServiceSession.class, JSONObject.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterQueryMethod.invoke(masterServiceObj, session, paramsObject);
            return (ServiceResponse)data;
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public ServiceResponse view(JSONObject paramsObject) {
        return this.view(SpringContext.getSession(), paramsObject);
    }

    public ServiceResponse view(ServiceSession session, JSONObject paramsObject) {
        JSONObject respdata = new JSONObject();
        try {
            respdata.put(this.getCollectionName(this.masterClass), this.viewWithBean(session, paramsObject));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10031", (Object[])new Object[]{e.getMessage()}, (String)session.getLocale()));
        }
        return ServiceResponse.buildSuccess((Object)respdata);
    }

    public <T> T viewWithBean(Long id) throws Exception {
        return this.viewWithBean(SpringContext.getSession(), id);
    }

    public <T> T viewWithBean(ServiceSession session, Long id) throws Exception {
        JSONObject jsonParam = new JSONObject();
        jsonParam.put(this.getKeyfieldName(), (Object)id);
        return this.viewWithBean(session, jsonParam);
    }

    public <T> T viewWithBean(JSONObject paramsObject) throws Exception {
        return this.viewWithBean(SpringContext.getSession(), paramsObject);
    }

    public <T> T viewWithBean(ServiceSession session, JSONObject paramsObject) throws Exception {
        Method masterQueryMethod = this.masterClass.getMethod("dataQueryFirst", ServiceSession.class, JSONObject.class);
        Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
        Object data = masterQueryMethod.invoke(masterServiceObj, session, paramsObject);
        if (!StringUtils.isEmpty((Object)data)) {
            this.getSlaves(session, data);
        }
        return (T)TypeUtils.castToJavaBean((Object)data, (Class)this.masterBean);
    }

    public void getSlaves(ServiceSession session, Object data) throws Exception {
        String[] masterSlaveFields = null;
        try {
            masterSlaveFields = this.getMasterSlaveFields(this.masterBean);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4e3b\u8868\u672a\u914d\u7f6e\u4e3b\u4ece\u5173\u8054\uff0c\u6216\u8005\u914d\u7f6e\u9519\u8bef");
        }
        if (!StringUtils.isEmpty((Object)masterSlaveFields)) {
            Map<String, Class<?>> flds = this.getSlaveBean(this.masterBean);
            for (String slaveService : this.slaveServiceNames) {
                String orderdir;
                Class<?> slaveClass = this.getServiceBean(slaveService);
                String slaveCollectionName = this.getCollectionName(slaveClass);
                Class clazz = GenericTypeResolver.resolveTypeArgument(slaveClass, JDBCCompomentServiceImpl.class);
                if (StringUtils.isEmpty((Object)clazz)) continue;
                String[] masterSlaveFields_slave = null;
                try {
                    masterSlaveFields_slave = this.getMasterSlaveFields(clazz);
                }
                catch (Exception e) {
                    log.error("\u4ece\u8868" + slaveCollectionName + "\u672a\u914d\u7f6e\u4e3b\u4ece\u5173\u8054\uff0c\u6216\u8005\u914d\u7f6e\u9519\u8bef", (Throwable)e);
                }
                if (StringUtils.isEmpty((Object)masterSlaveFields_slave)) continue;
                JSONObject slaveparam = new JSONObject();
                for (int i = 0; i < masterSlaveFields_slave.length; ++i) {
                    String field = masterSlaveFields_slave[i];
                    slaveparam.put(field, MasterSlaveComponentServiceImpl.getFieldValue(this.masterBean, data, masterSlaveFields[i]));
                }
                String orderfields = this.getOrderField(clazz);
                if (!StringUtils.isEmpty((Object)orderfields)) {
                    slaveparam.put("order_field", (Object)orderfields);
                }
                if (!StringUtils.isEmpty((Object)(orderdir = this.getOrderDirection(clazz)))) {
                    slaveparam.put("order_direction", (Object)orderdir);
                }
                slaveparam.put("page_no", (Object)1);
                slaveparam.put("page_size", (Object)999999);
                Method slaveQueryMethod = slaveClass.getMethod("dataQuery", ServiceSession.class, JSONObject.class);
                Object slaveServiceObj = SpringContext.getBean(slaveClass, (Object[])new Object[0]);
                Object list = slaveQueryMethod.invoke(slaveServiceObj, session, slaveparam);
                Optional<String> key = flds.entrySet().stream().filter(kvEntry -> Objects.equals(kvEntry.getValue(), clazz)).map(Map.Entry::getKey).findFirst();
                Field field = AbstractEntityBean.fetchDeclaredField((Class)this.masterBean, (String)key.get());
                Type type = field.getGenericType();
                if (type instanceof ParameterizedType) {
                    MasterSlaveComponentServiceImpl.setFieldValue(this.masterBean, data, key.get(), list);
                    continue;
                }
                List tmp = (List)list;
                if (StringUtils.isEmpty((Object)list) || tmp.size() <= 0) continue;
                MasterSlaveComponentServiceImpl.setFieldValue(this.masterBean, data, key.get(), tmp.get(0));
            }
        }
    }

    public <T> T dataQueryFirst(Query query) {
        return this.dataQueryFirst(SpringContext.getSession(), query);
    }

    public <T> T dataQueryFirst(ServiceSession session, Query query) {
        try {
            Method masterKeyMethod = this.masterClass.getMethod("dataQueryFirst", ServiceSession.class, Query.class, String.class, Class.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterKeyMethod.invoke(masterServiceObj, session, query, this.getCollectionName(), this.masterBean);
            return (T)TypeUtils.castToJavaBean((Object)data, (Class)this.masterBean);
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"50024", (Object[])new Object[]{e.getMessage()}, (String)session.getLocale()));
        }
    }

    public <T> T dataQueryFirst(JSONObject paramsObject) {
        return this.dataQueryFirst(SpringContext.getSession(), paramsObject);
    }

    public <T> T dataQueryFirst(ServiceSession session, JSONObject paramsObject) {
        return this.dataQueryFirst(session, paramsObject, this.getCollectionName(), this.masterBean);
    }

    public <T> T dataQueryFirst(JSONObject paramsObject, Class<T> classzz) {
        return this.dataQueryFirst(SpringContext.getSession(), paramsObject, classzz);
    }

    public <T> T dataQueryFirst(ServiceSession session, JSONObject paramsObject, Class<T> classzz) {
        return this.dataQueryFirst(session, paramsObject, this.getCollectionName(), classzz);
    }

    public <T> T dataQueryFirst(JSONObject paramsObject, String collectionName, Class<T> classzz) {
        return this.dataQueryFirst(SpringContext.getSession(), paramsObject, collectionName, classzz);
    }

    public <T> T dataQueryFirst(ServiceSession session, JSONObject paramsObject, String collectionName, Class<T> classzz) {
        try {
            Method masterKeyMethod = this.masterClass.getMethod("dataQueryFirst", ServiceSession.class, JSONObject.class, String.class, Class.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterKeyMethod.invoke(masterServiceObj, session, paramsObject, collectionName, classzz);
            return (T)TypeUtils.castToJavaBean((Object)data, classzz);
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"50024", (Object[])new Object[]{e.getMessage()}, (String)session.getLocale()));
        }
    }

    public <T> T dataQueryById(Long id) {
        try {
            return this.viewWithBean(id);
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"50024", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public void onBeforeInsert(ServiceSession session, JSONObject paramsObject) {
    }

    public void onAfterInsert(ServiceSession session, JSONObject paramsObject) {
    }

    public ServiceResponse onInsert(JSONObject paramsObject) {
        return this.onInsert(SpringContext.getSession(), paramsObject);
    }

    public <T> ServiceResponse onInsert(ServiceSession session, T bean) {
        JSONObject jsonparam = TypeUtils.toJSONObj(bean, (boolean)false, (SerializerFeature[])new SerializerFeature[0]);
        return this.onInsert(session, jsonparam);
    }

    public <T> ServiceResponse onInsert(T bean) {
        return this.onInsert(SpringContext.getSession(), bean);
    }

    public ServiceResponse insert(JSONObject paramsObject) {
        return this.insert(SpringContext.getSession(), paramsObject);
    }

    public ServiceResponse insert(ServiceSession session, JSONObject paramsObject) {
        return this.onInsert(session, paramsObject);
    }

    public <T> ServiceResponse onInsert(List<T> list) {
        try {
            JSONObject paramsObject = new JSONObject();
            paramsObject.put(this.getCollectionName(), list);
            Method masterInsertMethod = this.masterClass.getMethod("onInsert", JSONObject.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterInsertMethod.invoke(masterServiceObj, paramsObject);
            Map<String, Class<?>> flds = this.getSlaveBean(this.masterBean);
            for (String slaveService : this.slaveServiceNames) {
                List slaveList;
                Class<?> slaveClass = this.getServiceBean(slaveService);
                String slaveCollectionName = this.getCollectionName(slaveClass);
                Class<?> clazz = flds.get(slaveCollectionName);
                if (StringUtils.isEmpty(clazz) || StringUtils.isEmpty((Object)(slaveList = this.getSlaveList(list, slaveCollectionName, clazz))) || slaveList.size() <= 0) continue;
                JSONObject paramsSlave = new JSONObject();
                paramsSlave.put(slaveCollectionName, (Object)slaveList);
                Method slaveInsertMethod = slaveClass.getMethod("onInsert", JSONObject.class);
                Object slaveServiceObj = SpringContext.getBean(slaveClass, (Object[])new Object[0]);
                slaveInsertMethod.invoke(slaveServiceObj, paramsSlave);
            }
            return (ServiceResponse)data;
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10032", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public ServiceResponse onInsert(ServiceSession session, JSONObject paramsObject) {
        try {
            this.onBeforeInsert(session, paramsObject);
            Method masterSaveMethod = this.masterClass.getMethod("onInsert", ServiceSession.class, JSONObject.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterSaveMethod.invoke(masterServiceObj, session, paramsObject);
            String masterCollectionName = this.getCollectionName(this.masterClass);
            String masterKeyField = this.getKeyfieldName();
            ServiceResponse response = (ServiceResponse)data;
            JSONObject queryParam = new JSONObject();
            queryParam.put(masterKeyField, TypeUtils.toJSONObj((Object)response.getData(), (boolean)false, (SerializerFeature[])new SerializerFeature[0]).get((Object)masterKeyField));
            Method masterViewMethod = this.masterClass.getMethod("dataQueryFirst", ServiceSession.class, JSONObject.class);
            Object masterData = masterViewMethod.invoke(masterServiceObj, session, queryParam);
            Map<String, Class<?>> flds = this.getSlaveBean(this.masterBean);
            for (String slaveService : this.slaveServiceNames) {
                Class<?> slaveClass = this.getServiceBean(slaveService);
                String slaveCollectionName = this.getCollectionName(slaveClass);
                Class<?> clazz = flds.get(slaveCollectionName);
                if (StringUtils.isEmpty(clazz)) continue;
                Object slave = null;
                slave = paramsObject.containsKey((Object)masterCollectionName) ? paramsObject.getJSONObject(masterCollectionName).get((Object)slaveCollectionName) : paramsObject.get((Object)slaveCollectionName);
                Method slaveInsertMethod = slaveClass.getMethod("onInsert", ServiceSession.class, JSONObject.class);
                Method slaveInsertBatchMethod = slaveClass.getMethod("batchInsert", List.class);
                Object slaveServiceObj = SpringContext.getBean(slaveClass, (Object[])new Object[0]);
                if (slave != null && slave instanceof List) {
                    this.setSlaveListBusinessKeys(slave, clazz, masterData);
                    JSONObject slaveparam = new JSONObject();
                    slaveparam.put(slaveCollectionName, slave);
                    if (this.subInsertIsBatch) {
                        slaveInsertBatchMethod.invoke(slaveServiceObj, slave);
                        continue;
                    }
                    slaveInsertMethod.invoke(slaveServiceObj, session, slaveparam);
                    continue;
                }
                if (slave == null || !(slave instanceof Map)) continue;
                Map slavemap = (Map)slave;
                this.setSlaveMapBusinessKeys(slavemap, clazz, masterData);
                slaveInsertMethod.invoke(slaveServiceObj, session, slavemap);
            }
            this.onAfterInsert(session, paramsObject);
            return response;
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(e.getMessage());
        }
    }

    public <T> T onInsertRtnBean(JSONObject paramsObject) {
        return this.onInsertRtnBean(SpringContext.getSession(), paramsObject);
    }

    public <T> T onInsertRtnBean(ServiceSession session, JSONObject paramsObject) {
        return null;
    }

    public <T> List<T> onInsertListRtnBean(JSONObject paramsObject) {
        return this.onInsertListRtnBean(SpringContext.getSession(), paramsObject);
    }

    public <T> List<T> onInsertListRtnBean(ServiceSession session, JSONObject paramsObject) {
        return null;
    }

    public void setSlaveListBusinessKeys(Object slave, Class<?> clazz, Object masterData) throws Exception {
        block4: {
            block3: {
                if (!(slave instanceof JSONArray)) break block3;
                JSONArray paramsArray = (JSONArray)slave;
                for (int i = 0; i < paramsArray.size(); ++i) {
                    JSONObject params = paramsArray.getJSONObject(i);
                    this.setSlaveMapBusinessKeys((Map)params, clazz, masterData);
                }
                break block4;
            }
            if (!(slave instanceof List)) break block4;
            List list = (List)slave;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).getClass().equals(clazz)) {
                    this.setSlaveBusinessKeys(list.get(i), clazz, masterData);
                    continue;
                }
                this.setSlaveMapBusinessKeys((Map)list.get(i), clazz, masterData);
            }
        }
    }

    public void setSlaveBusinessKeys(Object slave, Class<?> clazz, Object masterData) throws Exception {
        if (slave.getClass().equals(clazz)) {
            String[] masterSlaveFields = this.getMasterSlaveFields(this.masterBean);
            String[] masterSlaveFields_slave = this.getMasterSlaveFields(clazz);
            for (int j = 0; j < masterSlaveFields_slave.length; ++j) {
                String field = masterSlaveFields_slave[j];
                if (!StringUtils.isEmpty((Object)MasterSlaveComponentServiceImpl.getFieldValue(clazz, slave, field))) continue;
                MasterSlaveComponentServiceImpl.setFieldValue(clazz, slave, field, MasterSlaveComponentServiceImpl.getFieldValue(this.masterBean, masterData, masterSlaveFields[j]));
            }
        }
    }

    public void setSlaveMapBusinessKeys(Map slavemap, Class<?> clazz, Object masterData) throws Exception {
        String[] masterSlaveFields = this.getMasterSlaveFields(this.masterBean);
        String[] masterSlaveFields_slave = this.getMasterSlaveFields(clazz);
        for (int j = 0; j < masterSlaveFields_slave.length; ++j) {
            String field = masterSlaveFields_slave[j];
            if (slavemap.containsKey(field) && !StringUtils.isEmpty(slavemap.get(field))) continue;
            slavemap.put(field, MasterSlaveComponentServiceImpl.getFieldValue(this.masterBean, masterData, masterSlaveFields[j]));
        }
    }

    public ServiceResponse onUpdate(ServiceSession session, JSONObject paramsObject) {
        try {
            Method masterSaveMethod = this.masterClass.getMethod("onUpdate", ServiceSession.class, JSONObject.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterSaveMethod.invoke(masterServiceObj, session, paramsObject);
            return (ServiceResponse)data;
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10033", (Object[])new Object[]{e.getMessage()}, (String)session.getLocale()));
        }
    }

    public <T> ServiceResponse onUpdate(ServiceSession session, T bean) {
        JSONObject jsonparam = TypeUtils.toJSONObj(bean, (boolean)false, (SerializerFeature[])new SerializerFeature[0]);
        return this.onUpdate(session, jsonparam);
    }

    public ServiceResponse onUpdate(JSONObject paramsObject) {
        return this.onUpdate(SpringContext.getSession(), paramsObject);
    }

    public <T> int onUpdateBean(T bean) {
        return this.onUpdateBean(bean, null);
    }

    public <T> int onUpdateBean(T bean, Set<String> keys) {
        try {
            Method masterKeyMethod = this.masterClass.getMethod("onUpdateBean", Object.class, Set.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterKeyMethod.invoke(masterServiceObj, bean, keys);
            return (Integer)data;
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10033", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public void onBeforeDelete(ServiceSession session, JSONObject paramsObject) {
    }

    public void onAfterDelete(ServiceSession session, JSONObject paramsObject) {
    }

    public <T> ServiceResponse onDelete(T bean) {
        return this.onDelete(SpringContext.getSession(), bean);
    }

    public <T> ServiceResponse onDelete(ServiceSession session, T bean) {
        JSONObject jsonparam = TypeUtils.toJSONObj(bean, (boolean)false, (SerializerFeature[])new SerializerFeature[0]);
        return this.onDelete(session, jsonparam);
    }

    public ServiceResponse onDelete(JSONObject paramsObject) {
        return this.onDelete(SpringContext.getSession(), paramsObject);
    }

    public ServiceResponse delete(JSONObject paramsObject) {
        return this.delete(SpringContext.getSession(), paramsObject);
    }

    public ServiceResponse delete(ServiceSession session, JSONObject paramsObject) {
        return this.onDelete(session, paramsObject);
    }

    public ServiceResponse onDelete(ServiceSession session, JSONObject paramsObject) {
        try {
            this.onBeforeDelete(session, paramsObject);
            Method masterViewMethod = this.masterClass.getMethod("dataQueryFirst", ServiceSession.class, JSONObject.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterViewMethod.invoke(masterServiceObj, session, paramsObject);
            this.onDeleteSlave(session, data);
            Method masterDeleteMethod = this.masterClass.getMethod("onDelete", ServiceSession.class, JSONObject.class);
            Object object = masterDeleteMethod.invoke(masterServiceObj, session, paramsObject);
            this.onAfterDelete(session, paramsObject);
            return (ServiceResponse)object;
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e.getMessage());
        }
    }

    public void onDeleteSlave(ServiceSession session, Object data) throws Exception {
        if (!StringUtils.isEmpty((Object)data)) {
            String[] masterSlaveFields = null;
            try {
                masterSlaveFields = this.getMasterSlaveFields(this.masterBean);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u4e3b\u8868\u6a21\u578b\u4e2d\u672a\u914d\u7f6e\u4e3b\u4ece\u5173\u8054\uff0c\u6216\u8005\u914d\u7f6e\u9519\u8bef");
            }
            if (!StringUtils.isEmpty((Object)masterSlaveFields)) {
                Map<String, Class<?>> flds = this.getSlaveBean(this.masterBean);
                for (String slaveService : this.slaveServiceNames) {
                    Class<?> slaveClass = this.getServiceBean(slaveService);
                    String slaveCollectionName = this.getCollectionName(slaveClass);
                    Class<?> clazz = flds.get(slaveCollectionName);
                    if (StringUtils.isEmpty(clazz)) continue;
                    String[] masterSlaveFields_slave = null;
                    try {
                        masterSlaveFields_slave = this.getMasterSlaveFields(clazz);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.error("\u4ece\u8868" + slaveCollectionName + "\u672a\u914d\u7f6e\u4e3b\u4ece\u5173\u8054\uff0c\u6216\u8005\u914d\u7f6e\u9519\u8bef");
                    }
                    if (StringUtils.isEmpty((Object)masterSlaveFields_slave)) continue;
                    JSONObject slaveparam = new JSONObject();
                    for (int i = 0; i < masterSlaveFields_slave.length; ++i) {
                        String field = masterSlaveFields_slave[i];
                        slaveparam.put(field, MasterSlaveComponentServiceImpl.getFieldValue(this.masterBean, data, masterSlaveFields[i]));
                    }
                    Method slaveDeleteMethod = slaveClass.getMethod("onDelete", ServiceSession.class, JSONObject.class);
                    Object slaveServiceObj = SpringContext.getBean(slaveClass, (Object[])new Object[0]);
                    slaveDeleteMethod.invoke(slaveServiceObj, session, slaveparam);
                }
            }
        }
    }

    public <T> ServiceResponse onDelete(List<T> list) {
        list.forEach(e -> this.onDelete(e));
        return ServiceResponse.buildSuccess((Object)I18nUtil.getMessage((String)"99002"));
    }

    public ServiceResponse onSave(JSONObject paramsObject) throws Exception {
        return this.onSave(SpringContext.getSession(), paramsObject);
    }

    public <T> ServiceResponse onSave(List<T> list) {
        List<Object> updatelist;
        List insertlist;
        List deletelist = list.stream().filter(e -> "D".equals(this.getModelFlag((JSONObject)TypeUtils.toJSON((Object)e, (boolean)false, (SerializerFeature[])new SerializerFeature[0])))).collect(Collectors.toList());
        if (!StringUtils.isEmpty(deletelist) && deletelist.size() > 0) {
            this.onDelete(deletelist);
        }
        if (!StringUtils.isEmpty(insertlist = list.stream().filter(e -> "I".equals(this.getModelFlag((JSONObject)TypeUtils.toJSON((Object)e, (boolean)false, (SerializerFeature[])new SerializerFeature[0])))).collect(Collectors.toList())) && insertlist.size() > 0) {
            this.onInsert(insertlist);
        }
        if (!StringUtils.isEmpty(updatelist = list.stream().filter(e -> "U".equals(this.getModelFlag((JSONObject)TypeUtils.toJSON((Object)e, (boolean)false, (SerializerFeature[])new SerializerFeature[0])))).collect(Collectors.toList())) && updatelist.size() > 0) {
            updatelist.forEach(e -> {
                try {
                    this.onSave((JSONObject)TypeUtils.toJSON((Object)e, (boolean)false, (SerializerFeature[])new SerializerFeature[0]));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10034", (Object[])new Object[]{ex.getMessage()}));
                }
            });
        }
        return ServiceResponse.buildSuccess((Object)I18nUtil.getMessage((String)"99006"));
    }

    public void onBeforeSave(ServiceSession session, JSONObject paramsObject) {
    }

    public void onAfterSave(ServiceSession session, JSONObject paramsObject) {
    }

    public void beforeSave(ServiceSession session, T bean) {
    }

    public ServiceResponse save(ServiceSession session, T bean) throws Exception {
        this.beforeSave(session, bean);
        JSONObject jsonparam = TypeUtils.toJSONObj((Object)bean, (boolean)false, (SerializerFeature[])new SerializerFeature[0]);
        return this.onSave(session, jsonparam);
    }

    public ServiceResponse onSave(ServiceSession session, JSONObject paramsObject) throws Exception {
        this.onBeforeSave(session, paramsObject);
        Method masterSaveMethod = this.masterClass.getMethod("onSave", ServiceSession.class, JSONObject.class);
        Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
        Object data = masterSaveMethod.invoke(masterServiceObj, session, paramsObject);
        String masterCollectionName = this.getCollectionName(this.masterClass);
        String masterKeyField = this.getKeyfieldName();
        ServiceResponse response = (ServiceResponse)data;
        if ("0".equals(response.getReturncode())) {
            Method masterViewMethod = this.masterClass.getMethod("dataQueryFirst", ServiceSession.class, JSONObject.class);
            JSONObject queryParam = new JSONObject();
            queryParam.put(masterKeyField, TypeUtils.toJSONObj((Object)response.getData(), (boolean)false, (SerializerFeature[])new SerializerFeature[0]).get((Object)masterKeyField));
            Object masterData = masterViewMethod.invoke(masterServiceObj, session, queryParam);
            Map<String, Class<?>> flds = this.getSlaveBean(this.masterBean);
            for (String slaveService : this.slaveServiceNames) {
                Class<?> slaveClass = this.getServiceBean(slaveService);
                String slaveCollectionName = this.getCollectionName(slaveClass);
                Class<?> clazz = flds.get(slaveCollectionName);
                if (StringUtils.isEmpty(clazz)) continue;
                Object slave = null;
                if (paramsObject.containsKey((Object)masterCollectionName)) {
                    slave = paramsObject.getJSONObject(masterCollectionName).get((Object)slaveCollectionName);
                } else {
                    slave = paramsObject.get((Object)slaveCollectionName);
                    if (Character.isDigit(slaveCollectionName.charAt(slaveCollectionName.length() - 1)) && StringUtils.isEmpty((Object)slave)) {
                        slave = paramsObject.get((Object)slaveCollectionName.substring(0, slaveCollectionName.length() - 1));
                    }
                }
                this.onSaveSlave(slaveClass, masterData, slave, clazz);
            }
            paramsObject.put(masterKeyField, TypeUtils.toJSONObj((Object)response.getData(), (boolean)false, (SerializerFeature[])new SerializerFeature[0]).get((Object)masterKeyField));
            this.onAfterSave(session, paramsObject);
        }
        return response;
    }

    public void onSaveSlave(Class<?> clazz, Object masterData, Object slave, Class<?> entity) throws Exception {
        String slaveCollectionName = this.getCollectionName(clazz);
        String keyField = this.getKeyfieldName(clazz);
        if (slave != null && slave instanceof List) {
            JSONArray paramsArray = (JSONArray)slave;
            ArrayList deleteList = new ArrayList();
            JSONArray deleteArray = new JSONArray();
            JSONArray insertArray = new JSONArray();
            JSONArray updateArray = new JSONArray();
            ArrayList insList = new ArrayList();
            paramsArray.forEach(e -> {
                JSONObject dataMap = (JSONObject)JSON.toJSON((Object)e);
                String dataFlag = this.getModelFlag(dataMap);
                if ("D".equalsIgnoreCase(dataFlag)) {
                    if (!StringUtils.isEmpty((Object)dataMap.get((Object)keyField))) {
                        deleteList.add(dataMap.get((Object)keyField));
                        JSONObject keys = new JSONObject();
                        keys.put(keyField, dataMap.get((Object)keyField));
                        keys.put("_flag", (Object)"D");
                        deleteArray.add((Object)keys);
                    }
                } else if ("I".equalsIgnoreCase(dataFlag)) {
                    try {
                        this.setSlaveMapBusinessKeys((Map)dataMap, entity, masterData);
                        insertArray.add((Object)dataMap);
                        insList.add(TypeUtils.toJavaObject((JSON)dataMap, (Class)entity));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if ("U".equalsIgnoreCase(dataFlag)) {
                    updateArray.add((Object)dataMap);
                }
            });
            Object slaveServiceObj = SpringContext.getBean(clazz, (Object[])new Object[0]);
            Method slaveSaveMethod = clazz.getMethod("onSave", JSONObject.class);
            Method slaveInsertBatchMethod = clazz.getMethod("batchInsert", List.class);
            JSONObject slaveDelParam = new JSONObject();
            JSONObject slaveInsParam = new JSONObject();
            JSONObject slaveUptParam = new JSONObject();
            Object slaveDelData = null;
            ServiceResponse slaveDelResponse = null;
            Object slaveInsData = null;
            ServiceResponse slaveInsResponse = null;
            Object slaveUptData = null;
            ServiceResponse slaveUptResponse = null;
            if (!StringUtils.isEmpty((Object)deleteArray) && deleteArray.size() > 0) {
                slaveDelParam.put(slaveCollectionName, (Object)deleteArray);
                slaveDelData = slaveSaveMethod.invoke(slaveServiceObj, slaveDelParam);
                slaveDelResponse = (ServiceResponse)slaveDelData;
                if (!"0".equals(slaveDelResponse.getReturncode())) {
                    throw new ServiceRuntimeException(slaveDelResponse.getData().toString());
                }
            }
            if (!StringUtils.isEmpty((Object)insertArray) && insertArray.size() > 0) {
                if (this.subInsertIsBatch) {
                    slaveInsertBatchMethod.invoke(slaveServiceObj, insList);
                } else {
                    slaveInsParam.put(slaveCollectionName, (Object)insertArray);
                    slaveInsData = slaveSaveMethod.invoke(slaveServiceObj, slaveInsParam);
                    slaveInsResponse = (ServiceResponse)slaveInsData;
                    if (!"0".equals(slaveInsResponse.getReturncode())) {
                        throw new ServiceRuntimeException(slaveInsResponse.getData().toString());
                    }
                }
            }
            if (!StringUtils.isEmpty((Object)updateArray) && updateArray.size() > 0) {
                slaveUptParam.put(slaveCollectionName, (Object)updateArray);
                slaveUptData = slaveSaveMethod.invoke(slaveServiceObj, slaveUptParam);
                slaveUptResponse = (ServiceResponse)slaveUptData;
                if (!"0".equals(slaveUptResponse.getReturncode())) {
                    throw new ServiceRuntimeException(slaveUptResponse.getData().toString());
                }
            }
        } else if (slave != null && slave instanceof Map) {
            Object slaveServiceObj;
            Method slaveSaveMethod;
            Object slavedata;
            ServiceResponse slaveresponse;
            Map slavemap = (Map)slave;
            String dataFlag = this.getModelFlag((JSONObject)slavemap);
            if ("I".equalsIgnoreCase(dataFlag)) {
                this.setSlaveMapBusinessKeys(slavemap, entity, masterData);
            }
            if (!"0".equals((slaveresponse = (ServiceResponse)(slavedata = (slaveSaveMethod = clazz.getMethod("onSave", JSONObject.class)).invoke(slaveServiceObj = SpringContext.getBean(clazz, (Object[])new Object[0]), slavemap))).getReturncode())) {
                throw new ServiceRuntimeException(slaveresponse.getData().toString());
            }
        }
    }

    public <T> List<T> dataQueryTotal(Query query) {
        try {
            Method masterKeyMethod = this.masterClass.getMethod("dataQueryTotal", Query.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterKeyMethod.invoke(masterServiceObj, query);
            return (List)data;
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"50024", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public <T> List<T> dataQueryTotal(JSONObject jsonObject) {
        try {
            Method masterKeyMethod = this.masterClass.getMethod("dataQueryTotal", JSONObject.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterKeyMethod.invoke(masterServiceObj, jsonObject);
            return (List)data;
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"50024", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public <T> List<T> dataQueryTotalPage(Query query) {
        try {
            Method masterKeyMethod = this.masterClass.getMethod("dataQueryTotalPage", Query.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterKeyMethod.invoke(masterServiceObj, query);
            return (List)data;
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"50024", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public <T> List<T> dataQueryTotalPage(JSONObject jsonObject) {
        try {
            Method masterKeyMethod = this.masterClass.getMethod("dataQueryTotalPage", JSONObject.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterKeyMethod.invoke(masterServiceObj, jsonObject);
            return (List)data;
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"50024", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public ServiceResponse onImportData(String params, MultipartFile file) throws Exception {
        Method masterKeyMethod = this.masterClass.getMethod("onImportData", String.class, MultipartFile.class);
        Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
        Object data = masterKeyMethod.invoke(masterServiceObj, params, file);
        return (ServiceResponse)data;
    }

    public ServiceResponse onImportData(ServiceSession session, String params, MultipartFile file) throws Exception {
        Method masterKeyMethod = this.masterClass.getMethod("onImportData", ServiceSession.class, String.class, MultipartFile.class);
        Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
        Object data = masterKeyMethod.invoke(masterServiceObj, session, params, file);
        return (ServiceResponse)data;
    }

    public <T> List getSlaveList(List<T> list, String CollectionName, Class<?> clazz) throws Exception {
        ArrayList slaveList = new ArrayList();
        for (T t : list) {
            List tmp = (List)MasterSlaveComponentServiceImpl.getFieldValue(this.masterBean, t, CollectionName);
            this.setSlaveListBusinessKeys(tmp, clazz, t);
            if (StringUtils.isEmpty((Object)tmp) || tmp.size() <= 0) continue;
            slaveList.addAll(tmp);
        }
        return slaveList;
    }

    public <T> void batchInsert(List<T> list) throws Exception {
        this.batchInsert(this.masterClass, list);
        Map<String, Class<?>> flds = this.getSlaveBean(this.masterBean);
        for (String slaveService : this.slaveServiceNames) {
            List slaveList;
            Class<?> slaveClass = this.getServiceBean(slaveService);
            String slaveCollectionName = this.getCollectionName(slaveClass);
            Class<?> clazz = flds.get(slaveCollectionName);
            if (StringUtils.isEmpty(clazz) || StringUtils.isEmpty((Object)(slaveList = this.getSlaveList(list, slaveCollectionName, clazz))) || slaveList.size() <= 0) continue;
            this.batchInsert(slaveClass, slaveList);
        }
    }

    public <T> void batchInsert(List<T> list, int batch_rows) throws Exception {
        this.batchInsert(this.masterClass, list, batch_rows);
        Map<String, Class<?>> flds = this.getSlaveBean(this.masterBean);
        for (String slaveService : this.slaveServiceNames) {
            List slaveList;
            Class<?> slaveClass = this.getServiceBean(slaveService);
            String slaveCollectionName = this.getCollectionName(slaveClass);
            Class<?> clazz = flds.get(slaveCollectionName);
            if (StringUtils.isEmpty(clazz) || StringUtils.isEmpty((Object)(slaveList = this.getSlaveList(list, slaveCollectionName, clazz))) || slaveList.size() <= 0) continue;
            this.batchInsert(slaveClass, slaveList, batch_rows);
        }
    }

    public <T> void batchInsert(List<T> list, Set<String> fields) throws Exception {
        this.batchInsert(this.masterClass, list, fields);
        Map<String, Class<?>> flds = this.getSlaveBean(this.masterBean);
        for (String slaveService : this.slaveServiceNames) {
            List slaveList;
            Class<?> slaveClass = this.getServiceBean(slaveService);
            String slaveCollectionName = this.getCollectionName(slaveClass);
            Class<?> clazz = flds.get(slaveCollectionName);
            if (StringUtils.isEmpty(clazz) || StringUtils.isEmpty((Object)(slaveList = this.getSlaveList(list, slaveCollectionName, clazz))) || slaveList.size() <= 0) continue;
            this.batchInsert(slaveClass, slaveList);
        }
    }

    public <T> void batchInsert(List<T> list, Set<String> fields, int batch_rows) throws Exception {
        this.batchInsert(this.masterClass, list, fields, batch_rows);
        Map<String, Class<?>> flds = this.getSlaveBean(this.masterBean);
        for (String slaveService : this.slaveServiceNames) {
            List slaveList;
            Class<?> slaveClass = this.getServiceBean(slaveService);
            String slaveCollectionName = this.getCollectionName(slaveClass);
            Class<?> clazz = flds.get(slaveCollectionName);
            if (StringUtils.isEmpty(clazz) || StringUtils.isEmpty((Object)(slaveList = this.getSlaveList(list, slaveCollectionName, clazz))) || slaveList.size() <= 0) continue;
            this.batchInsert(slaveClass, slaveList, batch_rows);
        }
    }

    public <T> void batchInsert(Class<?> cl, List<T> list, Set<String> fields, int batch_rows) {
        try {
            Method batchInsertMethod = cl.getMethod("batchInsert", List.class, Set.class, Integer.class);
            Object serviceObj = SpringContext.getBean(cl, (Object[])new Object[0]);
            batchInsertMethod.invoke(serviceObj, list, fields, batch_rows);
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10034", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public <T> void batchInsert(Class<?> cl, List<T> list, Set<String> fields) {
        try {
            Method batchInsertMethod = cl.getMethod("batchInsert", List.class, Set.class);
            Object serviceObj = SpringContext.getBean(cl, (Object[])new Object[0]);
            batchInsertMethod.invoke(serviceObj, list, fields);
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10034", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public <T> void batchInsert(Class<?> cl, List<T> list) {
        try {
            Method batchInsertMethod = cl.getMethod("batchInsert", List.class);
            Object serviceObj = SpringContext.getBean(cl, (Object[])new Object[0]);
            batchInsertMethod.invoke(serviceObj, list);
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10034", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public <T> void batchInsert(Class<?> cl, List<T> list, int batch_rows) {
        try {
            Method batchInsertMethod = cl.getMethod("batchInsert", List.class, Integer.class);
            Object serviceObj = SpringContext.getBean(cl, (Object[])new Object[0]);
            batchInsertMethod.invoke(serviceObj, list, batch_rows);
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10034", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public Long count(JSONObject jsonObject) {
        try {
            Method countMethod = this.masterClass.getMethod("count", JSONObject.class);
            Object serviceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Long count = (Long)countMethod.invoke(serviceObj, jsonObject);
            return count;
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10035", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public Long count(Query query) {
        try {
            Method countMethod = this.masterClass.getMethod("count", Query.class);
            Object serviceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Long count = (Long)countMethod.invoke(serviceObj, query);
            return count;
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10035", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public Object max(JSONObject jsonObject, String fieldName) {
        try {
            Method maxMethod = this.masterClass.getMethod("max", JSONObject.class, String.class);
            Object serviceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            return maxMethod.invoke(serviceObj, jsonObject, fieldName);
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10036", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public Object max(Query query, String fieldName) {
        try {
            Method maxMethod = this.masterClass.getMethod("max", Query.class, String.class);
            Object serviceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            return maxMethod.invoke(serviceObj, query, fieldName);
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10036", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public Object min(JSONObject jsonObject, String fieldName) {
        try {
            Method minMethod = this.masterClass.getMethod("min", JSONObject.class, String.class);
            Object serviceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            return minMethod.invoke(serviceObj, jsonObject, fieldName);
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10037", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public Object min(Query query, String fieldName) {
        try {
            Method minMethod = this.masterClass.getMethod("min", Query.class, String.class);
            Object serviceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            return minMethod.invoke(serviceObj, query, fieldName);
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10037", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public Object sum(JSONObject jsonObject, String fieldName) {
        try {
            Method sumMethod = this.masterClass.getMethod("sum", JSONObject.class, String.class);
            Object serviceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            return sumMethod.invoke(serviceObj, jsonObject, fieldName);
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10038", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public Object sum(Query query, String fieldName) {
        try {
            Method sumMethod = this.masterClass.getMethod("sum", Query.class, String.class);
            Object serviceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            return sumMethod.invoke(serviceObj, query, fieldName);
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10038", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public Object avg(JSONObject jsonObject, String fieldName) {
        try {
            Method avgMethod = this.masterClass.getMethod("avg", JSONObject.class, String.class);
            Object serviceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            return avgMethod.invoke(serviceObj, jsonObject, fieldName);
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10039", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public Object avg(Query query, String fieldName) {
        try {
            Method avgMethod = this.masterClass.getMethod("avg", Query.class, String.class);
            Object serviceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            return avgMethod.invoke(serviceObj, query, fieldName);
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10039", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public int onRemoved(Query query) {
        return 0;
    }

    public <T> int batchUpdateByIds(List<T> list, Set<String> keys) throws Exception {
        return 0;
    }

    public <T> ServiceResponse onUpdateByUniqueKey(T bean) {
        return this.onUpdateByUniqueKeySingle(TypeUtils.toJSONObj(bean, (boolean)false, (SerializerFeature[])new SerializerFeature[0]));
    }

    public <T> ServiceResponse onUpdateByUniqueKey(List<T> list) {
        for (T bean : list) {
            this.onUpdateByUniqueKey(bean);
        }
        return ServiceResponse.buildSuccess((Object)"success");
    }

    public void onUpdateArrayByUniqueKey(JSONArray dataList) {
        for (int i = 0; i < dataList.size(); ++i) {
            JSONObject params = dataList.getJSONObject(i);
            this.onUpdateByUniqueKeySingle(params);
        }
    }

    public ServiceResponse onUpdateByUniqueKey(JSONObject paramsObject) {
        String collectionName = this.getCollectionName();
        if (paramsObject.containsKey((Object)collectionName)) {
            Object dataObject = paramsObject.get((Object)collectionName);
            if (dataObject != null && dataObject instanceof List) {
                JSONArray paramsArray = paramsObject.getJSONArray(collectionName);
                this.onUpdateArrayByUniqueKey(paramsArray);
                return ServiceResponse.buildSuccess((Object)"success");
            }
            return this.onUpdateByUniqueKeySingle(TypeUtils.toJSONObj((Object)dataObject, (boolean)false, (SerializerFeature[])new SerializerFeature[0]));
        }
        return this.onUpdateByUniqueKeySingle(paramsObject);
    }

    public ServiceResponse onUpdateByUniqueKeySingle(JSONObject paramsObject) {
        ServiceSession session = SpringContext.getSession();
        try {
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Method masterUpdateMethod = this.masterClass.getMethod("onUpdateByUniqueKeySingle", JSONObject.class);
            Object object = masterUpdateMethod.invoke(masterServiceObj, paramsObject);
            return (ServiceResponse)object;
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e.getMessage());
        }
    }

    public <T> ServiceResponse onDeleteByUniqueKey(T bean) {
        return this.onDeleteByUniqueKeySingle(TypeUtils.toJSONObj(bean, (boolean)false, (SerializerFeature[])new SerializerFeature[0]));
    }

    public <T> ServiceResponse onDeleteByUniqueKey(List<T> list) {
        for (T bean : list) {
            this.onDeleteByUniqueKey(bean);
        }
        return ServiceResponse.buildSuccess((Object)"success");
    }

    public void onDeleteArrayByUniqueKey(JSONArray dataList) {
        for (int i = 0; i < dataList.size(); ++i) {
            JSONObject params = dataList.getJSONObject(i);
            this.onDeleteByUniqueKeySingle(params);
        }
    }

    public ServiceResponse onDeleteByUniqueKey(JSONObject paramsObject) {
        String collectionName = this.getCollectionName();
        if (paramsObject.containsKey((Object)collectionName)) {
            Object dataObject = paramsObject.get((Object)collectionName);
            if (dataObject != null && dataObject instanceof List) {
                JSONArray paramsArray = paramsObject.getJSONArray(collectionName);
                this.onDeleteArrayByUniqueKey(paramsArray);
                return ServiceResponse.buildSuccess((Object)"success");
            }
            return this.onDeleteByUniqueKeySingle(TypeUtils.toJSONObj((Object)dataObject, (boolean)false, (SerializerFeature[])new SerializerFeature[0]));
        }
        return this.onDeleteByUniqueKeySingle(paramsObject);
    }

    public ServiceResponse onDeleteByUniqueKeySingle(JSONObject paramsObject) {
        ServiceSession session = SpringContext.getSession();
        try {
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Method masterDeleteMethod = this.masterClass.getMethod("onDeleteByUniqueKeySingle", JSONObject.class);
            Object object = masterDeleteMethod.invoke(masterServiceObj, paramsObject);
            return (ServiceResponse)object;
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e.getMessage());
        }
    }

    public <T> ServiceResponse onSaveByUniqueKey(T bean) {
        return this.onSaveByUniqueKeySingle(TypeUtils.toJSONObj(bean, (boolean)false, (SerializerFeature[])new SerializerFeature[0]));
    }

    public <T> ServiceResponse onSaveByUniqueKey(List<T> list) {
        List<Object> updatelist;
        List insertlist;
        List deletelist = list.stream().filter(e -> "D".equals(this.getModelFlag((JSONObject)TypeUtils.toJSON((Object)e, (boolean)false, (SerializerFeature[])new SerializerFeature[0])))).collect(Collectors.toList());
        if (!StringUtils.isEmpty(deletelist) && deletelist.size() > 0) {
            this.onDeleteByUniqueKey(deletelist);
        }
        if (!StringUtils.isEmpty(insertlist = list.stream().filter(e -> "I".equals(this.getModelFlag((JSONObject)TypeUtils.toJSON((Object)e, (boolean)false, (SerializerFeature[])new SerializerFeature[0])))).collect(Collectors.toList())) && insertlist.size() > 0) {
            this.onInsert(insertlist);
        }
        if (!StringUtils.isEmpty(updatelist = list.stream().filter(e -> "U".equals(this.getModelFlag((JSONObject)TypeUtils.toJSON((Object)e, (boolean)false, (SerializerFeature[])new SerializerFeature[0])))).collect(Collectors.toList())) && updatelist.size() > 0) {
            updatelist.forEach(e -> {
                try {
                    this.onSaveByUniqueKeySingle((JSONObject)TypeUtils.toJSON((Object)e, (boolean)false, (SerializerFeature[])new SerializerFeature[0]));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10034", (Object[])new Object[]{ex.getMessage()}));
                }
            });
        }
        return ServiceResponse.buildSuccess((Object)"success");
    }

    public ServiceResponse onSaveByUniqueKey(JSONObject paramsObject) {
        String collectionName = this.getCollectionName();
        if (paramsObject.containsKey((Object)collectionName)) {
            Object dataObject = paramsObject.get((Object)collectionName);
            if (dataObject != null && dataObject instanceof List) {
                return ServiceResponse.buildSuccess((Object)"success");
            }
            return this.onSaveByUniqueKeySingle(TypeUtils.toJSONObj((Object)dataObject, (boolean)false, (SerializerFeature[])new SerializerFeature[0]));
        }
        return this.onSaveByUniqueKeySingle(paramsObject);
    }

    public ServiceResponse onSaveByUniqueKeySingle(JSONObject paramsObject) {
        ServiceSession session = SpringContext.getSession();
        try {
            this.onBeforeSave(session, paramsObject);
            Method masterSaveMethod = this.masterClass.getMethod("onSaveByUniqueKeySingle", JSONObject.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterSaveMethod.invoke(masterServiceObj, paramsObject);
            String masterCollectionName = this.getCollectionName(this.masterClass);
            String masterKeyField = this.getKeyfieldName();
            ServiceResponse response = (ServiceResponse)data;
            if ("0".equals(response.getReturncode())) {
                Method masterViewMethod = this.masterClass.getMethod("dataQueryFirst", ServiceSession.class, JSONObject.class);
                JSONObject queryParam = new JSONObject();
                queryParam.put(masterKeyField, TypeUtils.toJSONObj((Object)response.getData(), (boolean)false, (SerializerFeature[])new SerializerFeature[0]).get((Object)masterKeyField));
                Object masterData = masterViewMethod.invoke(masterServiceObj, session, queryParam);
                Map<String, Class<?>> flds = this.getSlaveBean(this.masterBean);
                for (String slaveService : this.slaveServiceNames) {
                    Class<?> slaveClass = this.getServiceBean(slaveService);
                    String slaveCollectionName = this.getCollectionName(slaveClass);
                    Class<?> clazz = flds.get(slaveCollectionName);
                    if (StringUtils.isEmpty(clazz)) continue;
                    Object slave = null;
                    if (paramsObject.containsKey((Object)masterCollectionName)) {
                        slave = paramsObject.getJSONObject(masterCollectionName).get((Object)slaveCollectionName);
                    } else {
                        slave = paramsObject.get((Object)slaveCollectionName);
                        if (Character.isDigit(slaveCollectionName.charAt(slaveCollectionName.length() - 1)) && StringUtils.isEmpty((Object)slave)) {
                            slave = paramsObject.get((Object)slaveCollectionName.substring(0, slaveCollectionName.length() - 1));
                        }
                    }
                    this.onSaveSlaveByUniqueKey(slaveClass, masterData, slave, clazz);
                }
                paramsObject.put(masterKeyField, TypeUtils.toJSONObj((Object)response.getData(), (boolean)false, (SerializerFeature[])new SerializerFeature[0]).get((Object)masterKeyField));
                this.onAfterSave(session, paramsObject);
            }
            return response;
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e.getMessage());
        }
    }

    public void onSaveSlaveByUniqueKey(Class<?> clazz, Object masterData, Object slave, Class<?> entity) throws Exception {
        String slaveCollectionName = this.getCollectionName(clazz);
        String keyField = this.getKeyfieldName(clazz);
        if (slave != null && slave instanceof List) {
            JSONArray paramsArray = (JSONArray)slave;
            ArrayList deleteList = new ArrayList();
            JSONArray deleteArray = new JSONArray();
            JSONArray insertArray = new JSONArray();
            JSONArray updateArray = new JSONArray();
            ArrayList insList = new ArrayList();
            paramsArray.forEach(e -> {
                JSONObject dataMap = (JSONObject)JSON.toJSON((Object)e);
                String dataFlag = this.getModelFlag(dataMap);
                if ("D".equalsIgnoreCase(dataFlag)) {
                    deleteArray.add((Object)dataMap);
                } else if ("I".equalsIgnoreCase(dataFlag)) {
                    try {
                        this.setSlaveMapBusinessKeys((Map)dataMap, entity, masterData);
                        insertArray.add((Object)dataMap);
                        insList.add(TypeUtils.toJavaObject((JSON)dataMap, (Class)entity));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if ("U".equalsIgnoreCase(dataFlag)) {
                    updateArray.add((Object)dataMap);
                }
            });
            Object slaveServiceObj = SpringContext.getBean(clazz, (Object[])new Object[0]);
            Method slaveSaveMethod = clazz.getMethod("onSave", JSONObject.class);
            Method slaveDeleteMethod = clazz.getMethod("onDeleteByUniqueKey", JSONObject.class);
            Method slaveUpdateMethod = clazz.getMethod("onUpdateByUniqueKey", JSONObject.class);
            Method slaveInsertBatchMethod = clazz.getMethod("batchInsert", List.class);
            JSONObject slaveDelParam = new JSONObject();
            JSONObject slaveInsParam = new JSONObject();
            JSONObject slaveUptParam = new JSONObject();
            Object slaveDelData = null;
            ServiceResponse slaveDelResponse = null;
            Object slaveInsData = null;
            ServiceResponse slaveInsResponse = null;
            Object slaveUptData = null;
            ServiceResponse slaveUptResponse = null;
            if (!StringUtils.isEmpty((Object)deleteArray) && deleteArray.size() > 0) {
                slaveDelParam.put(slaveCollectionName, (Object)deleteArray);
                slaveDelData = slaveDeleteMethod.invoke(slaveServiceObj, slaveDelParam);
                slaveDelResponse = (ServiceResponse)slaveDelData;
                if (!"0".equals(slaveDelResponse.getReturncode())) {
                    throw new ServiceRuntimeException(slaveDelResponse.getData().toString());
                }
            }
            if (!StringUtils.isEmpty((Object)insertArray) && insertArray.size() > 0) {
                if (this.subInsertIsBatch) {
                    slaveInsertBatchMethod.invoke(slaveServiceObj, insList);
                } else {
                    slaveInsParam.put(slaveCollectionName, (Object)insertArray);
                    slaveInsData = slaveSaveMethod.invoke(slaveServiceObj, slaveInsParam);
                    slaveInsResponse = (ServiceResponse)slaveInsData;
                    if (!"0".equals(slaveInsResponse.getReturncode())) {
                        throw new ServiceRuntimeException(slaveInsResponse.getData().toString());
                    }
                }
            }
            if (!StringUtils.isEmpty((Object)updateArray) && updateArray.size() > 0) {
                slaveUptParam.put(slaveCollectionName, (Object)updateArray);
                slaveUptData = slaveUpdateMethod.invoke(slaveServiceObj, slaveUptParam);
                slaveUptResponse = (ServiceResponse)slaveUptData;
                if (!"0".equals(slaveUptResponse.getReturncode())) {
                    throw new ServiceRuntimeException(slaveUptResponse.getData().toString());
                }
            }
        } else if (slave != null && slave instanceof Map) {
            Map slavemap = (Map)slave;
            String dataFlag = this.getModelFlag((JSONObject)slavemap);
            Object slaveServiceObj = SpringContext.getBean(clazz, (Object[])new Object[0]);
            Object slavedata = null;
            if ("I".equalsIgnoreCase(dataFlag)) {
                this.setSlaveMapBusinessKeys(slavemap, entity, masterData);
                Method slaveSaveMethod = clazz.getMethod("onSave", JSONObject.class);
                slavedata = slaveSaveMethod.invoke(slaveServiceObj, slavemap);
            } else if ("D".equalsIgnoreCase(dataFlag)) {
                Method slaveDeleteMethod = clazz.getMethod("onDeleteByUniqueKeySingle", JSONObject.class);
                slavedata = slaveDeleteMethod.invoke(slaveServiceObj, slavemap);
            } else if ("U".equalsIgnoreCase(dataFlag)) {
                Method slaveUpdateMethod = clazz.getMethod("onUpdateByUniqueKeySingle", JSONObject.class);
                slavedata = slaveUpdateMethod.invoke(slaveServiceObj, slavemap);
            }
            ServiceResponse slaveresponse = (ServiceResponse)slavedata;
            if (!"0".equals(slaveresponse.getReturncode())) {
                throw new ServiceRuntimeException(slaveresponse.getData().toString());
            }
        }
    }

    public ServiceResponse onUpdateInsertByUniqueKey(JSONObject paramsObject) {
        try {
            Method masterSaveMethod = this.masterClass.getMethod("onUpdateInsertByUniqueKey", JSONObject.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterSaveMethod.invoke(masterServiceObj, paramsObject);
            return (ServiceResponse)data;
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10033", (Object[])new Object[]{e.getMessage()}, (String)SpringContext.getSession().getLocale()));
        }
    }

    public ServiceResponse onUpdateInsertByUniqueKeySingle(JSONObject paramsObject) {
        try {
            Method masterSaveMethod = this.masterClass.getMethod("onUpdateInsertByUniqueKeySingle", JSONObject.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterSaveMethod.invoke(masterServiceObj, paramsObject);
            return (ServiceResponse)data;
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(I18nUtil.getMessage((String)"10033", (Object[])new Object[]{e.getMessage()}, (String)SpringContext.getSession().getLocale()));
        }
    }
}

