/*
 * Decompiled with CFR 0.152.
 */
package com.product.component.essearch;

import com.alibaba.fastjson.JSONObject;
import com.product.model.BaseQueryModel;
import com.product.model.BeanConstant;
import com.product.model.ServiceResponse;
import com.product.service.EsDataService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@ConditionalOnProperty(name={"elasticsearch.enable"}, havingValue="true", matchIfMissing=false)
@Component
public class EsDataTemplate
implements EsDataService {
    private static final Logger log = LoggerFactory.getLogger(EsDataTemplate.class);
    @Resource
    private RestClient restClient;
    @Resource
    private ElasticsearchRestTemplate elasticsearchTemplate;

    @Override
    public <T> boolean onSave(T entity) {
        try {
            this.elasticsearchTemplate.save(entity);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> boolean onBatchSave(List<T> tList) {
        try {
            this.elasticsearchTemplate.save(tList);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> boolean onUpdate(T entity) {
        try {
            Document document = this.getUpdateDocument(entity);
            UpdateQuery query = UpdateQuery.builder((String)this.getPrimaryKeyValue(entity)).withDocument(document).build();
            IndexCoordinates index = this.getIndexCoordinates(entity);
            this.elasticsearchTemplate.update(query, index);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> boolean onBatchUpdate(List<T> entityList) {
        try {
            entityList.forEach(entity -> this.onUpdate(entity));
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> boolean onDelete(String indexName, String id) {
        try {
            IndexCoordinates index = IndexCoordinates.of((String[])new String[]{indexName});
            this.elasticsearchTemplate.delete(id, index);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> boolean onBatchDelete(String indexName, List<String> idList) {
        try {
            IndexCoordinates index = IndexCoordinates.of((String[])new String[]{indexName});
            idList.forEach(id -> this.elasticsearchTemplate.delete(id, index));
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> T findById(T entity, String id) {
        try {
            Class<?> clazz = entity.getClass();
            NativeSearchQueryBuilder queryBuilder = new NativeSearchQueryBuilder();
            queryBuilder.withQuery((QueryBuilder)QueryBuilders.matchQuery((String)"_id", (Object)id));
            SearchHit searchHit = this.elasticsearchTemplate.searchOne((Query)queryBuilder.build(), clazz);
            return (T)(searchHit == null ? null : searchHit.getContent());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public <T> T findOne(T entity) {
        try {
            Class<?> clazz = entity.getClass();
            NativeSearchQuery query = this.buildSearchQuery(entity);
            SearchHit searchHit = this.elasticsearchTemplate.searchOne((Query)query, clazz);
            return (T)(searchHit == null ? null : searchHit.getContent());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public <T> ServiceResponse findAll(T entity) {
        try {
            Class<?> clazz = entity.getClass();
            SearchHits searchHits = this.elasticsearchTemplate.search(Query.findAll(), clazz);
            List data = searchHits.get().map(SearchHit::getContent).collect(Collectors.toList());
            JSONObject resultJson = new JSONObject();
            resultJson.put(this.getIndexName(clazz), data);
            resultJson.put("total_results", (Object)searchHits.getTotalHits());
            return ServiceResponse.buildSuccess((Object)resultJson);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public <T> ServiceResponse findByPage(T entity) {
        try {
            PageRequest pageable;
            if (!(entity instanceof BaseQueryModel)) {
                throw new RuntimeException("\u5b9e\u4f53\u7c7b" + entity.getClass().getName() + "\u672a\u7ee7\u627fBaseQueryModel");
            }
            BaseQueryModel pageCondition = (BaseQueryModel)entity;
            if (null == pageCondition.getOrder_field()) {
                throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u5b9e\u4f53\u7c7b\u7684\u6392\u5e8f\u5b57\u6bb5");
            }
            Class<?> clazz = entity.getClass();
            NativeSearchQuery query = this.buildSearchQuery(entity);
            if (null != pageCondition.getPage_no() && null != pageCondition.getPage_size()) {
                pageable = PageRequest.of((int)pageCondition.getPage_no(), (int)pageCondition.getPage_size());
                query.setPageable((Pageable)pageable);
            } else {
                pageable = PageRequest.of((int)BeanConstant.QueryPage.DEFAULT_PAGENO, (int)BeanConstant.QueryPage.DEFAULT_PAGESIZE);
                query.setPageable((Pageable)pageable);
            }
            if (!StringUtils.isEmpty((Object)pageCondition.getOrder_direction()) && "desc".equals(pageCondition.getOrder_direction().toLowerCase())) {
                query.addSort(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{pageCondition.getOrder_field()}));
            } else {
                query.addSort(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{pageCondition.getOrder_field()}));
            }
            SearchHits search = this.elasticsearchTemplate.search((Query)query, clazz);
            List data = search.get().map(SearchHit::getContent).collect(Collectors.toList());
            JSONObject resultJson = new JSONObject();
            resultJson.put(this.getIndexName(clazz), data);
            resultJson.put("total_results", (Object)search.getTotalHits());
            return ServiceResponse.buildSuccess((Object)resultJson);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private <T> String getIndexName(Class<T> clazz) {
        Annotation annotation = AnnotationUtils.getAnnotation(clazz, org.springframework.data.elasticsearch.annotations.Document.class);
        org.springframework.data.elasticsearch.annotations.Document document = (org.springframework.data.elasticsearch.annotations.Document)annotation;
        String indexName = document.indexName();
        return indexName;
    }

    private <T> org.springframework.data.elasticsearch.annotations.Document getDocument(T entity) {
        Class<?> clazz = entity.getClass();
        Annotation annotation = AnnotationUtils.getAnnotation(clazz, org.springframework.data.elasticsearch.annotations.Document.class);
        org.springframework.data.elasticsearch.annotations.Document document = (org.springframework.data.elasticsearch.annotations.Document)annotation;
        return document;
    }

    private <T> IndexCoordinates getIndexCoordinates(T entity) {
        Class<?> clazz = entity.getClass();
        Annotation annotation = AnnotationUtils.getAnnotation(clazz, org.springframework.data.elasticsearch.annotations.Document.class);
        org.springframework.data.elasticsearch.annotations.Document document = (org.springframework.data.elasticsearch.annotations.Document)annotation;
        IndexCoordinates index = IndexCoordinates.of((String[])new String[]{document.indexName()});
        return index;
    }

    private <T> String getPrimaryKeyName(T entity) {
        String fieldName = null;
        try {
            for (Field field : entity.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                if (!field.isAnnotationPresent(Id.class)) continue;
                fieldName = field.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fieldName;
    }

    private <T> String getPrimaryKeyValue(T entity) {
        String id = null;
        try {
            for (Field field : entity.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                String fieldName = field.getName();
                Object fieldValue = field.get(entity);
                if (!field.isAnnotationPresent(Id.class) || StringUtils.isEmpty((Object)fieldValue)) continue;
                id = String.valueOf(fieldValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    private <T> Document getUpdateDocument(T entity) {
        Document document = Document.create();
        try {
            for (Field field : entity.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                String fieldName = field.getName();
                Object fieldValue = field.get(entity);
                document.put((Object)fieldName, fieldValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    private <T> NativeSearchQuery buildSearchQuery(T entity) {
        NativeSearchQueryBuilder queryBuilder = new NativeSearchQueryBuilder();
        try {
            for (Field field : entity.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                String fieldName = field.getName();
                Object fieldValue = field.get(entity);
                if (fieldValue == null) continue;
                queryBuilder.withQuery((QueryBuilder)QueryBuilders.matchQuery((String)fieldName, (Object)fieldValue));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return queryBuilder.build();
    }
}

