/*
 * Decompiled with CFR 0.152.
 */
package com.product.component.redis;

import com.product.annotation.redis.CacheKeyGenerator;
import com.product.annotation.redis.CacheLock;
import com.product.annotation.redis.CacheParam;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class LockKeyGenerator
implements CacheKeyGenerator {
    protected static final Logger LOGGER = LoggerFactory.getLogger(LockKeyGenerator.class);

    @Override
    public String getLockKey(ProceedingJoinPoint pjp) {
        LOGGER.info("---->LockKeyGenerator.getLockKey.1");
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        CacheLock lockAnnotation = method.getAnnotation(CacheLock.class);
        Object[] args = pjp.getArgs();
        Parameter[] parameters = method.getParameters();
        StringBuilder builder = new StringBuilder();
        LOGGER.info("---->LockKeyGenerator.getLockKey.2");
        for (int i = 0; i < parameters.length; ++i) {
            CacheParam annotation = parameters[i].getAnnotation(CacheParam.class);
            if (annotation == null) continue;
            builder.append(lockAnnotation.delimiter()).append(args[i]);
        }
        LOGGER.info("---->LockKeyGenerator.getLockKey.3");
        if (StringUtils.isEmpty((Object)builder.toString())) {
            LOGGER.info("---->LockKeyGenerator.getLockKey.4");
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            for (int i = 0; i < parameterAnnotations.length; ++i) {
                Field[] fields;
                Object object = args[i];
                if (object == null) continue;
                for (Field field : fields = object.getClass().getDeclaredFields()) {
                    CacheParam annotation = field.getAnnotation(CacheParam.class);
                    if (annotation == null) continue;
                    field.setAccessible(true);
                    builder.append(lockAnnotation.delimiter()).append(ReflectionUtils.getField((Field)field, (Object)object));
                }
            }
        }
        LOGGER.info("---->LockKeyGenerator.getLockKey.5->{}", (Object)builder.toString());
        return lockAnnotation.prefix() + builder.toString();
    }
}

