/*
 * Decompiled with CFR 0.152.
 */
package com.product.config.redis;

import com.alibaba.fastjson.JSON;
import com.product.annotation.redis.CacheKeyGenerator;
import com.product.annotation.redis.CacheLock;
import com.product.config.redis.RedisLockHelper;
import com.product.model.ServiceResponse;
import com.shiji.core.util.I18nUtil;
import java.lang.reflect.Method;
import java.util.UUID;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@Aspect
public class LockMethodInterceptor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(LockMethodInterceptor.class);
    private final RedisLockHelper redisLockHelper;
    private final CacheKeyGenerator cacheKeyGenerator;

    @Around(value="@annotation(com.product.annotation.redis.CacheLock)")
    public Object interceptor(ProceedingJoinPoint pjp) {
        LOGGER.info("---->LockMethodInterceptor.interceptor.1");
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        CacheLock lock = method.getAnnotation(CacheLock.class);
        if (StringUtils.isEmpty((Object)lock.prefix())) {
            LOGGER.info("---->LockMethodInterceptor.interceptor.2");
            return JSON.toJSONString((Object)ServiceResponse.buildFailureWithErrCode(null, (String)"10021", (Object[])new Object[0]));
        }
        String lockKey = this.cacheKeyGenerator.getLockKey(pjp);
        String value = UUID.randomUUID().toString();
        try {
            LOGGER.info("---->LockMethodInterceptor.interceptor.3");
            boolean success = this.redisLockHelper.lock(lockKey, value, lock.expire(), lock.timeUnit());
            if (!success) {
                LOGGER.info("---->LockMethodInterceptor.interceptor.4");
                throw new RuntimeException(I18nUtil.getMessage((String)"10022"));
            }
            LOGGER.info("---->LockMethodInterceptor.interceptor.5");
            try {
                Object object = pjp.proceed();
                return object;
            }
            catch (Throwable throwable) {
                LOGGER.info("---->LockMethodInterceptor.interceptor.6");
                throw new RuntimeException(I18nUtil.getMessage((String)"10023"));
            }
        }
        finally {
            LOGGER.info("---->LockMethodInterceptor.interceptor.7");
            this.redisLockHelper.unlock(lockKey, value);
        }
    }

    public LockMethodInterceptor(RedisLockHelper redisLockHelper, CacheKeyGenerator cacheKeyGenerator) {
        this.redisLockHelper = redisLockHelper;
        this.cacheKeyGenerator = cacheKeyGenerator;
    }
}

