/*
 * Decompiled with CFR 0.152.
 */
package com.product.dao;

import com.product.dao.AbstractMongodbDao;
import com.product.dao.AbstractMongodbTransactionDao;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.repository.support.PageableExecutionUtils;

public class SimpleMongodbDao<T>
extends AbstractMongodbTransactionDao<T> {
    private static final Logger log = LoggerFactory.getLogger(SimpleMongodbDao.class);

    public SimpleMongodbDao(Class<T> tClass, String primaryKeyName) {
        super(tClass, primaryKeyName);
    }

    public SimpleMongodbDao(Class<T> tClass, String primaryKeyName, String collectionName) {
        super(tClass, primaryKeyName, collectionName);
    }

    @Override
    public T save(T t) {
        return (T)this.mongodbTransactional((session, mongoTemplate) -> this.save(session, mongoTemplate, t));
    }

    @Override
    public Collection<T> saveBatch(List<T> tList) {
        return (Collection)this.mongodbTransactional((session, mongoTemplate) -> this.saveBatch(session, mongoTemplate, tList));
    }

    @Override
    public T updateByPrimaryKey(T t, String ... updateFields) {
        return (T)this.mongodbTransactional((session, mongoTemplate) -> {
            try {
                return this.updateByPrimaryKey(session, mongoTemplate, t, updateFields);
            }
            catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
                log.error("\u5806\u6808\u5f02\u5e38", (Throwable)e);
                return null;
            }
        });
    }

    @Override
    public T updateByCompoundIndex(T t, String compoundIndexName, String ... updateFields) {
        return (T)this.mongodbTransactional((session, mongoTemplate) -> {
            try {
                return this.updateByCompoundIndex(session, mongoTemplate, t, compoundIndexName, updateFields);
            }
            catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
                log.error("\u5806\u6808\u5f02\u5e38", (Throwable)e);
                return null;
            }
        });
    }

    @Override
    public List<T> updateBatchByPrimaryKey(List<T> ts, String ... updateFields) {
        return (List)this.mongodbTransactional((session, mongoTemplate) -> {
            try {
                return this.updateBatchByPrimaryKey(session, mongoTemplate, ts, updateFields);
            }
            catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
                log.error("\u5806\u6808\u5f02\u5e38", (Throwable)e);
                return null;
            }
        });
    }

    @Override
    public List<T> updateBatchByCompoundIndex(List<T> ts, String compoundIndexName, String ... updateFields) {
        return (List)this.mongodbTransactional((session, mongoTemplate) -> {
            try {
                return this.updateBatchByCompoundIndex(session, mongoTemplate, ts, compoundIndexName, updateFields);
            }
            catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
                log.error("\u5806\u6808\u5f02\u5e38", (Throwable)e);
                return null;
            }
        });
    }

    @Override
    public long updateBatchByCompoundIndex(T t, String compoundIndexName, String ... updateFields) {
        return (Long)this.mongodbTransactional((session, mongoTemplate) -> {
            try {
                return this.updateBatchByCompoundIndex(session, mongoTemplate, t, compoundIndexName, updateFields);
            }
            catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
                log.error("\u5806\u6808\u5f02\u5e38", (Throwable)e);
                return -1;
            }
        });
    }

    @Override
    public long removeByPrimaryKey(Object keyValue) {
        return (Long)this.mongodbTransactional((session, mongoTemplate) -> this.removeByPrimaryKey(session, mongoTemplate, keyValue));
    }

    @Override
    public void removeAll() {
        this.mongodbTransactional((session, mongoTemplate) -> {
            this.removeAll(session, mongoTemplate);
            return true;
        });
    }

    @Override
    public long removeByCompoundIndex(T t, String compoundIndexName) {
        return (Long)this.mongodbTransactional((session, mongoTemplate) -> {
            try {
                return this.removeByCompoundIndex(session, mongoTemplate, t, compoundIndexName);
            }
            catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
                log.error("\u5806\u6808\u5f02\u5e38", (Throwable)e);
                return -1;
            }
        });
    }

    @Override
    public long remove(Query query) {
        return (Long)this.mongodbTransactional((session, mongoTemplate) -> this.remove(session, mongoTemplate, query));
    }

    @Override
    public T findByPrimaryKey(Object keyValue) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)this.getPrimaryKeyName()).is(keyValue));
        if (StringUtils.isNotBlank((CharSequence)this.getCollectionName())) {
            return (T)this.mongoTemplate.findOne(query, this.gettClass(), this.getCollectionName());
        }
        return (T)this.mongoTemplate.findOne(query, this.gettClass());
    }

    @Override
    public T findByCompoundIndexName(T t, String compoundIndexName) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        Query query = this.buildQuery(t, compoundIndexName, this.gettClass());
        if (StringUtils.isNotBlank((CharSequence)this.getCollectionName())) {
            return (T)this.mongoTemplate.findOne(query, this.gettClass(), this.getCollectionName());
        }
        return (T)this.mongoTemplate.findOne(query, this.gettClass());
    }

    @Override
    public List<T> findListByCompoundIndexName(T t, String compoundIndexName) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        Query query = this.buildQuery(t, compoundIndexName, this.gettClass());
        if (StringUtils.isNotBlank((CharSequence)this.getCollectionName())) {
            return this.mongoTemplate.find(query, this.gettClass(), this.getCollectionName());
        }
        return this.mongoTemplate.find(query, this.gettClass());
    }

    @Override
    public List<T> queryCustom(AbstractMongodbDao.MongoJson mongoJson) {
        Query query = this.buildQuery(mongoJson);
        return this.queryCustom(query);
    }

    @Override
    public List<T> queryCustom(Query query) {
        if (StringUtils.isNotBlank((CharSequence)this.getCollectionName())) {
            return this.mongoTemplate.find(query, this.gettClass(), this.getCollectionName());
        }
        return this.mongoTemplate.find(query, this.gettClass());
    }

    @Override
    public AbstractMongodbDao.MPage<T> queryTPage(Query query, int pageIndex, int pageSize) {
        PageRequest pageable = PageRequest.of((int)(--pageIndex), (int)pageSize);
        String tableName = "";
        tableName = StringUtils.isNotBlank((CharSequence)tableName) ? this.getCollectionName() : this.mongoTemplate.getCollectionName(this.gettClass());
        long count = this.mongoTemplate.count(query, this.gettClass(), tableName);
        query.with((Pageable)pageable);
        List tList = this.mongoTemplate.find(query, this.gettClass(), tableName);
        return this.wrap((PageImpl)PageableExecutionUtils.getPage((List)tList, (Pageable)pageable, () -> count));
    }

    @Override
    public AbstractMongodbDao.MPage<T> queryCustomTPage(AbstractMongodbDao.MongoJson mongoJson) {
        int pageIndex = mongoJson.getPageIndex();
        int pageSize = mongoJson.getPageSize();
        Query query = this.buildQuery(mongoJson);
        return this.queryTPage(query, pageIndex, pageSize);
    }
}

