/*
 * Decompiled with CFR 0.152.
 */
package com.product.datasource;

import com.shiji.core.utils.StringUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DatabaseConfig {
    private static final Map<String, String> DB_DRIVER_MAP = new HashMap<String, String>();
    private static final Map<String, String> DB_JDBC_URL_MAP = new HashMap<String, String>();
    private static final Map<String, String> DB_TESTSQL_MAP = new HashMap<String, String>();
    private static final Map<String, String> DB_TABLELISTSQL_MAP = new HashMap<String, String>();
    private static final Map<String, String> DB_TABLEINFOSQL_MAP = new HashMap<String, String>();
    private static final Map<String, String> DATABASE_TYPE_MAPPING = new HashMap<String, String>();

    public static String getDriverClassName(String databaseType) {
        return DB_DRIVER_MAP.get(databaseType);
    }

    public static String getJdbcUrlTemplate(String databaseType) {
        return DB_JDBC_URL_MAP.get(databaseType);
    }

    public static String getTestSQL(String databaseType) {
        return DB_TESTSQL_MAP.get(databaseType);
    }

    public static String getTableListSQL(String databaseType) {
        return DB_TABLELISTSQL_MAP.get(databaseType);
    }

    public static String getDatabaseTypeFromJdbcUrl(String jdbcUrl) {
        for (String prefix : DATABASE_TYPE_MAPPING.keySet()) {
            if (!jdbcUrl.startsWith(prefix)) continue;
            return DATABASE_TYPE_MAPPING.get(prefix);
        }
        return null;
    }

    public static String getSchemaFromJdbcUrl(String jdbcUrl) {
        String schema = null;
        String dbtype = DatabaseConfig.getDatabaseTypeFromJdbcUrl(jdbcUrl);
        if ("dm".equals(dbtype)) {
            String url = jdbcUrl.split("\\?")[1];
            if (!StringUtil.isEmpty((String)url)) {
                String[] parts = url.split("&");
                String temp = Arrays.stream(parts).filter(e -> e.indexOf("SCHEMA") >= 0 || e.indexOf("schema") >= 0).findFirst().get();
                return temp.split("=")[1];
            }
        } else {
            String[] parts = jdbcUrl.split("/", 4);
            if (parts.length >= 4) {
                schema = parts[3].split("\\?")[0];
            }
        }
        return schema;
    }

    public static String getIpFromJdbcUrl(String jdbcUrl) {
        String url = jdbcUrl.split("\\?")[0];
        String[] parts = url.split("/", 4);
        return parts[2].split(":")[0];
    }

    public static int getPortFromJdbcUrl(String jdbcUrl) {
        String url = jdbcUrl.split("\\?")[0];
        String[] parts = url.split("/", 4);
        return Integer.parseInt(parts[2].split(":")[1]);
    }

    public static String extractServerTimezone(String jdbcUrl) {
        String serverTimezone = null;
        String[] parts = jdbcUrl.split("\\?");
        if (parts.length > 1) {
            String[] queryParams;
            String queryString = parts[1];
            for (String queryParam : queryParams = queryString.split("&")) {
                String[] paramParts = queryParam.split("=");
                if (paramParts.length != 2 || !paramParts[0].equals("serverTimezone")) continue;
                serverTimezone = paramParts[1];
                break;
            }
        }
        return serverTimezone;
    }

    static {
        DB_DRIVER_MAP.put("mysql", "com.mysql.cj.jdbc.Driver");
        DB_DRIVER_MAP.put("oracle", "oracle.jdbc.driver.OracleDriver");
        DB_DRIVER_MAP.put("dm", "dm.jdbc.driver.DmDriver");
        DB_DRIVER_MAP.put("sqlserver", "com.microsoft.sqlserver.jdbc.SQLServerDriver");
        DB_JDBC_URL_MAP.put("mysql", "jdbc:mysql://%1$s:%2$s/%3$s?useSSL=false&useUnicode=true&characterEncoding=utf8&autoReconnect=true&allowMultiQueries=true&useAffectedRows=true&allowPublicKeyRetrieval=true");
        DB_JDBC_URL_MAP.put("oracle", "jdbc:oracle:thin:@%1$s:%2$s/%3$s");
        DB_JDBC_URL_MAP.put("dm", "jdbc:dm://%1$s:%2$s?SCHEMA=%3$s");
        DB_JDBC_URL_MAP.put("sqlserver", "jdbc:sqlserver://%1$s:%2$s;databaseName=%3$s;encrypt=false;trustServerCertificate=true");
        DATABASE_TYPE_MAPPING.put("jdbc:mysql:", "mysql");
        DATABASE_TYPE_MAPPING.put("jdbc:oracle:", "oracle");
        DATABASE_TYPE_MAPPING.put("jdbc:dm:", "dm");
        DATABASE_TYPE_MAPPING.put("jdbc:sqlserver:", "sqlserver");
        DB_TESTSQL_MAP.put("mysql", "select 1");
        DB_TESTSQL_MAP.put("oracle", "select 1 from dual");
        DB_TABLELISTSQL_MAP.put("mysql", "select table_name TABLE_NAME, table_comment COMMENTS from information_schema.tables where table_schema='%1$s' AND TABLE_TYPE='BASE TABLE'");
        DB_TABLELISTSQL_MAP.put("oracle", "SELECT TABLE_NAME,TABLE_NAME as table_comment FROM all_tables where owner='%1$s'");
        DB_TABLELISTSQL_MAP.put("sqlserver", "SELECT o.name TABLE_NAME,o.name TABLE_COMMENT FROM sys.objects o JOIN sys.schemas s ON o.schema_id = s.schema_id WHERE s.name = '%1$s' AND o.type = 'U'");
        DB_TABLEINFOSQL_MAP.put("mysql", "select COLUMN_NAME,DATA_TYPE,COLUMN_COMMENT from information_schema.columns where TABLE_SCHEMA='%1$s' and TABLE_NAME='%2$s'");
        DB_TABLEINFOSQL_MAP.put("oracle", "SELECT column_name, data_type FROM all_tab_columns WHERE owner = '%1$s' and table_name = '%2$s'");
        DB_TABLEINFOSQL_MAP.put("sqlserver", "SELECT   COLUMN_NAME,  DATA_TYPE FROM  INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '%1$s' AND TABLE_NAME = '%2$s'   ");
    }
}

