/*
 * Decompiled with CFR 0.152.
 */
package com.product.mybatisplus.component;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.product.exception.ServiceRuntimeException;
import com.product.model.BaseQueryModel;
import com.product.model.BeanConstant;
import com.product.model.ServiceResponse;
import com.product.mybatisplus.mapper.CommonMapper;
import com.product.util.CopyUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public abstract class MybatisPlusServiceImpl<M extends CommonMapper<T>, T>
extends ServiceImpl<CommonMapper<T>, T> {
    @Autowired
    protected M commonMapper;
    private Class<T> entityClass;

    public MybatisPlusServiceImpl() {
        Type[] types = ((ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass()).getActualTypeArguments();
        this.entityClass = (Class)types[1];
    }

    public ServiceResponse onQuery(T entityVo) {
        if (!(entityVo instanceof BaseQueryModel)) {
            throw new RuntimeException("\u5b9e\u4f53\u7c7b" + this.entityClass.getName() + "\u672a\u7ee7\u627fBaseQueryModel");
        }
        BaseQueryModel pageCondition = (BaseQueryModel)entityVo;
        T entity = CopyUtil.copy(entityVo, this.entityClass);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.setEntity(entity);
        if (!StringUtils.isEmpty((Object)pageCondition.getOrder_direction()) && "desc".equals(pageCondition.getOrder_direction().toLowerCase())) {
            queryWrapper.orderByDesc((Object)pageCondition.getOrder_field());
        } else {
            queryWrapper.orderByAsc((Object)pageCondition.getOrder_field());
        }
        Page page = null != pageCondition.getPage_no() && null != pageCondition.getPage_size() ? new Page((long)pageCondition.getPage_no().intValue(), (long)pageCondition.getPage_size().intValue()) : new Page((long)BeanConstant.QueryPage.DEFAULT_PAGENO.intValue(), (long)BeanConstant.QueryPage.DEFAULT_PAGESIZE.intValue());
        page = this.commonMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        JSONObject resultJson = new JSONObject();
        resultJson.put(this.getTableName(), (Object)page.getRecords());
        resultJson.put("total_results", (Object)page.getTotal());
        return ServiceResponse.buildSuccess((Object)resultJson);
    }

    public ServiceResponse onInsert(T entityVo) {
        int result = this.commonMapper.insert(entityVo);
        try {
            if (result == 1) {
                JSONObject resultJson = new JSONObject();
                resultJson.put(this.getPrimaryKeyName(entityVo), (Object)this.getPrimaryKeyValue(entityVo));
                return ServiceResponse.buildSuccess((Object)resultJson);
            }
            return ServiceResponse.buildFailure(null, (String)"10000", (String)"\u65b0\u589e\u5931\u8d25!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ServiceResponse.buildFailure(null, (String)"10000", (String)("\u65b0\u589e\u5931\u8d25->" + e.getMessage()));
        }
    }

    public ServiceResponse onUpdate(T entityVo) {
        try {
            this.checkIdExists(entityVo);
            int result = this.commonMapper.updateById(entityVo);
            if (result >= 0) {
                JSONObject resultJson = new JSONObject();
                resultJson.put(this.getPrimaryKeyName(entityVo), (Object)this.getPrimaryKeyValue(entityVo));
                return ServiceResponse.buildSuccess((Object)resultJson);
            }
            return ServiceResponse.buildFailure(null, (String)"10000", (String)"\u66f4\u65b0\u5931\u8d25!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ServiceResponse.buildFailure(null, (String)"10000", (String)("\u66f4\u65b0\u5931\u8d25->" + e.getMessage()));
        }
    }

    public ServiceResponse onSave(T entityVo) {
        T entity;
        Object entityFull = entity = CopyUtil.copy(entityVo, this.entityClass);
        Object id = null;
        String keyName = null;
        try {
            ArrayList<String> ignoreProperties = new ArrayList<String>();
            for (Field field : entity.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                String fieldName = field.getName();
                Object fieldValue = field.get(entity);
                if (field.isAnnotationPresent(TableId.class)) {
                    keyName = fieldName;
                    if (!StringUtils.isEmpty((Object)fieldValue)) {
                        id = fieldValue;
                        entityFull = this.commonMapper.selectById((Serializable)id);
                    }
                }
                if (null != fieldValue) continue;
                ignoreProperties.add(fieldName);
            }
            BeanUtils.copyProperties(entity, entityFull, (String[])ignoreProperties.toArray(new String[0]));
            int n = StringUtils.isEmpty(id) ? this.commonMapper.insert(entityFull) : this.commonMapper.updateById(entityFull);
            String keyValue = this.getPrimaryKeyValue(entityFull);
            JSONObject resultJson = new JSONObject();
            resultJson.put(keyName, (Object)keyValue);
            return ServiceResponse.buildSuccess((Object)resultJson);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ServiceResponse.buildFailure(null, (String)"10000", (String)("\u4fdd\u5b58\u5931\u8d25->" + e.getMessage()));
        }
    }

    public ServiceResponse onDelete(T entityVo) {
        try {
            this.checkIdExists(entityVo);
            String id = this.getPrimaryKeyValue(entityVo);
            int result = this.commonMapper.deleteById((Serializable)((Object)id));
            if (result >= 0) {
                JSONObject resultJson = new JSONObject();
                resultJson.put(this.getPrimaryKeyName(entityVo), (Object)id);
                return ServiceResponse.buildSuccess((Object)resultJson);
            }
            return ServiceResponse.buildFailure(null, (String)"10000", (String)"\u5220\u9664\u5931\u8d25!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ServiceResponse.buildFailure(null, (String)"10000", (String)("\u5220\u9664\u5931\u8d25->" + e.getMessage()));
        }
    }

    public ServiceResponse onBatchInsert(Collection<T> entryList) {
        boolean status = this.saveBatch(entryList);
        if (status) {
            return ServiceResponse.buildSuccess((Object)"\u64cd\u4f5c\u6210\u529f\uff01");
        }
        return ServiceResponse.buildSuccess((Object)"\u64cd\u4f5c\u5931\u8d25\uff01");
    }

    public ServiceResponse onBatchSave(Collection<T> entryList) {
        boolean status = this.saveOrUpdateBatch(entryList);
        if (status) {
            return ServiceResponse.buildSuccess((Object)"\u64cd\u4f5c\u6210\u529f\uff01");
        }
        return ServiceResponse.buildSuccess((Object)"\u64cd\u4f5c\u5931\u8d25\uff01");
    }

    private String getTableName() {
        TableName anno = this.entityClass.getAnnotation(TableName.class);
        String tableName = anno.value();
        return tableName.toLowerCase();
    }

    private String getPrimaryKeyName(T entity) {
        String fieldName = null;
        try {
            for (Field field : entity.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                if (!field.isAnnotationPresent(TableId.class)) continue;
                fieldName = field.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fieldName;
    }

    private String getPrimaryKeyValue(T entity) {
        String id = null;
        try {
            for (Field field : entity.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                String fieldName = field.getName();
                Object fieldValue = field.get(entity);
                if (!field.isAnnotationPresent(TableId.class) || StringUtils.isEmpty((Object)fieldValue)) continue;
                id = String.valueOf(fieldValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    public void checkIdExists(T entity) {
        String name = this.getPrimaryKeyName(entity);
        String id = this.getPrimaryKeyValue(entity);
        if (StringUtils.isEmpty((Object)id)) {
            throw new ServiceRuntimeException("10000", String.format("\u4e3b\u952e[%s]\u503c\u4e0d\u80fd\u4e3a\u7a7a", name));
        }
    }
}

