/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.slice.filter.standard;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.fastjson.JSONObject;
import com.product.storage.slice.filter.standard.CollectionInsertWrapper;
import com.product.util.SpringContext;
import com.product.util.StatisticUtils;
import com.product.util.UniqueID;
import java.util.List;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSliceExecutorWrapper
extends CollectionInsertWrapper
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(BaseSliceExecutorWrapper.class);

    public Object intercept(Invocation invocation) throws Throwable {
        if (SpringContext.getActiveProfile().equals("local")) {
            return invocation.proceed();
        }
        long interceptID = UniqueID.getUniqueID();
        long startTime = System.currentTimeMillis();
        long threadId = Thread.currentThread().getId();
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[MAPPED_STATEMENT_INDEX];
        String sqlStatement = "";
        Object parameter = null;
        if (invocation.getArgs().length > 1) {
            parameter = invocation.getArgs()[PARAMETER_INDEX];
        }
        BoundSql boundSql = mappedStatement.getBoundSql(parameter);
        String sqlId = mappedStatement.getId();
        Configuration configuration = mappedStatement.getConfiguration();
        if (invocation.getArgs().length == 6) {
            boundSql = (BoundSql)invocation.getArgs()[BOUNDSQL_INDEX];
        }
        sqlStatement = boundSql.getSql();
        log.debug(String.format("intercept(%1$d)--->1--->%2$s--->%3$s", interceptID, "\u8fdb\u5165\u5206\u7247\u62e6\u622a\u5668", sqlStatement.replaceAll("[\\s]+", " ")));
        if (!this.isIntercept(sqlStatement)) {
            log.info("ThreadId->{}InterceptID->{}:2\u3001---->ExecutorSliceNewWrapper:{}", new Object[]{threadId, interceptID, sqlStatement.replaceAll("[\\s]+", " ")});
            return invocation.proceed();
        }
        try {
            JSONObject logJson = new JSONObject();
            List statementList = SQLUtils.toStatementList((String)sqlStatement, (String)this.getDbType());
            for (SQLStatement stmt : statementList) {
                logJson.put("selectSql", (Object)sqlStatement);
                if (stmt instanceof SQLSelectStatement) {
                    log.info("ThreadId->{}InterceptID->{}:3\u3001---->ExecutorSliceNewWrapper\u5f00\u59cb\u5206\u7247\u5904\u7406", (Object)threadId, (Object)interceptID);
                    this.onStatement(log, sqlStatement, logJson, invocation, mappedStatement, boundSql, stmt);
                    continue;
                }
                if (stmt instanceof SQLInsertStatement) {
                    log.debug(String.format("intercept(%1$d)--->4--->SqlType--->1--->%2$s", interceptID, "SQLInsertStatement"));
                    this.onInsertStatement(log, logJson, invocation, mappedStatement, boundSql, stmt);
                    continue;
                }
                if (stmt instanceof SQLUpdateStatement) {
                    log.debug(String.format("intercept(%1$d)--->5--->SqlType--->1--->%2$s", interceptID, "SQLUpdateStatement"));
                    this.onUpdateStatement(log, logJson, invocation, mappedStatement, boundSql, stmt);
                    continue;
                }
                if (!(stmt instanceof SQLDeleteStatement)) continue;
                log.debug(String.format("intercept(%1$d)--->6--->SqlType--->1--->%2$s", interceptID, "SQLDeleteStatement"));
                this.onDeleteStatement(log, logJson, invocation, mappedStatement, boundSql, stmt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("ThreadId->{}InterceptID->{}:7\u3001---->ExecutorSliceNewWrapper\u6267\u884c\u5206\u7247\u5904\u7406\u5f02\u5e38", (Object)threadId, (Object)interceptID);
            invocation.getArgs()[0] = mappedStatement;
            JSONObject errorJson = new JSONObject();
            errorJson.put("unresolved sql", (Object)sqlStatement);
            log.error(errorJson.toJSONString());
        }
        long endTime = System.currentTimeMillis();
        log.info("mybatis\u5206\u7247\u7ec4\u88c5\u8017\u8d39\u65f6\u95f4:----{} --->{}", (Object)(startTime - endTime), (Object)StatisticUtils.onDescibeMethod());
        long start = System.currentTimeMillis();
        Object response = invocation.proceed();
        long end = System.currentTimeMillis();
        long execTime = end - start;
        this.printSlowLog(configuration, boundSql, sqlId, execTime);
        return response;
    }
}

