/*
 * Decompiled with CFR 0.152.
 */
package com.product.timezone;

import com.product.model.ServiceSession;
import com.product.util.SpringContext;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class TimeZoneUtil {
    private static final Logger log = LoggerFactory.getLogger(TimeZoneUtil.class);
    public static ThreadLocal<String> timeZoneThreadLocal = new ThreadLocal();

    public static void initTimeZone(String curTimeZone, ServiceSession contextSession) {
        if ("true".equals(SpringContext.getEnvironment().getProperty("db.cross_timezone.enabled"))) {
            log.info("### \u5ba2\u6237\u7aef\u5f53\u524d\u65f6\u533a:{}", (Object)curTimeZone);
            if (StringUtils.isEmpty((Object)curTimeZone)) {
                log.error("\u3010Serious\u3011\u5f53\u524dHTTP URL\u4e2d\u672a\u8bbe\u7f6e\u65f6\u533a\u53c2\u6570timeZone!");
            } else {
                TimeZoneUtil.setCurrentTimeZone(curTimeZone);
                contextSession.setTimeZone(curTimeZone);
            }
        }
    }

    public static void setCurrentTimeZone(String curtimeZone) {
        timeZoneThreadLocal.set(curtimeZone);
    }

    public static String getCurrentTimeZone() {
        return timeZoneThreadLocal.get();
    }

    public static void removeCurrentTimeZone() {
        if ("true".equals(SpringContext.getEnvironment().getProperty("db.cross_timezone.enabled"))) {
            timeZoneThreadLocal.remove();
        }
    }

    public static String getTimeZoneOffSet(String curtimeZone) {
        ZoneId zoneId = ZoneId.of(curtimeZone);
        ZonedDateTime now = ZonedDateTime.now(zoneId);
        long offsetMillis = now.getOffset().getTotalSeconds() * 1000;
        int offsetHours = (int)(offsetMillis / 3600000L) % 24;
        int offsetMinutes = (int)(offsetMillis / 60000L) % 60;
        String formattedOffset = String.format("%s%02d:%02d", offsetHours >= 0 ? "+" : "-", Math.abs(offsetHours), Math.abs(offsetMinutes));
        log.info("\u5f53\u524d\u65f6\u533a:" + curtimeZone + ", \u4e0eUTC\u65f6\u533a\u7684\u504f\u79fb\u91cf\uff1a" + formattedOffset);
        return formattedOffset;
    }

    public static void setJavaThreadTimeZone() {
        String curtimeZone = TimeZoneUtil.getCurrentTimeZone();
        if (StringUtils.isEmpty((Object)curtimeZone)) {
            log.error("\u3010Serious\u3011\u4ece\u7ebf\u7a0b\u53d8\u91cf\u4e2d\u83b7\u53d6\u65f6\u533a\u9519\u8bef!");
        } else {
            TimeZone timeZone = TimeZone.getTimeZone(curtimeZone);
            TimeZone.setDefault(timeZone);
            Date currentDate = new Date();
            String formattedDate = currentDate.toString();
            log.info("\u8bbe\u7f6ejava\u7ebf\u7a0b\u5f53\u524d\u65f6\u533a(" + curtimeZone + "), \u65e5\u671f\uff1a" + formattedDate);
        }
    }
}

