/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import com.product.exception.ServiceRuntimeException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.time.DateUtils;

public class DateTimeFormatUtil {
    private static final SimpleDateFormat standstandardDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat standstandardDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat standstandardTimeFormat = new SimpleDateFormat("HH:mm:ss");
    public static final SimpleDateFormat dayStartDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
    public static final SimpleDateFormat dayEndDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd 23:59:59");

    private DateTimeFormatUtil() {
    }

    public static String nowToDateTime() {
        return DateTimeFormatUtil.toDateTime(new Date());
    }

    public static String toDateTime(Date dateTime) {
        return DateTimeFormatUtil.toDateTime(dateTime, standstandardDateTimeFormat);
    }

    public static String toDateTime(Date dateTime, DateFormat dateFormat) {
        return dateTime == null ? "" : dateFormat.format(dateTime);
    }

    public static String nowToDate() {
        return DateTimeFormatUtil.toDate(new Date());
    }

    public static String toDate(Date dateTime) {
        return DateTimeFormatUtil.toDateTime(dateTime, standstandardDateFormat);
    }

    public static String nowToTime() {
        return DateTimeFormatUtil.toDateTime(new Date());
    }

    public static String toTime(Date dateTime) {
        return DateTimeFormatUtil.toDateTime(dateTime, standstandardTimeFormat);
    }

    public static String format(Date date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return DateTimeFormatUtil.toDateTime(date, dateFormat);
    }

    public static Date parseDate(String dateTime) {
        try {
            return standstandardDateTimeFormat.parse(dateTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new ServiceRuntimeException("\u65f6\u95f4\u8f6c\u6362\u51fa\u9519");
        }
    }

    public static int daysBetween(Date smdate, Date bdate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        int daysBetween = Integer.parseInt(String.valueOf(between_days));
        return daysBetween;
    }

    public static int getExpiryDays(Date endDate) {
        if (endDate != null) {
            Date date = new Date();
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            Date expiryDate = calendar.getTime();
            int days = DateTimeFormatUtil.daysBetween(expiryDate, endDate);
            return days;
        }
        return 9999;
    }

    public static Date dateTruncate(Date currentDate) {
        if (currentDate != null) {
            Date date = new Date();
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            Date lastDate = calendar.getTime();
            return lastDate;
        }
        return currentDate;
    }

    public static Date dateAdd(Date currentDate, int days) {
        if (currentDate != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(currentDate);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            ((Calendar)calendar).add(5, days);
            Date lastDate = calendar.getTime();
            return lastDate;
        }
        return currentDate;
    }

    public static String getMonthFristDay() {
        Calendar c = Calendar.getInstance();
        c.add(2, 0);
        c.set(5, 1);
        String first = standstandardDateFormat.format(c.getTime());
        return first;
    }

    public static String getMonthLastDay() {
        Calendar ca = Calendar.getInstance();
        ca.set(5, ca.getActualMaximum(5));
        String last = standstandardDateFormat.format(ca.getTime());
        return last;
    }

    public static Date getMonthFristDay(String month) throws Exception {
        Date date = standstandardDateFormat.parse(month + "-01");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), 1);
        return calendar.getTime();
    }

    public static Date getLastMonthFristDay(Date date) throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.add(2, 1);
        return calendar.getTime();
    }

    public static Date getMonthLastDay(String month) throws Exception {
        Date date = standstandardDateFormat.parse(month + "-01");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 0);
        return calendar.getTime();
    }

    public static int getBetweenMonth(Date start, Date end) {
        if (start.after(end)) {
            Date t = start;
            start = end;
            end = t;
        }
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        Calendar temp = Calendar.getInstance();
        temp.setTime(end);
        temp.add(5, 1);
        int year = endCalendar.get(1) - startCalendar.get(1);
        int month = endCalendar.get(2) - startCalendar.get(2);
        if (startCalendar.get(5) == 1 && temp.get(5) == 1) {
            return year * 12 + month + 1;
        }
        if (startCalendar.get(5) != 1 && temp.get(5) == 1) {
            return year * 12 + month;
        }
        if (startCalendar.get(5) == 1 && temp.get(5) != 1) {
            return year * 12 + month;
        }
        return year * 12 + month - 1 < 0 ? 0 : year * 12 + month;
    }

    public static double getDoublebetweenMonths(Date startDate, Date endDate) {
        endDate = DateTimeFormatUtil.dateAdd(endDate, 1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        int startDayOfMonth = cal.get(5);
        int startMonth = cal.get(2);
        int startYear = cal.get(1);
        cal.setTime(endDate);
        int endDayOfMonth = cal.get(5);
        int endMonth = cal.get(2);
        int endYear = cal.get(1);
        int diffMonths = endMonth - startMonth;
        int diffYears = endYear - startYear;
        int diffDays = endDayOfMonth - startDayOfMonth;
        return (double)(diffYears * 12 + diffMonths) + (double)diffDays / 31.0;
    }

    public static double betweenMonths(Date endDate, Date startDate) {
        endDate = DateUtils.addDays((Date)endDate, (int)1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        int startDayOfMonth = cal.get(5);
        int startMonth = cal.get(2);
        int startYear = cal.get(1);
        cal.setTime(endDate);
        int endDayOfMonth = cal.get(5);
        int endMonth = cal.get(2);
        int endYear = cal.get(1);
        int diffMonths = endMonth - startMonth;
        int diffYears = endYear - startYear;
        int diffDays = endDayOfMonth - startDayOfMonth;
        return (double)(diffYears * 12 + diffMonths) + (double)diffDays / 31.0;
    }

    public static int getDaysOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getActualMaximum(5);
    }

    public static String getNextMonth(String startMonth, String pattern) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String currentMonth = startMonth;
        Date currentDate = sdf.parse(currentMonth);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.set(2, calendar.get(2) + 1);
        return sdf.format(calendar.getTime());
    }

    public static String longTimeToDay(Date sdate, Date edate) {
        Long startLong = sdate.getTime();
        Long endLong = edate.getTime();
        Long ms = endLong - startLong;
        Integer ss = 1000;
        Integer mi = ss * 60;
        Integer hh = mi * 60;
        Integer dd = hh * 24;
        Long day = ms / (long)dd.intValue();
        Long hour = (ms - day * (long)dd.intValue()) / (long)hh.intValue();
        Long minute = (ms - day * (long)dd.intValue() - hour * (long)hh.intValue()) / (long)mi.intValue();
        Long second = (ms - day * (long)dd.intValue() - hour * (long)hh.intValue() - minute * (long)mi.intValue()) / (long)ss.intValue();
        Long milliSecond = ms - day * (long)dd.intValue() - hour * (long)hh.intValue() - minute * (long)mi.intValue() - second * (long)ss.intValue();
        StringBuffer sb = new StringBuffer();
        if (day > 0L) {
            sb.append(day + "\u5929");
        }
        if (hour > 0L) {
            sb.append(hour + "\u5c0f\u65f6");
        }
        if (minute > 0L) {
            sb.append(minute + "\u5206");
        }
        if (second > 0L) {
            sb.append(second + "\u79d2");
        }
        if (milliSecond > 0L) {
            sb.append(milliSecond + "\u6beb\u79d2");
        }
        return sb.toString();
    }
}

