/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import com.alibaba.fastjson.JSONObject;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FreemarkerUtil {
    private static final Logger log = LoggerFactory.getLogger(FreemarkerUtil.class);
    @Autowired
    private Configuration configuration;
    private static Configuration freemarkerConfig = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);

    public static String escapeString(String originStr) {
        return originStr.replaceAll("\u4e95", "\\#").replaceAll("\uffe5", "\\$");
    }

    public static String processTemplateIntoStirng(Template template, Object model) throws TemplateException, IOException {
        StringWriter result = new StringWriter();
        template.process(model, (Writer)result);
        return result.toString();
    }

    public static String processString(String templateName, Map<String, Object> params) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException, TemplateException {
        Template template = freemarkerConfig.getTemplate(templateName);
        String htmlText = FreemarkerUtil.escapeString(FreemarkerUtil.processTemplateIntoStirng(template, params));
        return htmlText;
    }

    public static String genarateByTemplatePath(JSONObject json, String tempCode, String tempPath) throws Exception {
        StringWriter writer = new StringWriter();
        Configuration cfg = new Configuration();
        cfg.setDirectoryForTemplateLoading(new File(tempPath));
        cfg.setDefaultEncoding("UTF-8");
        Template template = cfg.getTemplate(tempCode, "utf-8");
        template.process((Object)json, (Writer)writer);
        writer.flush();
        String html = writer.toString();
        return html;
    }

    static {
        try {
            freemarkerConfig.setClassForTemplateLoading(FreemarkerUtil.class, "/templates");
            freemarkerConfig.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(FreemarkerUtil.class, "/templates"));
            freemarkerConfig.setNumberFormat("#");
            freemarkerConfig.setClassicCompatible(true);
            freemarkerConfig.setDefaultEncoding("UTF-8");
            freemarkerConfig.setLocale(Locale.CHINA);
            freemarkerConfig.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

