/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import com.alibaba.fastjson.JSON;
import com.product.model.ServiceResponse;
import com.product.model.UrlConfigBean;
import com.product.util.RestClientApacheFactory;
import com.product.util.SpringBeanFactory;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.EvictionConfig;
import org.apache.commons.pool2.impl.EvictionPolicy;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RestApacheUtils {
    private static final Logger log = LoggerFactory.getLogger(RestApacheUtils.class);
    private DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private String username;
    private String password;
    private ObjectPool<Client> poolInstance = null;

    public RestApacheUtils(String username, String password) {
        this.username = username;
        this.password = password;
    }

    private void traceInfo(String title, GenericObjectPool<Client> underTest) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.format("RestApacheUtils.CurrentDate:%1$s ", this.format.format(new Date())));
        buffer.append(String.format("title:%1$s ", title));
        buffer.append(String.format("BorrowedCount:%1$d ", underTest.getBorrowedCount()));
        buffer.append(String.format("CreatedCount:%1$d ", underTest.getCreatedCount()));
        buffer.append(String.format("DestroyedCount:%1$d ", underTest.getDestroyedCount()));
        buffer.append(String.format("MaxBorrowWaitTimeMillis:%1$d ", underTest.getMaxBorrowWaitTimeMillis()));
        buffer.append(String.format("NumActive:%1$d ", underTest.getNumActive()));
        buffer.append(String.format("NumIdle:%1$d ", underTest.getNumIdle()));
        buffer.append(String.format("NumWaiters:%1$d ", underTest.getNumWaiters()));
        buffer.append(String.format("ReturnedCount:%1$d", underTest.getReturnedCount()));
        log.info(buffer.toString());
    }

    private synchronized void initClientPool() {
        if (this.poolInstance == null) {
            int poolSize = 1000;
            int maxWait = 5000;
            GenericObjectPoolConfig poolcfg = new GenericObjectPoolConfig();
            poolcfg.setLifo(true);
            poolcfg.setFairness(false);
            if (poolSize > 0) {
                poolcfg.setMaxTotal(poolSize);
                poolcfg.setMaxIdle(poolSize);
                poolcfg.setMinIdle(poolSize >= 2 ? poolSize / 2 : poolSize);
            }
            if (maxWait > 0) {
                poolcfg.setMaxWaitMillis((long)maxWait);
                poolcfg.setBlockWhenExhausted(true);
            }
            poolcfg.setTestOnCreate(false);
            poolcfg.setTestOnBorrow(false);
            poolcfg.setTestOnReturn(false);
            poolcfg.setTestWhileIdle(false);
            poolcfg.setSoftMinEvictableIdleTimeMillis(-1L);
            poolcfg.setNumTestsPerEvictionRun(3);
            poolcfg.setMinEvictableIdleTimeMillis(1800000L);
            poolcfg.setTimeBetweenEvictionRunsMillis(-1L);
            poolcfg.setNumTestsPerEvictionRun(3);
            this.poolInstance = new GenericObjectPool<Client>((PooledObjectFactory)new RestClientApacheFactory(this.username, this.password), poolcfg){

                public Client borrowObject() throws Exception {
                    RestApacheUtils.this.traceInfo("borrowObject", (GenericObjectPool<Client>)this);
                    return (Client)super.borrowObject();
                }
            };
            EvictionPolicy<Client> evictionPolicy = new EvictionPolicy<Client>(){

                public boolean evict(EvictionConfig config, PooledObject<Client> underTest, int idleCount) {
                    log.error("EvictionPolicy.evict");
                    if (underTest instanceof GenericObjectPool) {
                        RestApacheUtils.this.traceInfo("evictionPolicy", (GenericObjectPool<Client>)((GenericObjectPool)underTest));
                    }
                    return config.getIdleSoftEvictTime() < underTest.getIdleTimeMillis() && config.getMinIdle() < idleCount || config.getIdleEvictTime() < underTest.getIdleTimeMillis();
                }
            };
            poolcfg.setEvictionPolicy((EvictionPolicy)evictionPolicy);
        }
    }

    public ObjectPool<Client> getClientPool() {
        if (this.poolInstance == null) {
            this.initClientPool();
        }
        return this.poolInstance;
    }

    public void close() {
        this.getClientPool().close();
    }

    public String doPost(String remoteURL, String value) throws Exception {
        return this.doPost(remoteURL, null, null, value, String.class);
    }

    public String doPost(String remoteURL, MultivaluedMap<String, String> params, String value) throws Exception {
        return this.doPost(remoteURL, params, null, value, String.class);
    }

    public <T> T doPost(String remoteURL, MultivaluedMap<String, String> params, String value, Class<T> classzz) throws Exception {
        return this.doPost(remoteURL, params, null, value, classzz);
    }

    public String onQueryServiceURI(String remoteURL, MultivaluedMap<String, String> params) throws Exception {
        log.info("onQueryServiceURI({},{})", (Object)remoteURL, params);
        if (remoteURL.startsWith("${") && remoteURL.endsWith("}")) {
            log.info("start query service env...");
            UrlConfigBean urlConfigBean = (UrlConfigBean)SpringBeanFactory.getBean("omni.serviceEnvQuery");
            if (urlConfigBean == null) {
                log.info("not config Bean:[omni.serviceEnvQuery]...");
                StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
                StringBuffer buffer = new StringBuffer();
                buffer.append(String.format("query:%1$s parameter:%2$s", remoteURL, params) + "\r\n");
                for (int i = 1; i < stacks.length; ++i) {
                    String trackInfo = stacks[i].toString();
                    buffer.append("\r\n" + trackInfo);
                }
                log.info(String.format("-------------------------------\r\n%1$s\r\n===============================\r\n", buffer.toString()));
                throw new Exception("\u672a\u914d\u7f6e\u670d\u52a1\u5de5\u5382\u5730\u5740\u7684Bean:[omni.serviceEnvQuery].");
            }
            params.add((Object)"service", (Object)remoteURL);
            String result = this.doGet(urlConfigBean.getRemoteURL(), params, null, String.class);
            ServiceResponse response = (ServiceResponse)JSON.parseObject((String)result, ServiceResponse.class);
            if (response != null && response.getReturncode().equals("0")) {
                String targetURL = response.getData().toString();
                log.info("successful query service env[{}],envConfig:[{}]", (Object)remoteURL, (Object)targetURL);
                return targetURL;
            }
        }
        return remoteURL;
    }

    public <T> T doPost(String remoteURL, MultivaluedMap<String, String> params, String type, String value, Class<T> classzz) throws Exception {
        String targetURL = this.onQueryServiceURI(remoteURL, params);
        if (StringUtils.isEmpty((Object)targetURL)) {
            targetURL = remoteURL;
        }
        return this.onPost(targetURL, params, null, type, value, classzz);
    }

    public <T> T doPost(String remoteURL, MultivaluedMap<String, String> params, Map<String, String> headerMap, String type, String value, Class<T> classzz) throws Exception {
        String targetURL = this.onQueryServiceURI(remoteURL, params);
        if (StringUtils.isEmpty((Object)targetURL)) {
            targetURL = remoteURL;
        }
        return this.onPost(targetURL, params, headerMap, type, value, classzz);
    }

    private <T> T onPost(String remoteURL, MultivaluedMap<String, String> params, Map<String, String> headerMap, String type, String value, Class<T> classzz) throws Exception {
        String targetURL = remoteURL;
        Client client = null;
        try {
            client = (Client)this.getClientPool().borrowObject();
            WebResource webResource = client.resource(remoteURL);
            if (params != null) {
                webResource = webResource.queryParams(params);
            }
            targetURL = webResource.getURI().toString();
            log.info("\u5f53\u524d\u8bf7\u6c42:{}\r\n\u5f53\u524d\u53c2\u6570:{}", (Object)targetURL, (Object)value);
            WebResource.Builder builder = webResource.getRequestBuilder();
            if (headerMap != null && headerMap.size() > 0) {
                for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                    builder = (WebResource.Builder)builder.header(entry.getKey(), (Object)entry.getValue());
                }
            }
            Object response = null;
            response = !StringUtils.isEmpty((Object)type) ? ((WebResource.Builder)builder.type(type)).post(classzz, (Object)value) : builder.post(classzz, (Object)value);
            Object object = response;
            return (T)object;
        }
        catch (Exception e) {
            System.out.println(String.format("\u5f53\u524d\u8bf7\u6c42URL:%1$s\r\nPOST\u6570\u636e:%2$s\r\n\u8fd4\u56de\u5f02\u5e38:%3$s", targetURL, value, e.getMessage()));
            e.printStackTrace();
            throw e;
        }
        finally {
            if (client != null) {
                try {
                    this.getClientPool().returnObject((Object)client);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    public String doGet(String remoteURL) throws Exception {
        return this.doGet(remoteURL, null, String.class);
    }

    public String doGet(String remoteURL, MultivaluedMap<String, String> params) throws Exception {
        return this.doGet(remoteURL, params, String.class);
    }

    public <T> T doGet(String remoteURL, MultivaluedMap<String, String> params, Class<T> classzz) throws Exception {
        return this.doGet(remoteURL, params, null, classzz);
    }

    public <T> T doGet(String remoteURL, MultivaluedMap<String, String> params, String type, Class<T> classzz) throws Exception {
        String targetURL = remoteURL;
        Client client = null;
        try {
            client = (Client)this.getClientPool().borrowObject();
            WebResource webResource = client.resource(remoteURL);
            webResource = webResource.queryParams(params);
            if (!StringUtils.isEmpty((Object)type)) {
                webResource.type(type);
            }
            targetURL = webResource.getURI().toString();
            Object response = webResource.get(classzz);
            log.info("\u5f53\u524d\u8bf7\u6c42URL:{}\r\n\u8fd4\u56de\u6570\u636e:{}", (Object)targetURL, (Object)response.toString());
            Object object = response;
            return (T)object;
        }
        catch (Exception e) {
            log.error("\u5f53\u524d\u8bf7\u6c42URL:{}\r\n\u8fd4\u56de\u5f02\u5e38:{}", new Object[]{targetURL, e.getMessage(), e});
            e.printStackTrace();
            throw e;
        }
        finally {
            if (client != null) {
                try {
                    this.getClientPool().returnObject((Object)client);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
            }
        }
    }
}

