/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.util.StringUtils;

public enum StoreDocument {
    S001("001", "\u95e8\u5e97\u8f85\u52a9\u8865\u8d27\u7ba1\u7406", "1"),
    S005("005", "\u95e8\u5e97\u8f85\u52a9\u8865\u8d27\u7ba1\u7406", "1"),
    S102("102", "\u5546\u54c1\u552e\u4ef7\u5b9a\u4ef7\u5355", "2"),
    S111("111", "\u4f9b\u5e94\u5546\u8fdb\u4ef7\u53d8\u52a8\u5355", "1"),
    S112("112", "\u5546\u54c1\u552e\u4ef7\u53d8\u52a8\u5355", "2"),
    S113("113", "\u5546\u54c1\u79ef\u5206\u7387\u53d8\u52a8\u5355", "3"),
    S124("124", "\u5546\u54c1\u964d\u62bd\u5355", "4"),
    S181("181", "\u7fa4\u7ec4\u5546\u54c1\u5206\u671f\u4fc3\u9500\u5355", "1"),
    S182("182", "\u95e8\u5e97\u5546\u54c1\u5206\u671f\u4fc3\u9500\u5355", "2"),
    S183("183", "\u7fa4\u7ec4\u5546\u54c1\u5206\u7c7b\u4fc3\u9500\u5355", "3"),
    S184("184", "\u95e8\u5e97\u5546\u54c1\u5206\u7c7b\u4fc3\u9500\u5355", "4"),
    S185("185", "\u7fa4\u7ec4\u54c1\u724c\u4fc3\u9500\u5355", "5"),
    S186("186", "\u95e8\u5e97\u54c1\u724c\u4fc3\u9500\u5355", "6"),
    S187("005", "\u7fa4\u7ec4\u5206\u7c7b\u54c1\u724c\u4fc3\u9500\u5355", "7"),
    S188("188", "\u95e8\u5e97\u751f\u9c9c\u65f6\u6bb5\u4fc3\u9500\u5355", "8"),
    S18A("18A", "\u7fa4\u7ec4\u751f\u9c9c\u65f6\u6bb5\u4fc3\u9500\u5355", "A"),
    S18B("18B", "\u95e8\u5e97\u751f\u9c9c\u65f6\u6bb5\u4fc3\u9500\u5355", "B"),
    S18C("18C", "\u7fa4\u7ec4\u4f9b\u5e94\u5546\u8fdb\u4ef7\u77ed\u671f\u53d8\u52a8\u5355", "C"),
    S18D("18D", "\u95e8\u5e97\u4f9b\u5e94\u5546\u8fdb\u4ef7\u77ed\u671f\u53d8\u52a8\u5355", "D"),
    S18E("18E", "\u9ec4\u91d1\u5546\u54c1\u4fc3\u9500\u5355", "E"),
    S18H("18H", "\u95e8\u5e97\u5546\u54c1\u5370\u82b1\u4fc3\u9500\u5355", "H"),
    S18I("18I", "\u95e8\u5e97\u54c1\u724c\u5370\u82b1\u4fc3\u9500\u5355", "I"),
    S18J("18J", "\u95e8\u5e97\u54c1\u724c\u5370\u82b1\u4fc3\u9500\u5355", "J"),
    S18K("18K", "\u95e8\u5e97\u54c1\u7c7b\u5370\u82b1\u4fc3\u9500\u5355", "K"),
    S18N("18N", "\u95e8\u5e97\u6570\u91cf\u4fc3\u9500\u5355", "N"),
    S18R("18R", "\u7fa4\u7ec4\u89c4\u5219\u4fc3\u9500\u5355", "R"),
    S18S("18S", "\u95e8\u5e97\u89c4\u5219\u4fc3\u9500\u5355", "S"),
    S201("201", "\u4ed3\u5e93\u8981\u8d27\u7533\u8bf7\u5355", "1"),
    S202("202", "\u95e8\u5e97\u8981\u8d27\u7533\u8bf7\u5355", "2"),
    S204("204", "\u4ed3\u5e93\u9000\u8d27\u7533\u8bf7\u5355", "4"),
    S205("205", "\u8fd4\u5382\u7533\u8bf7\u5355", "5"),
    S206("206", "\u95e8\u5e97\u53d6\u6d88\u8981\u8d27\u5355", "6"),
    S207("207", "\u6279\u53d1\u8981\u8d27", "7"),
    S20E("20E", "\u519c\u4ea7\u54c1\u8981\u8d27\u7533\u8bf7\u5355", "E"),
    S213("213", "\u751f\u9c9c\u8865\u8d27\u5355", "3"),
    S301("301", "\u4ed3\u5e93\u91c7\u8d2d\u8ba2\u5355", "1"),
    S302("302", "\u6b63\u89c4\u8fde\u9501\u76f4\u4f9b\u8ba2\u5355", "2"),
    S304("304", "\u95e8\u5e97\u81ea\u91c7\u8ba2\u5355", "4"),
    S308("308", "\u6b63\u89c4\u8fde\u9501\u9000\u5382\u8ba2\u5355", "B"),
    S309("309", "\u76f4\u4f9b\u7c7b\u6c47\u603b\u8ba2\u5355", "9"),
    S30A("30A", "\u4ed3\u5e93\u91c7\u8d2d\u8ba2\u5355", "A"),
    S310("310", "\u914d\u9001\u7c7b\u6c47\u603b\u8ba2\u5355", "O"),
    S311("311", "\u7d27\u6025\u8ba2\u5355", "B"),
    S312("312", "\u95e8\u5e97\u81ea\u91c7\u9000\u5382\u8ba2\u5355", "C"),
    S402("402", "\u76f4\u9001\u5546\u54c1\u9a8c\u6536\u5355", "2"),
    S404("404", "\u95e8\u5e97\u81ea\u91c7\u9a8c\u6536\u5355", "4"),
    S405("405", "\u95e8\u5e97\u89c4\u5219\u4fc3\u9500\u5355", "5"),
    S407("407", "\u8fd4\u5382\u5355", "7"),
    S409("409", "\u95e8\u5e97\u81ea\u91c7\u9000\u5382\u5355", "9"),
    S411("411", "\u9884\u6536\u8d27\u5355", "B"),
    S412("412", "\u9884\u9000\u5382\u5355", "C"),
    S421("421", "\u95e8\u5e97\u8f6c\u8d27\u5355", "1"),
    S601("601", "\u914d\u9001\u5165\u5e93\u786e\u8ba4\u5355", "1"),
    S603("603", "\u8fd4\u914d\u51fa\u5e93\u786e\u8ba4\u5355", "3"),
    S605("605", "\u914d\u9001\u5dee\u5f02\u5355", "5"),
    S606("606", "\u914d\u9500\u5355", "6"),
    S607("607", "\u914d\u9500\u9000\u8d27\u5355", "7"),
    S608("608", "\u9884\u914d\u9001\u7533\u8bf7\u5355", "8"),
    S609("609", "\u9884\u914d\u9000\u7533\u8bf7\u5355", "9"),
    S60A("60A", "\u6279\u53d1\u53d1\u8d27\u7533\u8bf7\u5355", "A"),
    S60B("60B", "\u6279\u53d1\u9000\u8d27\u7533\u8bf7\u5355", "B"),
    S60E("60E", "\u95e8\u5e97\u89c4\u5219\u4fc3\u9500\u5355", "S"),
    S612("612", "\u914d\u9500\u7533\u8bf7\u5355", "C"),
    S613("613", "\u914d\u9500\u9000\u8d27\u7533\u8bf7\u5355", "D"),
    S704("704", "\u9000\u914d\u518d\u914d\u9001\u5355", "4"),
    S705("705", "\u5546\u54c1\u67dc\u95f4\u8c03\u62e8\u5355", "5"),
    S706("706", "\u5546\u54c1\u79fb\u67dc\u5355", "6"),
    S707("707", "\u751f\u9c9c\u5546\u54c1\u5185\u90e8\u8c03\u62e8", "5"),
    S801("801", "\u5546\u54c1\u62a5\u635f\u5355", "1"),
    S802("802", "\u5546\u54c1\u62a5\u6ea2\u5355", "2"),
    S900("900", "\u5355\u54c1\u76d8\u70b9\u5355(\u5c0f\u76d8)", "1"),
    S901("901", "\u76d8\u70b9\u5355\u7ba1\u7406", "1"),
    S902("902", "\u5355\u54c1\u62bd\u6837\u76d8\u70b9\u5355", "3"),
    S903("903", "\u5c0f\u5546\u54c1\u76d8\u70b9\u5355", "2"),
    S904("904", "\u76d8\u70b9\u5dee\u9519\u5355\u7ba1\u7406", "4"),
    S905("905", "\u95e8\u5e97\u76d8\u70b9\u76c8\u4e8f\u5355\u7ba1\u7406", "5"),
    S906("906", "\u590d\u76d8\u5355\u7ba1\u7406", "6"),
    S999("999", "\u5806\u7801\u8ba1\u5212\u5f55\u5165", "1"),
    SA01("A01", "\u5546\u54c1\u62c6\u5206\u5355", "1"),
    SA02("A02", "\u5546\u54c1\u7ec4\u88c5\u5355", "2"),
    SC07("C07", "\u5546\u54c1\u6279\u53d1\u8981\u8d27\u5355", "7"),
    SP03("P03", "\u53d1\u7968\u6253\u5370", "3"),
    SR01("R01", "\u751f\u9c9c\u8f6c\u8d27\u5355", "1"),
    SR07("R07", "\u751f\u9c9c\u5206\u89e3\u5355", "1"),
    SR08("R08", "\u751f\u9c9c\u7ec4\u5408\u5355", "2"),
    SJ01("SJ01", "\u5546\u54c1\u4e0a\u67b6\u5355", "SJ"),
    SJ02("SJ02", "\u8d27\u4f4d\u5e93\u5b58\u8c03\u6574", "SJ"),
    SJ03("SJ03", "\u8d27\u4f4d\u8c03\u62e8", "SJ"),
    SJ04("SJ04", "\u8d27\u67b6\u5546\u54c1\u8865\u8d27", "SJ");

    private String documentCode;
    private String documentName;
    private String documentCategory;

    private StoreDocument(String documentCode, String documentName, String documentCategory) {
        this.documentName = documentName;
        this.documentCategory = documentCategory;
        this.documentCode = documentCode;
    }

    public String getDocumentCode() {
        return this.documentCode;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public String getDocumentCategory() {
        return this.documentCategory;
    }

    public static StoreDocument of(String code) {
        if (Objects.isNull(code) || StringUtils.isEmpty((Object)code)) {
            throw new RuntimeException("\u53c2\u6570\u4e0d\u4e3a\u7a7a");
        }
        Optional<StoreDocument> document = Stream.of(StoreDocument.values()).filter(docum -> code.equals(docum.getDocumentCode())).findAny();
        return document.orElseThrow(() -> new RuntimeException("\u95e8\u5e97\u4f5c\u4e1a\u5355\u636e\u6ca1\u6709\u6b64\u7f16\u7801"));
    }

    public static boolean isERPDocument(String code) {
        StoreDocument document;
        try {
            document = StoreDocument.of(code);
        }
        catch (RuntimeException e) {
            return false;
        }
        String documentCategory = document.getDocumentCategory();
        return Objects.nonNull(documentCategory) && !Objects.equals("SJ", documentCategory);
    }
}

