/*
 * Decompiled with CFR 0.152.
 */
package com.wfj.security.autoconfigure.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonUtil {
    private static final Logger log = LoggerFactory.getLogger(JacksonUtil.class);
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static <T> T readValue(Object obj, Class<T> classz) {
        return JacksonUtil.readValue(JacksonUtil.writeValueAsString(obj), classz);
    }

    public static <T> T readValue(String str, Class<T> bizClass) {
        try {
            return (T)objectMapper.readValue(str, bizClass);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public static <T> T readValue(String str, TypeReference typeReference) {
        try {
            return (T)objectMapper.readValue(str, typeReference);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public static String writeValueAsString(Object obj) {
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public static <T> T readTree(String str, Class<T> bizClass) {
        try {
            return (T)objectMapper.readTree(str);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public static void writeValue(JsonGenerator jgen, Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (value instanceof CharSequence) {
            jgen.writeString(value.toString());
        } else if (value instanceof Number) {
            JacksonUtil.writeNumber(jgen, (Number)value);
        } else if (value instanceof Boolean) {
            jgen.writeBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof Date) {
            Date date = (Date)value;
            jgen.writeString(date.toInstant().toString());
        } else if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            jgen.writeString(calendar.toInstant().toString());
        } else {
            jgen.writeString(value.toString());
        }
    }

    private static void writeNumber(JsonGenerator jgen, Number value) throws IOException {
        if (value instanceof Long) {
            jgen.writeNumber(value.longValue());
        } else if (value instanceof Integer) {
            jgen.writeNumber(value.intValue());
        } else if (value instanceof BigDecimal) {
            jgen.writeNumber((BigDecimal)value);
        } else if (value instanceof BigInteger) {
            jgen.writeNumber((BigInteger)value);
        } else {
            jgen.writeNumber(value.toString());
        }
    }

    public static <V> V readValue(JsonNode node, String fieldName, Class<V> type, boolean required) {
        JsonNode childNode = node.get(fieldName);
        try {
            return JacksonUtil.readValue(childNode, type, required);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error deserializing field '" + fieldName + "'.", e);
        }
    }

    public static <V> V readValue(JsonNode node, Class<V> type, boolean required) {
        V value = JacksonUtil.readValue(node, type);
        if (value == null && required) {
            throw new IllegalStateException("The value (" + type.getSimpleName() + ") is missing but was required!");
        }
        return value;
    }

    public static <V> V readValue(JsonNode node, Class<V> type) {
        V value = null;
        if (node != null && !node.isNull()) {
            try {
                value = JacksonUtil.readAtomicValue(node, type);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Error converting to: " + type.getName(), e);
            }
        }
        return value;
    }

    private static <V> V readAtomicValue(JsonNode node, Class<V> type) {
        Object result;
        if (type == Boolean.class) {
            result = node.booleanValue();
        } else if (type == Integer.class) {
            result = Integer.valueOf(node.asText());
        } else if (type == Long.class) {
            result = Long.valueOf(node.asText());
        } else if (type == Double.class) {
            result = Double.valueOf(node.asText());
        } else if (type == Float.class) {
            result = Float.valueOf(node.asText());
        } else if (type == Short.class) {
            result = Short.valueOf(node.asText());
        } else if (type == Byte.class) {
            result = Byte.valueOf(node.asText());
        } else if (type == String.class) {
            result = node.asText();
        } else if (type == BigDecimal.class) {
            result = new BigDecimal(node.asText());
        } else if (type == BigInteger.class) {
            result = new BigInteger(node.asText());
        } else if (type == Date.class) {
            result = Date.from(Instant.parse(node.asText()));
        } else if (type == Calendar.class) {
            Date date = Date.from(Instant.parse(node.asText()));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            result = calendar;
        } else if (type == Instant.class) {
            result = Instant.parse(node.asText());
        } else if (type == LocalDate.class) {
            result = LocalDate.parse(node.asText());
        } else if (type == LocalDateTime.class) {
            result = LocalDateTime.parse(node.asText());
        } else if (type == LocalTime.class) {
            result = LocalTime.parse(node.asText());
        } else if (type == OffsetDateTime.class) {
            result = OffsetDateTime.parse(node.asText());
        } else if (type == ZonedDateTime.class) {
            result = ZonedDateTime.parse(node.asText());
        } else if (type == Year.class) {
            result = Year.parse(node.asText());
        } else if (type == MonthDay.class) {
            result = type.cast(MonthDay.parse(node.asText()));
        } else {
            throw new IllegalArgumentException("Unsupported value type " + type.getName());
        }
        if (type.isPrimitive()) {
            return (V)result;
        }
        return type.cast(result);
    }
}

