/*
 * Decompiled with CFR 0.152.
 */
package com.wfj.security.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.charlemaznable.gentle.spring.factory.SpringFactory;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import com.wfj.security.autoconfigure.configfile.SysInvokeSdkConfigProperties;
import com.wfj.security.autoconfigure.utils.encrypt.KeyStoreKeyFactory;
import com.wfj.security.autoconfigure.utils.encrypt.SHA256Util;
import com.wfj.security.autoconfigure.utils.encrypt.sm4.SM4Utils;
import io.micrometer.common.util.StringUtils;
import java.security.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.JwtEncoderParameters;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtEncoder;
import org.springframework.stereotype.Service;

@Service
@SpringFactory(value={EnableAutoConfiguration.class})
public class SysInvokeSdkService {
    private static final Logger log = LoggerFactory.getLogger(SysInvokeSdkService.class);
    @Autowired
    private SysInvokeSdkConfigProperties sysInvokeSdkConfigProperties;
    @Autowired
    private ObjectMapper objectMapper;
    private JwtEncoder jwtEncoder;

    public boolean checkUcExtInfoKey(String extInfoKey) {
        if (StringUtils.isBlank((String)extInfoKey)) {
            log.error("\u9a8c\u8bc1\u6807\u8bc61\u4e3a\u7a7a");
            return false;
        }
        String key = this.sysInvokeSdkConfigProperties.getKey();
        if (StringUtils.isBlank((String)key)) {
            throw new RuntimeException("\u672a\u914d\u7f6ekey\uff0c\u65e0\u6cd5\u89e3\u5bc6extInfoKey");
        }
        String ssoAppSecret1 = this.sysInvokeSdkConfigProperties.getSsoAppSecret1();
        if (StringUtils.isBlank((String)ssoAppSecret1)) {
            throw new RuntimeException("\u672a\u914d\u7f6essoAppSecret1\uff0c\u65e0\u6cd5\u6821\u9a8c\u7cfb\u7edf\u6765\u6e90");
        }
        return this.checkUcExtInfoKey(extInfoKey, key, ssoAppSecret1);
    }

    public boolean checkUcExtInfoKey(String extInfoKey, String key, String ssoAppSecret) {
        if (StringUtils.isBlank((String)extInfoKey)) {
            log.error("extInfoKey\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((String)key)) {
            throw new RuntimeException("key\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)ssoAppSecret)) {
            throw new RuntimeException("ssoAppSecret\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String deCryptExtInfoKey = this.processDataDecryption(extInfoKey, key);
        if (StringUtils.isBlank((String)deCryptExtInfoKey)) {
            return false;
        }
        String ssoAppSecret1FromDecrypt = "";
        try {
            JsonNode jsonNode = this.objectMapper.readTree(deCryptExtInfoKey);
            ssoAppSecret1FromDecrypt = jsonNode.get("extInfoKey").asText();
            long time = jsonNode.get("time").asLong();
            if ((int)((new Date().getTime() - time) / 60000L) > 10) {
                log.error("\u8bf7\u6c42\u8d85\u8fc710\u5206\u949f\uff0c\u4e3a\u65e0\u6548\u8bf7\u6c42\uff01");
                return false;
            }
        }
        catch (JsonProcessingException e) {
            log.error("\u8bfb\u53d6[{}]\u7684\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38", (Object)extInfoKey, (Object)e);
        }
        return ssoAppSecret.equals(ssoAppSecret1FromDecrypt);
    }

    public String genSsoExtInfoKey() {
        String key = this.sysInvokeSdkConfigProperties.getKey();
        if (StringUtils.isBlank((String)key)) {
            throw new RuntimeException("\u672a\u914d\u7f6ekey\uff0c\u65e0\u6cd5\u89e3\u5bc6extInfoKey");
        }
        String ssoAppSecret2 = this.sysInvokeSdkConfigProperties.getSsoAppSecret2();
        if (StringUtils.isBlank((String)ssoAppSecret2)) {
            throw new RuntimeException("\u672a\u914d\u7f6essoAppSecret2\uff0c\u65e0\u6cd5\u6821\u9a8c\u7cfb\u7edf\u6765\u6e90");
        }
        return this.genSsoExtInfoKey(key, ssoAppSecret2);
    }

    public String genSsoExtInfoKey(String key, String ssoAppSecret) {
        if (StringUtils.isBlank((String)key)) {
            throw new RuntimeException("key\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)ssoAppSecret)) {
            throw new RuntimeException("ssoAppSecret\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String extInfoKeyWithTime = String.format("{\"extInfoKey\": \"%s\", \"time\": %s }", ssoAppSecret, new Date().getTime());
        String enCryptExtInfoKey = this.processDataEncryption(extInfoKeyWithTime, key);
        if (StringUtils.isBlank((String)enCryptExtInfoKey)) {
            throw new RuntimeException("\u751f\u6210\u9a8c\u8bc1\u6807\u8bc62\u5931\u8d25\uff01");
        }
        return enCryptExtInfoKey;
    }

    public String genSsoAutToken(Map<String, Object> claimMap) {
        if (StringUtils.isBlank((String)this.sysInvokeSdkConfigProperties.getKeyStoreFile())) {
            throw new RuntimeException("\u672a\u914d\u7f6ekeyStoreFile\uff0c\u65e0\u6cd5\u751f\u6210\u9274\u6743\u4ee4\u724c\uff01");
        }
        if (StringUtils.isBlank((String)this.sysInvokeSdkConfigProperties.getKeyStorePass())) {
            throw new RuntimeException("\u672a\u914d\u7f6ekeyStorePass\uff0c\u65e0\u6cd5\u751f\u6210\u9274\u6743\u4ee4\u724c\uff01");
        }
        if (StringUtils.isBlank((String)this.sysInvokeSdkConfigProperties.getKeyAlias())) {
            throw new RuntimeException("\u672a\u914d\u7f6ekeyAlias\uff0c\u65e0\u6cd5\u751f\u6210\u9274\u6743\u4ee4\u724c\uff01");
        }
        Instant now = Instant.now();
        JwtClaimsSet claims = JwtClaimsSet.builder().issuer("self").issuedAt(now).expiresAt(now.plus(5L, ChronoUnit.MINUTES)).subject(UUID.randomUUID().toString()).id(UUID.randomUUID().toString()).claim("claimMap", claimMap).build();
        if (this.jwtEncoder == null) {
            this.jwtEncoder = this.jwtEncoder();
        }
        Jwt jwt = this.jwtEncoder.encode(JwtEncoderParameters.from((JwtClaimsSet)claims));
        return jwt.getTokenValue();
    }

    public Map<String, Object> getDataMapFromAutToken(String autToken) {
        if (StringUtils.isBlank((String)this.sysInvokeSdkConfigProperties.getKeyStoreFile())) {
            throw new RuntimeException("\u672a\u914d\u7f6ekeyStoreFile\uff0c\u65e0\u6cd5\u89e3\u6790\u9274\u6743\u4ee4\u724c\uff01");
        }
        if (StringUtils.isBlank((String)this.sysInvokeSdkConfigProperties.getKeyStorePass())) {
            throw new RuntimeException("\u672a\u914d\u7f6ekeyStorePass\uff0c\u65e0\u6cd5\u89e3\u6790\u9274\u6743\u4ee4\u724c\uff01");
        }
        if (StringUtils.isBlank((String)this.sysInvokeSdkConfigProperties.getKeyAlias())) {
            throw new RuntimeException("\u672a\u914d\u7f6ekeyAlias\uff0c\u65e0\u6cd5\u89e3\u6790\u9274\u6743\u4ee4\u724c\uff01");
        }
        JwtDecoder jwtDecoder = this.jwtDecoder();
        Jwt jwt = jwtDecoder.decode(autToken);
        return jwt.getClaims();
    }

    public boolean checkAutToken(String autToken, Function<Map<String, Object>, Boolean> claimsSetFunction) {
        Map<String, Object> claims = this.getDataMapFromAutToken(autToken);
        if (claimsSetFunction != null) {
            return claimsSetFunction.apply(claims);
        }
        return false;
    }

    public String dataEncryption(String data4Origin) {
        String key = this.sysInvokeSdkConfigProperties.getDataKey();
        if (StringUtils.isBlank((String)key)) {
            throw new RuntimeException("\u672a\u914d\u7f6edataKey\uff0c\u65e0\u6cd5\u52a0\u5bc6\u6570\u636e");
        }
        return this.processDataEncryption(data4Origin, key);
    }

    public String dataDecryption(String data4Encryption) {
        String key = this.sysInvokeSdkConfigProperties.getDataKey();
        if (StringUtils.isBlank((String)key)) {
            throw new RuntimeException("\u672a\u914d\u7f6edataKey\uff0c\u65e0\u6cd5\u89e3\u5bc6\u6570\u636e");
        }
        return this.processDataDecryption(data4Encryption, key);
    }

    public String encodeSecret(String plainSecret) {
        return SHA256Util.encodeSecret(plainSecret);
    }

    public boolean validateSecret(String plainSecret, String secret4Encryption) {
        return SHA256Util.verifyPassword(plainSecret, secret4Encryption);
    }

    private String processDataEncryption(String data4Origin, String key) {
        String enCryptStr = null;
        try {
            enCryptStr = SM4Utils.EncryptStr(data4Origin, key);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return enCryptStr;
    }

    private String processDataDecryption(String data4Encryption, String key) {
        String deCryptStr = null;
        try {
            deCryptStr = SM4Utils.DecryptStr(data4Encryption, key);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return deCryptStr;
    }

    JwtEncoder jwtEncoder() {
        JWKSource<SecurityContext> jwks = this.jwkSource();
        return new NimbusJwtEncoder(jwks);
    }

    JwtDecoder jwtDecoder() {
        KeyPair keyPair = this.keyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        return NimbusJwtDecoder.withPublicKey((RSAPublicKey)publicKey).build();
    }

    public JWKSource<SecurityContext> jwkSource() {
        KeyPair keyPair = this.keyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAKey rsaKey = new RSAKey.Builder(publicKey).privateKey(privateKey).keyID(UUID.randomUUID().toString()).build();
        JWKSet jwkSet = new JWKSet((JWK)rsaKey);
        return new ImmutableJWKSet(jwkSet);
    }

    public KeyPair keyPair() {
        ClassPathResource ksFile = new ClassPathResource(this.sysInvokeSdkConfigProperties.getKeyStoreFile());
        KeyStoreKeyFactory ksFactory = new KeyStoreKeyFactory((Resource)ksFile, this.sysInvokeSdkConfigProperties.getKeyStorePass().toCharArray());
        return ksFactory.getKeyPair(this.sysInvokeSdkConfigProperties.getKeyAlias());
    }
}

